/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.wizard;

import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactReportMainPage
extends WizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ImpactReportMainPage.class);
    private Group directionGroup;
    private Button forward;
    private Button backward;
    public static final String ACTION_SELECTION = "actionToogle";
    public static final String NEW_ACTION = "newAction";
    public static final String LOAD_MODEL = "loadModel";
    public static final String ENTER_VARIABLE_NAME = "enterVariableName";
    public static final String BROWSE_DATASOURCE = "browseDatasourceType";
    public static final String VARIABLE_NAME = "varName";
    public static final String DATASOURCE_TYPE = "datasourceType";
    public static final String IMPACT_DIRECTION = "direction";
    public static final String MAX_CYCLES = "max cycles";
    public static final int NOLIMIT_DEPTH_VALUE = 0;
    public static final int MIN_DEPTH_VALUE = 1;
    public static final int MAX_DEPTH_VALUE = 1000;
    public static final String SQL_TABLE = Messages.getString(ImpactReportMainPage.class, "sqltable.type");
    public static final String DATASET = Messages.getString(ImpactReportMainPage.class, "dataset.type");
    public static final String DAL_FILE = Messages.getString(ImpactReportMainPage.class, "dal.type");
    public static final String BMS_PROXY = Messages.getString(ImpactReportMainPage.class, "bms.proxy.type");
    protected boolean targetSelection = true;
    private Group targetSelectionGroup;
    private Combo targetSelectionCombo = null;
    private Button datasourceChoice = null;
    private Button locInIncludesButton = null;
    private Button locInProgramsButton = null;
    private boolean showDirectionChoice;
    private Group depthChoiceGroup;
    private Button depthChoice;
    private Text depthText;
    private String description;
    private Group excludedResGroup;
    private Text excludedResText;
    private Button excludedBrowse;
    private static final String DESCRIPTION_TEXT = Messages.getString(ImpactReportMainPage.class, "page.description");
    private static final String DESCRIPTION_DIRECTION_TEXT = Messages.getString(ImpactReportMainPage.class, "page.desc.direction");

    public ImpactReportMainPage(String pageName, boolean showDirectionChoice) {
        super(pageName);
        this.description = showDirectionChoice ? DESCRIPTION_DIRECTION_TEXT : DESCRIPTION_TEXT;
        this.setDescription(this.description);
        this.showDirectionChoice = showDirectionChoice;
    }

    public ImpactReportMainPage(String pageName, boolean showDirectionChoice, boolean targetSelection) {
        super(pageName);
        this.description = showDirectionChoice ? DESCRIPTION_DIRECTION_TEXT : DESCRIPTION_TEXT;
        this.setDescription(this.description);
        this.showDirectionChoice = showDirectionChoice;
        this.targetSelection = targetSelection;
    }

    public void createControl(Composite parent) {
        Composite groups = new Composite(parent, 0);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 50;
        gd.verticalIndent = 50;
        groups.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(1, true);
        groups.setLayout((Layout)gl);
        if (this.showDirectionChoice) {
            this.createDirectionGroup(groups);
        }
        if (this.targetSelection) {
            this.createTargetSelectionGroup(groups);
        }
        this.createDepthChoiceGroup(groups);
        this.createExcludedResourcesGroup(groups);
        gd = new GridData(256);
        groups.setLayoutData((Object)gd);
        this.setControl((Control)groups);
        this.setPageComplete(this.checkDirection() && this.checkDepthValue() && this.checkTargetSelection());
    }

    private void createTargetSelectionGroup(Composite page) {
        this.targetSelectionGroup = new Group(page, 0);
        this.targetSelectionGroup.setText(Messages.getString(ImpactReportMainPage.class, "target.selection.group"));
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.targetSelectionGroup.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(2, true);
        this.targetSelectionGroup.setLayout((Layout)gl);
        this.datasourceChoice = new Button((Composite)this.targetSelectionGroup, 16);
        gd = new GridData(256);
        this.datasourceChoice.setText(Messages.getString(ImpactReportMainPage.class, "target.datasources"));
        this.datasourceChoice.setSelection(true);
        ((PrepareReportWizard)this.getWizard()).set("targetSelectionOption", (Object)BROWSE_DATASOURCE);
        this.datasourceChoice.setLayoutData((Object)gd);
        this.targetSelectionCombo = new Combo((Composite)this.targetSelectionGroup, 8);
        String[] fakeAvaiableResources = new String[]{DATASET, SQL_TABLE};
        this.targetSelectionCombo.setItems(fakeAvaiableResources);
        this.targetSelectionCombo.setEnabled(true);
        this.targetSelectionCombo.select(0);
        ((PrepareReportWizard)this.getWizard()).set(DATASOURCE_TYPE, (Object)this.targetSelectionCombo.getItem(0));
        this.locInProgramsButton = new Button((Composite)this.targetSelectionGroup, 16);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.locInProgramsButton.setText(Messages.getString(ImpactReportMainPage.class, "target.variable.in.programs"));
        this.locInProgramsButton.setLayoutData((Object)gd);
        this.locInIncludesButton = new Button((Composite)this.targetSelectionGroup, 16);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.locInIncludesButton.setText(Messages.getString(ImpactReportMainPage.class, "target.variables.in.includes"));
        this.locInIncludesButton.setLayoutData((Object)gd);
        this.targetSelectionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ImpactReportMainPage.this.targetSelectionCombo.getSelection() != null && ImpactReportMainPage.this.datasourceChoice.getSelection()) {
                    ((PrepareReportWizard)ImpactReportMainPage.this.getWizard()).set("targetSelectionOption", (Object)ImpactReportMainPage.BROWSE_DATASOURCE);
                    ((PrepareReportWizard)ImpactReportMainPage.this.getWizard()).set(ImpactReportMainPage.DATASOURCE_TYPE, (Object)ImpactReportMainPage.this.targetSelectionCombo.getItem(ImpactReportMainPage.this.targetSelectionCombo.getSelectionIndex()));
                    ImpactReportMainPage.this.setPageComplete(ImpactReportMainPage.this.checkDirection() && ImpactReportMainPage.this.checkDepthValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.datasourceChoice.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ImpactReportMainPage.this.datasourceChoice.getSelection()) {
                    ImpactReportMainPage.this.targetSelectionCombo.setEnabled(true);
                    if (ImpactReportMainPage.this.targetSelectionCombo.getSelectionIndex() != -1) {
                        ((PrepareReportWizard)ImpactReportMainPage.this.getWizard()).set("targetSelectionOption", (Object)ImpactReportMainPage.BROWSE_DATASOURCE);
                        ((PrepareReportWizard)ImpactReportMainPage.this.getWizard()).set(ImpactReportMainPage.DATASOURCE_TYPE, (Object)ImpactReportMainPage.this.targetSelectionCombo.getItem(ImpactReportMainPage.this.targetSelectionCombo.getSelectionIndex()));
                        ImpactReportMainPage.this.setPageComplete(ImpactReportMainPage.this.checkDirection() && ImpactReportMainPage.this.checkDepthValue());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.locInProgramsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ImpactReportMainPage.this.locInProgramsButton.getSelection()) {
                    ((PrepareReportWizard)ImpactReportMainPage.this.getWizard()).set("targetSelectionOption", (Object)"locVarInPrograms");
                    ImpactReportMainPage.this.targetSelectionCombo.setEnabled(false);
                    ImpactReportMainPage.this.setPageComplete(ImpactReportMainPage.this.checkDirection() && ImpactReportMainPage.this.checkDepthValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.locInIncludesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ImpactReportMainPage.this.locInIncludesButton.getSelection()) {
                    ((PrepareReportWizard)ImpactReportMainPage.this.getWizard()).set("targetSelectionOption", (Object)"locVarInIncludes");
                    ImpactReportMainPage.this.targetSelectionCombo.setEnabled(false);
                    ImpactReportMainPage.this.setPageComplete(ImpactReportMainPage.this.checkDirection() && ImpactReportMainPage.this.checkDepthValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createDirectionGroup(Composite page) {
        this.directionGroup = new Group(page, 0);
        this.directionGroup.setText(Messages.getString(ImpactReportMainPage.class, "direction.grp.txt"));
        GridLayout gl = new GridLayout(1, true);
        this.directionGroup.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.directionGroup.setLayoutData((Object)gd);
        DirectionAdapter da = new DirectionAdapter();
        this.forward = new Button((Composite)this.directionGroup, 16);
        this.forward.setText(Messages.getString(ImpactReportMainPage.class, "forward.btn.txt"));
        this.forward.setSelection(true);
        this.forward.addSelectionListener((SelectionListener)da);
        this.setDirection();
        this.backward = new Button((Composite)this.directionGroup, 16);
        this.backward.setText(Messages.getString(ImpactReportMainPage.class, "backward.btn.txt"));
        this.backward.setSelection(false);
        this.backward.addSelectionListener((SelectionListener)da);
    }

    private void createDepthChoiceGroup(Composite page) {
        this.depthChoiceGroup = new Group(page, 0);
        this.depthChoiceGroup.setText(Messages.getString(ImpactReportMainPage.class, "depth.grp.txt"));
        GridLayout gl = new GridLayout(2, false);
        this.depthChoiceGroup.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.depthChoiceGroup.setLayoutData((Object)gd);
        this.depthChoice = new Button((Composite)this.depthChoiceGroup, 32);
        this.depthChoice.setText(Messages.getString(ImpactReportMainPage.class, "depth.btn.txt"));
        this.depthChoice.setSelection(false);
        this.depthChoice.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ImpactReportMainPage.this.depthChoice.getSelection();
                ImpactReportMainPage.this.depthText.setEnabled(selected);
                ImpactReportMainPage.this.setPageComplete(ImpactReportMainPage.this.checkDepthValue() && ImpactReportMainPage.this.checkDirection() && ImpactReportMainPage.this.checkTargetSelection());
                ImpactReportMainPage.this.setDepth();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.depthText = new Text((Composite)this.depthChoiceGroup, 2052);
        gd = new GridData(256);
        gd.horizontalIndent = 5;
        gd.minimumWidth = 50;
        gd.widthHint = 50;
        this.depthText.setLayoutData((Object)gd);
        this.depthText.setEnabled(false);
        this.depthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImpactReportMainPage.this.setDepth();
                ImpactReportMainPage.this.setPageComplete(ImpactReportMainPage.this.checkDepthValue() && ImpactReportMainPage.this.checkDirection() && ImpactReportMainPage.this.checkTargetSelection());
            }
        });
        this.setDepth();
    }

    private void createExcludedResourcesGroup(Composite groups) {
        this.excludedResGroup = new Group(groups, 0);
        this.excludedResGroup.setText(Messages.getString(ImpactReportMainPage.class, "excluded.res.grp.txt"));
        GridLayout gl = new GridLayout(2, false);
        gl.marginRight = 5;
        this.excludedResGroup.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.excludedResGroup.setLayoutData((Object)gd);
        this.excludedResText = new Text((Composite)this.excludedResGroup, 2052);
        gd = new GridData(256);
        gd.horizontalIndent = 5;
        gd.minimumWidth = 50;
        gd.widthHint = 200;
        gd.grabExcessHorizontalSpace = true;
        this.excludedResText.setLayoutData((Object)gd);
        this.excludedResText.setEnabled(false);
        this.excludedBrowse = new Button((Composite)this.excludedResGroup, 8);
        this.excludedBrowse.setText(Messages.getString(ImpactReportMainPage.class, "exclude.browse.button"));
        gd = new GridData(256);
        this.excludedBrowse.setLayoutData((Object)gd);
        this.excludedBrowse.setSelection(false);
        this.excludedBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDg = new FileDialog(ImpactReportMainPage.this.excludedBrowse.getShell(), 4);
                String filePath = fileDg.open();
                if (filePath != null) {
                    ImpactReportMainPage.this.excludedResText.setText(filePath);
                }
                ((PrepareReportWizard)ImpactReportMainPage.this.getWizard()).set("excludeResFromFile", (Object)filePath);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setErrorMessage() {
        this.setMessage(Messages.getString(ImpactReportMainPage.class, "wrongDepth.error.message", new String[]{String.valueOf(1), String.valueOf(1000)}), 3);
    }

    private void setDirection() {
        boolean direction = this.forward.getSelection();
        ((PrepareReportWizard)this.getWizard()).set(IMPACT_DIRECTION, (Object)direction);
    }

    private void setDepth() {
        String depth;
        int depthInt = 0;
        if (this.depthChoice != null && this.depthChoice.getSelection() && !(depth = this.depthText.getText()).isEmpty()) {
            try {
                depthInt = Integer.valueOf(depth);
            }
            catch (NumberFormatException ex) {
                L.info("wrong value for depth; default (0) is used", (Throwable)ex);
            }
        }
        ((PrepareReportWizard)this.getWizard()).set(MAX_CYCLES, (Object)depthInt);
    }

    private boolean checkTargetSelection() {
        boolean ret = false;
        if (this.targetSelection) {
            if (this.datasourceChoice.getSelection() && this.targetSelectionCombo.getSelectionIndex() != -1) {
                ret = true;
            } else if (this.locInIncludesButton.getSelection() || this.locInProgramsButton.getSelection()) {
                ret = true;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    private boolean checkDirection() {
        boolean ret = this.forward == null && this.backward == null || this.forward != null && this.forward.getSelection() || this.backward != null && this.backward.getSelection();
        return ret;
    }

    boolean checkDepthValue() {
        boolean complete;
        block8: {
            complete = true;
            if (this.depthChoice != null) {
                if (this.depthChoice.getSelection()) {
                    String depth = this.depthText.getText();
                    try {
                        if (depth.isEmpty()) {
                            complete = false;
                        } else {
                            int depthInt = Integer.valueOf(depth);
                            boolean bl = complete = depthInt > 0 && depthInt <= 1000;
                        }
                        if (complete) {
                            this.setMessage(this.description, 0);
                            break block8;
                        }
                        this.setErrorMessage();
                    }
                    catch (NumberFormatException ex) {
                        L.warn("wrong value for depth", (Throwable)ex);
                        this.setErrorMessage();
                        complete = false;
                    }
                } else {
                    this.setMessage(this.description, 0);
                }
            }
        }
        return complete;
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
    }

    protected class DirectionAdapter
    extends SelectionAdapter {
        protected DirectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            ImpactReportMainPage.this.setDirection();
            ImpactReportMainPage.this.setPageComplete(ImpactReportMainPage.this.checkDirection() && ImpactReportMainPage.this.checkTargetSelection() && ImpactReportMainPage.this.checkDepthValue());
        }
    }
}

