/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.wizard;

import com.ez.gdb.core.analysis.inputs.SQLTable;
import com.ez.graphs.viewer.odb.analysis.wizard.DALFilesInput;
import com.ez.graphs.viewer.odb.analysis.wizard.ImpactGraphWizard;
import com.ez.graphs.viewer.odb.analysis.wizard.ImpactGraphWizardDialog;
import com.ez.graphs.viewer.odb.analysis.wizard.ImpactReportMainPage;
import com.ez.graphs.viewer.odb.analysis.wizard.SQLField;
import com.ez.graphs.viewer.odb.analysis.wizard.SelectVariablePage;
import com.ez.graphs.viewer.odb.impact.ImpactBaseModelAnalysis;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.gui.filters.AbstractProjectInputsFilter;
import com.ez.mainframe.gui.wizard.MultiSelectionPage;
import com.ez.mainframe.gui.wizard.SingleSelectionPage;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.dataset.MultipleVSAMInput;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.ScreenInput;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceDALIDSg;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.ez.workspace.model.segments.EZSourceIncludeIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProgramTypeIDSg;
import com.ez.workspace.model.segments.EZSourceSQLFieldTableIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ez.workspace.model.segments.EZSourceVariableIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactInputsFilter
extends AbstractProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ImpactInputsFilter.class);
    private int INPUT_TYPE = -1;
    private List inputs;
    private ProjectInfo prjInfo;

    protected ReportWizardDialog getWizardDialog(PrepareReportWizard wiz, Shell shell) {
        return new ImpactGraphWizardDialog(shell, (IWizard)wiz);
    }

    public ImpactInputsFilter(List inputs, ProjectInfo prjInfo) {
        this.inputs = inputs;
        this.prjInfo = prjInfo;
        if (inputs.size() == 1) {
            if (inputs.get(0) instanceof EZSourceProjectInputType) {
                this.INPUT_TYPE = 0;
            }
            if (inputs.get(0) instanceof EZEntityID) {
                this.INPUT_TYPE = 1;
            }
        } else {
            if (inputs.get(0) instanceof EZEntityID) {
                this.INPUT_TYPE = 2;
            }
            if (inputs.get(0) instanceof EZSourceProjectInputType) {
                this.INPUT_TYPE = 3;
            }
        }
    }

    protected PrepareReportWizard getWizard() {
        ImpactGraphWizard wizard = null;
        if (wizard == null) {
            wizard = new ImpactGraphWizard();
            wizard.setWindowTitle(Messages.getString(ImpactInputsFilter.class, "wizard.title"));
            wizard.set("PROJECT_INFO", this.prjInfo);
            this.addWizardPages(wizard);
        }
        return wizard;
    }

    private void addWizardPages(ImpactGraphWizard wizard) {
        boolean startOnVariable = false;
        ImpactReportMainPage mainPage = null;
        if (this.INPUT_TYPE == 0) {
            mainPage = new ImpactReportMainPage("main for impact", true);
            mainPage.setTitle(Messages.getString(ImpactInputsFilter.class, "main.page.title.target"));
            wizard.addPage((IWizardPage)mainPage);
        } else {
            mainPage = new ImpactReportMainPage("main for impact", true, false);
            mainPage.setTitle(Messages.getString(ImpactInputsFilter.class, "main.page.title.target"));
            EZEntityID ezEntity = (EZEntityID)this.inputs.get(0);
            if (ezEntity.getSegment(EZSourceSQLTableIDSg.class) instanceof EZSourceSQLTableIDSg && this.inputs.size() == 1) {
                EZSourceSQLTableIDSg sqlTableIDSg = (EZSourceSQLTableIDSg)ezEntity.getSegment(EZSourceSQLTableIDSg.class);
                String sqlTableName = sqlTableIDSg.getSQLTableName();
                wizard.set("selectedDBTableName", sqlTableName);
            } else if (this.inputs.size() == 1 && ezEntity.getSegment(EZSourceIncludeIDSg.class) instanceof EZSourceIncludeIDSg) {
                wizard.set("cobolprg=true or include=false", this.inputs);
            } else if (this.inputs.size() == 1 && ezEntity.getSegment(EZSourceProgramIDSg.class) instanceof EZSourceProgramIDSg) {
                wizard.set("cobolprg=true or include=false", this.inputs);
            }
            wizard.addPage((IWizardPage)mainPage);
            EZSourceVariableIDSg varSg = (EZSourceVariableIDSg)ezEntity.getSegment(EZSourceVariableIDSg.class);
            boolean bl = startOnVariable = varSg != null;
            if (startOnVariable) {
                wizard.set("targetSelectionOption", "enterVariableName");
                wizard.set("varName", varSg.getResourceName());
            }
        }
        wizard.set("input_type", this.INPUT_TYPE);
        SelectProgramsPage rsp = new SelectProgramsPage("resources page", Messages.getString(ImpactInputsFilter.class, "res.title.page"), Messages.getString(ImpactInputsFilter.class, "res.description.page"));
        rsp.setSelectedPropName("selected resources");
        wizard.addPage((IWizardPage)rsp);
        SingleSelectionPage ssp = new SingleSelectionPage("singleProgOrIncludePage", false);
        ssp.setSelectedPropName("selected id");
        wizard.addPage((IWizardPage)ssp);
        SingleSelectionPage sspSQL = new SingleSelectionPage("single sql resource Page", false);
        sspSQL.setSelectedPropName("selectedSQL");
        wizard.addPage((IWizardPage)sspSQL);
        MultiSelectionPage fsp = new MultiSelectionPage("fields of a table page", false);
        fsp.setLeftGroupLabel(Messages.getString(ImpactInputsFilter.class, "av.sql.fields.wizard.page.object.type"));
        fsp.setRightGroupLabel(Messages.getString(ImpactInputsFilter.class, "sel.sql.fields.wizard.page.object.type"));
        fsp.setSelectedPropName("selectedSQLFields");
        fsp.setErrMsgNoResource(Messages.getString(ImpactInputsFilter.class, "sql.fields.wizard.page.err.message"));
        fsp.setTitle(Messages.getString(ImpactInputsFilter.class, "sql.fields.wizard.page.title"));
        fsp.setDescription(Messages.getString(ImpactInputsFilter.class, "sql.fields.wizard.page.description"));
        wizard.addPage((IWizardPage)fsp);
        if (!startOnVariable) {
            SelectVariablePage vsp = new SelectVariablePage("variablesPage");
            vsp.setSelectionKey("selected variable(s)");
            wizard.addPage((IWizardPage)vsp);
        }
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) throws Exception {
        String filePath;
        ArrayList<EZEntityID> inputEntities = new ArrayList<EZEntityID>();
        Object selRes = wizard.getValue("selected resources");
        if (selRes == null) {
            selRes = wizard.getValue("selectedSQL");
        }
        Object selIDs = wizard.getValue("selected id");
        Object selSQLFields = wizard.getValue("selectedSQLFields");
        if (selRes != null && selSQLFields == null) {
            this.createEZEntitiesForResourcesOrSQLFields(wizard, (ArrayList)selRes, inputEntities);
            if (wizard.getValue("dal_ids_key") != null && !((Map)wizard.getValue("dal_ids_key")).isEmpty()) {
                analysis.addContextValue("dal_ids_key", wizard.getValue("dal_ids_key"));
            } else if (wizard.getValue("bmsproxy_ids_key") != null && !((Map)wizard.getValue("bmsproxy_ids_key")).isEmpty()) {
                analysis.addContextValue("bmsproxy_ids_key", wizard.getValue("bmsproxy_ids_key"));
            }
        } else if (selRes != null && selSQLFields != null) {
            this.createEZEntitiesForResourcesOrSQLFields(wizard, (ArrayList)selSQLFields, inputEntities);
            analysis.addContextValue("res_type", (Object)"sqlField");
        } else if (selIDs != null) {
            this.createEZEntitiesForProgsOrIncludes(analysis, wizard, (ArrayList)selIDs, inputEntities);
            analysis.addContextValue("res_type", (Object)"variable");
        } else if (wizard.getValue("targetSelectionOption") != null) {
            if (wizard.getValue("targetSelectionOption").equals("enterVariableName")) {
                String varName = (String)wizard.getValue("varName");
                ArrayList<String> list = new ArrayList<String>();
                analysis.addContextValue("resource_name_key", list);
                analysis.addContextValue("res_type", (Object)"variable");
                ArrayList<Integer> ids = new ArrayList<Integer>();
                analysis.addContextValue("var_ids_key", ids);
                List inpts = analysis.getContextListValue("input_list");
                for (EZEntityID ezID : inpts) {
                    EZSourceVariableIDSg varSg = (EZSourceVariableIDSg)ezID.getSegment(EZSourceVariableIDSg.class);
                    varName = varSg.getResourceName();
                    list.add(varName);
                    ids.add(Integer.valueOf(varSg.getVarId()));
                }
            }
        } else if (analysis.getContextValue("input_list") != null) {
            List list = (List)analysis.getContextValue("input_list");
            if (list.size() == 1 && ((EZEntityID)list.get(0)).getSegment(EZSourceSQLTableIDSg.class) != null && wizard.getValue("selectedSQLFields") != null) {
                this.createEZEntitiesForResourcesOrSQLFields(wizard, (ArrayList)selSQLFields, inputEntities);
                analysis.addContextValue("res_type", (Object)"sqlField");
            } else if (list.size() == 1 && (((EZEntityID)list.get(0)).getSegment(EZSourceProgramIDSg.class) != null || ((EZEntityID)list.get(0)).getSegment(EZSourceIncludeIDSg.class) != null)) {
                String ezName = this.findEZSourcePrgOrIncludeName((EZEntityID)list.get(0));
                ArrayList<String> selectedInput = new ArrayList<String>();
                selectedInput.add(ezName);
                this.createEZEntitiesForProgsOrIncludes(analysis, wizard, selectedInput, inputEntities);
                analysis.addContextValue("res_type", (Object)"variable");
            } else {
                inputEntities.addAll(list);
            }
        }
        if (!inputEntities.isEmpty()) {
            if (analysis.getContextValue("res_type") == null) {
                this.setResourceType((EZEntityID)inputEntities.get(0), analysis);
            }
            analysis.addContextValue("inputEntities", inputEntities);
        }
        if ((filePath = (String)wizard.getValue("excludeResFromFile")) != null) {
            analysis.addContextValue("excludeResFromFile", (Object)filePath);
        }
        if (analysis instanceof ImpactBaseModelAnalysis) {
            ImpactBaseModelAnalysis ibma = (ImpactBaseModelAnalysis)analysis;
            analysis.addContextValue("analysis_hash_key", (Object)ibma.hash(ibma.toString()));
        }
    }

    private List<String> getNameForIncludeOrSidForProgram(EZEntityID ezEntityID, PrepareReportWizard wizard, List<EZEntityID> inputs) {
        ArrayList<String> list = new ArrayList<String>();
        String includeName = null;
        Integer prgSid = null;
        if (ezEntityID.getSegment(EZSourceIncludeIDSg.class) != null) {
            includeName = this.findEZSourcePrgOrIncludeName(ezEntityID);
            list.add(includeName);
        } else if (ezEntityID.getSegment(EZSourceProgramIDSg.class) != null) {
            EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)ezEntityID.getSegment(EZSourceProgramIDSg.class);
            prgSid = prgSg.getProgramId();
            list.add(prgSid.toString());
        }
        inputs.add(ezEntityID);
        return list;
    }

    public String findEZSourcePrgOrIncludeName(EZEntityID ezEntityID) {
        String ezName = null;
        if (ezEntityID.getSegment(EZSourceIncludeIDSg.class) != null) {
            EZSourceIncludeIDSg includeSg = (EZSourceIncludeIDSg)ezEntityID.getSegment(EZSourceIncludeIDSg.class);
            ezName = includeSg.getIncludeName();
        } else if (ezEntityID.getSegment(EZSourceProgramIDSg.class) != null) {
            EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)ezEntityID.getSegment(EZSourceProgramIDSg.class);
            ezName = prgSg.getProgramName();
        }
        return ezName;
    }

    private void createEZEntitiesForResourcesOrSQLFields(PrepareReportWizard wizard, ArrayList<BaseMainframeResource4GUI> guiList, List<EZEntityID> inputEntities) {
        HashMap<String, String> dalRes = null;
        HashMap<String, String> bmsProxyRes = null;
        for (BaseMainframeResource4GUI brgui : guiList) {
            EZEntityID entity = new EZEntityID();
            if (brgui.getObject() instanceof SQLField) {
                SQLField field = (SQLField)brgui.getObject();
                EZSourceSQLFieldTableIDSg fieldSg = new EZSourceSQLFieldTableIDSg(field.getSqlFieldName(), field.getResourceID(), (String)wizard.getValue("selectedDBTableName"));
                entity.addSegment((EZSegment)fieldSg);
            } else if (brgui.getObject() instanceof SQLTable) {
                SQLTable table = (SQLTable)brgui.getObject();
                EZSourceSQLTableIDSg tableSg = new EZSourceSQLTableIDSg(table.getSqlTableName());
                entity.addSegment((EZSegment)tableSg);
            } else if (brgui.getObject() instanceof MultipleVSAMInput) {
                MultipleVSAMInput dataset = (MultipleVSAMInput)brgui.getObject();
                String generationNumber = null;
                EZSourceDatasetIDSg datasetSg = new EZSourceDatasetIDSg(dataset.getListableName(), dataset.getResourceID(), generationNumber);
                entity.addSegment((EZSegment)datasetSg);
            } else if (brgui.getObject() instanceof DALFilesInput) {
                if (dalRes == null) {
                    dalRes = new HashMap<String, String>();
                }
                DALFilesInput dal = (DALFilesInput)brgui.getObject();
                EZSourceDALIDSg dalSg = new EZSourceDALIDSg(dal.getDALName(), dal.getOdbRID());
                entity.addSegment((EZSegment)dalSg);
                dalRes.put(dal.getDALName(), dal.getOdbRID());
            } else if (brgui.getObject() instanceof ScreenInput) {
                if (bmsProxyRes == null) {
                    bmsProxyRes = new HashMap<String, String>();
                }
                ScreenInput bmsproxy = (ScreenInput)brgui.getObject();
                EZSourceScreenIDSg screenSg = new EZSourceScreenIDSg(bmsproxy.getName(), bmsproxy.getMapSet(), null, bmsproxy.getType(), bmsproxy.getOdbRID());
                entity.addSegment((EZSegment)screenSg);
                bmsProxyRes.put(bmsproxy.getName(), bmsproxy.getOdbRID());
            }
            inputEntities.add(entity);
            if (dalRes != null) {
                wizard.set("dal_ids_key", dalRes);
                continue;
            }
            if (bmsProxyRes == null) continue;
            wizard.set("bmsproxy_ids_key", bmsProxyRes);
        }
    }

    private void createEZEntitiesForProgsOrIncludes(AbstractAnalysis analysis, PrepareReportWizard wizard, ArrayList prgOrInclList, List<EZEntityID> inputEntities) {
        ArrayList<EZEntityID> inpts = null;
        List selInputs = analysis.getContextListValue("input_list");
        if (selInputs.size() == 1 && selInputs.get(0) instanceof EZSourceProjectInputType) {
            inpts = new ArrayList();
            EZEntityID prjEntID = ((EZSourceProjectInputType)selInputs.get(0)).getEntID();
            try {
                prjEntID = prjEntID.clone();
            }
            catch (CloneNotSupportedException e) {
                L.error("cannot clone projectEntityID", (Throwable)e);
            }
            inpts.add(prjEntID);
            BaseMainframeResource4GUI prg = (BaseMainframeResource4GUI)prgOrInclList.get(0);
            String resName = prg.getObject().getName();
            Integer resId = prg.getObject().getResourceID();
            Integer typeId = prg.getObject().getTypeCode();
            if ("locVarInPrograms".equals(wizard.getValue("targetSelectionOption")) && prjEntID.getSegment(EZSourceProgramIDSg.class) == null) {
                prjEntID.addSegment((EZSegment)new EZSourceProgramIDSg(resName, resId, typeId));
            } else if ("locVarInIncludes".equals(wizard.getValue("targetSelectionOption"))) {
                prjEntID.addSegment((EZSegment)new EZSourceIncludeIDSg(resName, resId));
                prjEntID.addSegment((EZSegment)new EZSourceProgramTypeIDSg(typeId));
            }
        } else {
            inpts = new ArrayList<EZEntityID>(selInputs);
        }
        ArrayList selVar = (ArrayList)wizard.getValue("selected variable(s)");
        boolean completeInputs = selVar.size() != inpts.size() || ((EZEntityID)inpts.get(0)).getSegment(EZSourceVariableIDSg.class) == null;
        ArrayList<EZEntityID> newinpts = completeInputs ? new ArrayList<EZEntityID>() : null;
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (SelectSingleFromListPage.ArrayListItem item : selVar) {
            String varName = item.getStringArray()[1];
            list.add(varName);
            ids.add(Integer.valueOf(item.getStringArray()[2]));
            if (!completeInputs) continue;
            EZEntityID newId = (EZEntityID)inpts.get(0);
            try {
                newId = newId.clone();
            }
            catch (CloneNotSupportedException e) {
                L.error("error at cloning", (Throwable)e);
            }
            newinpts.add(newId);
            if (newId.getSegment(EZSourceIncludeIDSg.class) != null) {
                Integer prgType = ((EZSourceProgramTypeIDSg)newId.getSegment(EZSourceProgramTypeIDSg.class)).getProgramTypeId();
                newId.addSegment((EZSegment)new EZSourceProgramIDSg(item.getStringArray()[item.getStringArray().length - 1], null, prgType));
            }
            EZSourceVariableIDSg varSg = new EZSourceVariableIDSg(varName, null, null, null, null, null, null, null, null, null, null);
            newId.addSegment((EZSegment)varSg);
        }
        if (completeInputs) {
            analysis.addContextValue("input_list", newinpts);
        }
        analysis.addContextValue("resource_name_key", list);
        analysis.addContextValue("var_ids_key", ids);
        analysis.addContextValue("res_type", (Object)"variable");
    }

    private void setResourceType(EZEntityID entityId, AbstractAnalysis analysis) {
        if (entityId.getSegment(EZSourceSQLTableIDSg.class) != null) {
            analysis.addContextValue("res_type", (Object)"sqlTable");
        } else if (entityId.getSegment(EZSourceDatasetIDSg.class) != null) {
            analysis.addContextValue("res_type", (Object)"dataset");
        } else if (entityId.getSegment(EZSourceSQLFieldTableIDSg.class) != null) {
            analysis.addContextValue("res_type", (Object)"sqlField");
        } else if (entityId.getSegment(EZSourceDALIDSg.class) != null) {
            analysis.addContextValue("res_type", (Object)"dalFile");
        } else if (entityId.getSegment(EZSourceProgramIDSg.class) != null) {
            EZSourceProgramIDSg cfr_ignored_0 = (EZSourceProgramIDSg)entityId.getSegment(EZSourceProgramIDSg.class);
            analysis.addContextValue("res_type", (Object)"cobolprogram");
        } else if (entityId.getSegment(EZSourceIncludeIDSg.class) != null) {
            analysis.addContextValue("res_type", (Object)"include");
        } else if (entityId.getSegment(EZSourceScreenIDSg.class) != null) {
            analysis.addContextValue("res_type", (Object)"screen");
        }
    }
}

