/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.wizard;

import com.ez.gdb.core.analysis.inputs.SQLTable;
import com.ez.gdb.core.collectors.ODBDatasetCollector;
import com.ez.gdb.core.collectors.ODBProgramCollector;
import com.ez.gdb.core.collectors.ODBTableCollector;
import com.ez.graphs.viewer.odb.analysis.collectors.ODBDALCollector;
import com.ez.graphs.viewer.odb.analysis.collectors.ODBIncludeCollector;
import com.ez.graphs.viewer.odb.analysis.collectors.ODBScreenCollector;
import com.ez.graphs.viewer.odb.analysis.collectors.ODBTableFieldsCollector;
import com.ez.graphs.viewer.odb.analysis.collectors.VariableDetailProvider;
import com.ez.graphs.viewer.odb.analysis.wizard.ImpactReportMainPage;
import com.ez.graphs.viewer.odb.analysis.wizard.SelectVariablePage;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.mainframe.gui.wizard.MultiSelectionPage;
import com.ez.mainframe.gui.wizard.SingleSelectionPage;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.application.ui.wizard.SelectAbstractProgramsPage;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactGraphWizardDialog
extends ReportWizardDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ImpactGraphWizardDialog.class);
    IWizard wizard = null;

    public ImpactGraphWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
        this.wizard = newWizard;
    }

    public void handlePageChanging(PageChangingEvent event) {
        L.debug("handlePageChanging()::{}", (Object)event);
        IWizardPage nextPage = (IWizardPage)event.getTargetPage();
        ((ProjectInfo)((PrepareReportWizard)this.wizard).getValue("PROJECT_INFO")).getName();
        if ("resources page".equals(nextPage.getName()) || "singleProgOrIncludePage".equals(nextPage.getName())) {
            Object pc;
            String datasourceType = (String)((PrepareReportWizard)this.wizard).getValue("datasourceType");
            String target = (String)((PrepareReportWizard)this.wizard).getValue("targetSelectionOption");
            if (target.equals("locVarInPrograms")) {
                ((SingleSelectionPage)nextPage).setLeftGroupLabel(Messages.getString(ImpactGraphWizardDialog.class, "available.program.type"));
                pc = new ODBProgramCollector();
                ((SingleSelectionPage)nextPage).setResourcesCollector((ResourcesCollector)pc);
                String title = Messages.getString(ImpactGraphWizardDialog.class, "title.detailed", new String[]{Messages.getString(ImpactGraphWizardDialog.class, "program.type")});
                String description = Messages.getString(ImpactGraphWizardDialog.class, "description");
                ((SingleSelectionPage)nextPage).setTitle(title);
                ((SingleSelectionPage)nextPage).setDescription(description);
            } else if (target.equals("locVarInIncludes")) {
                ((SingleSelectionPage)nextPage).setLeftGroupLabel(Messages.getString(ImpactGraphWizardDialog.class, "available.include.type"));
                pc = new ODBIncludeCollector();
                ((SingleSelectionPage)nextPage).setResourcesCollector((ResourcesCollector)pc);
                String title = Messages.getString(ImpactGraphWizardDialog.class, "title.detailed", new String[]{Messages.getString(ImpactGraphWizardDialog.class, "include.type")});
                String description = Messages.getString(ImpactGraphWizardDialog.class, "description");
                ((SingleSelectionPage)nextPage).setTitle(title);
                ((SingleSelectionPage)nextPage).setDescription(description);
            } else if (target.equals("browseDatasourceType") && datasourceType.equals(ImpactReportMainPage.DATASET)) {
                ((SelectProgramsPage)nextPage).setLeftGroupLabel(Messages.getString(ImpactGraphWizardDialog.class, "available.dataset.res"));
                ((SelectProgramsPage)nextPage).setRightGroupLabel(Messages.getString(ImpactGraphWizardDialog.class, "selected.dataset.res"));
                ODBDatasetCollector datasetCollector = new ODBDatasetCollector(true);
                ((SelectProgramsPage)nextPage).setResourcesCollector((ResourcesCollector)datasetCollector);
            } else if (target.equals("browseDatasourceType") && datasourceType.equals(ImpactReportMainPage.DAL_FILE)) {
                ((SelectProgramsPage)nextPage).setLeftGroupLabel(Messages.getString(ImpactGraphWizardDialog.class, "available.dal.res"));
                ((SelectProgramsPage)nextPage).setRightGroupLabel(Messages.getString(ImpactGraphWizardDialog.class, "selected.dal.res"));
                ODBDALCollector dalCollector = new ODBDALCollector();
                ((SelectProgramsPage)nextPage).setResourcesCollector((ResourcesCollector)dalCollector);
            } else if (target.equals("browseDatasourceType") && datasourceType.equals(ImpactReportMainPage.BMS_PROXY)) {
                ((SelectProgramsPage)nextPage).setLeftGroupLabel(Messages.getString(ImpactGraphWizardDialog.class, "available.bmsproxy.res"));
                ((SelectProgramsPage)nextPage).setRightGroupLabel(Messages.getString(ImpactGraphWizardDialog.class, "selected.bmsproxy.res"));
                ODBScreenCollector bmsproxyCollector = new ODBScreenCollector();
                ((SelectProgramsPage)nextPage).setResourcesCollector((ResourcesCollector)bmsproxyCollector);
            }
        }
        if ("single sql resource Page".equals(nextPage.getName())) {
            ((SingleSelectionPage)nextPage).setLeftGroupLabel(Messages.getString(ImpactGraphWizardDialog.class, "available.sql.table.res"));
            ODBTableCollector sqlTablesCollector = new ODBTableCollector();
            ((SingleSelectionPage)nextPage).setResourcesCollector((ResourcesCollector)sqlTablesCollector);
            String title = Messages.getString(ImpactGraphWizardDialog.class, "title.detailed", new String[]{Messages.getString(ImpactGraphWizardDialog.class, "sql.type")});
            String description = Messages.getString(ImpactGraphWizardDialog.class, "description");
            ((SingleSelectionPage)nextPage).setTitle(title);
            ((SingleSelectionPage)nextPage).setDescription(description);
        }
        if ("fields of a table page".equals(nextPage.getName())) {
            ArrayList obj = (ArrayList)((PrepareReportWizard)this.wizard).getValue("selectedSQL");
            if (obj != null) {
                SQLTable sqlTable = (SQLTable)((BaseMainframeResource4GUI)obj.get(0)).getObject();
                ((PrepareReportWizard)this.wizard).set("selectedDBTableName", (Object)sqlTable.getName());
            }
            ODBTableFieldsCollector fieldCollector = new ODBTableFieldsCollector((String)((PrepareReportWizard)this.wizard).getValue("selectedDBTableName"));
            ((MultiSelectionPage)nextPage).setResourcesCollector((ResourcesCollector)fieldCollector);
        }
        if ("variablesPage".equals(nextPage.getName())) {
            VariableDetailProvider vdp = new VariableDetailProvider((PrepareReportWizard)this.wizard, ((ProjectInfo)((PrepareReportWizard)this.wizard).getValue("PROJECT_INFO")).getName());
            ((SelectVariablePage)nextPage).setItemProvider(vdp);
        }
        if ("singleProgOrIncludePage".equals(nextPage.getName()) || "variablesPage".equals(nextPage.getName())) {
            IWizardPage currentPage = (IWizardPage)event.getCurrentPage();
            ((PrepareReportWizard)this.getWizard()).setChangeDirection(currentPage, nextPage);
        }
        if ("fields of a table page".equals(nextPage.getName()) || "resources page".equals(nextPage.getName()) || "singleProgOrIncludePage".equals(nextPage.getName()) || "single sql resource Page".equals(nextPage.getName())) {
            SelectAbstractProgramsPage page = (SelectAbstractProgramsPage)nextPage;
            page.setRunSearch(true);
            page.fillUIWithProgress();
        } else {
            L.debug("page: {}", (Object)nextPage);
        }
    }

    protected void backPressed() {
        ((PrepareReportWizard)this.wizard).set("selected resources", null);
        ((PrepareReportWizard)this.wizard).set("selectedSQL", null);
        ((PrepareReportWizard)this.wizard).set("selectedSQLFields", null);
        ((PrepareReportWizard)this.wizard).set("selected variable(s)", null);
        if (!((PrepareReportWizard)this.wizard).getContainer().getCurrentPage().getName().equals("variablesPage")) {
            ((PrepareReportWizard)this.wizard).set("selected id", null);
        }
        super.backPressed();
    }
}

