/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.wizard;

import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactGraphMainPage
extends WizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ImpactGraphMainPage.class);
    private Group directionGroup;
    private Button forward;
    private Button backward;
    public static final String ACTION_SELECTION = "actionToogle";
    public static final String NEW_ACTION = "newAction";
    public static final String LOAD_MODEL = "loadModel";
    public static final String ENTER_VARIABLE_NAME = "enterVariableName";
    public static final String BROWSE_DATASOURCE = "browseDatasourceType";
    public static final String VARIABLE_NAME = "varName";
    public static final String DATASOURCE_TYPE = "datasourceType";
    public static final String IMPACT_DIRECTION = "forward_key";
    public static final String MAX_CYCLES = "max cycles";
    public static final int NOLIMIT_DEPTH_VALUE = 0;
    public static final int MIN_DEPTH_VALUE = 1;
    public static final int MAX_DEPTH_VALUE = 1000;
    public static final String SQL_TABLE = Messages.getString(ImpactGraphMainPage.class, "sqltable.type");
    public static final String DATASET = Messages.getString(ImpactGraphMainPage.class, "dataset.type");
    public static final String DAL_FILE = Messages.getString(ImpactGraphMainPage.class, "dal.type");
    public static final String BMS_PROXY = Messages.getString(ImpactGraphMainPage.class, "bms.proxy.type");
    private Button newAnalysis = null;
    private Button loadAnalysis = null;
    protected boolean targetSelection = false;
    private Group targetSelectionGroup;
    private Combo targetSelectionCombo = null;
    private Button datasourceChoice = null;
    private Button locInIncludesButton = null;
    private Button locInProgramsButton = null;
    private boolean showDirectionChoice;
    private Group depthChoiceGroup;
    private Button depthChoice;
    private Text depthText;
    private String description;
    private Group excludedResGroup;
    private Text excludedResText;
    private Button excludedBrowse;
    private static final String DESCRIPTION_TEXT = Messages.getString(ImpactGraphMainPage.class, "page.description");
    private static final String DESCRIPTION_DIRECTION_TEXT = Messages.getString(ImpactGraphMainPage.class, "page.desc.direction");
    private static final String DESCRIPTION_LOAD_ANALYSIS_TEXT = Messages.getString(ImpactGraphMainPage.class, "load.analysis");

    public ImpactGraphMainPage(String pageName, boolean showDirectionChoice) {
        super(pageName);
        this.description = showDirectionChoice ? DESCRIPTION_DIRECTION_TEXT : DESCRIPTION_TEXT;
        this.setDescription(this.description);
        this.showDirectionChoice = showDirectionChoice;
    }

    public ImpactGraphMainPage(String pageName, boolean showDirectionChoice, boolean targetSelection) {
        super(pageName);
        this.description = showDirectionChoice ? DESCRIPTION_DIRECTION_TEXT : DESCRIPTION_TEXT;
        this.setDescription(this.description);
        this.showDirectionChoice = showDirectionChoice;
        this.targetSelection = true;
    }

    public void createControl(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        page.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        page.setLayoutData((Object)gd);
        if (this.targetSelection) {
            this.newAnalysis = new Button(page, 16);
            this.newAnalysis.setText(Messages.getString(ImpactGraphMainPage.class, "new.analysis.button.label"));
            gd = new GridData(32);
            gd.grabExcessHorizontalSpace = false;
            this.newAnalysis.setLayoutData((Object)gd);
            this.newAnalysis.setSelection(true);
            ((PrepareReportWizard)this.getWizard()).set(ACTION_SELECTION, (Object)NEW_ACTION);
            this.newAnalysis.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (ImpactGraphMainPage.this.newAnalysis.getSelection()) {
                        ImpactGraphMainPage.this.forward.setEnabled(true);
                        ImpactGraphMainPage.this.backward.setEnabled(true);
                        ImpactGraphMainPage.this.depthChoice.setEnabled(true);
                        ImpactGraphMainPage.this.depthText.setEnabled(true);
                        ImpactGraphMainPage.this.datasourceChoice.setEnabled(true);
                        ImpactGraphMainPage.this.targetSelectionCombo.setEnabled(true);
                        ImpactGraphMainPage.this.locInIncludesButton.setEnabled(true);
                        ImpactGraphMainPage.this.locInProgramsButton.setEnabled(true);
                        ImpactGraphMainPage.this.excludedBrowse.setEnabled(true);
                        ImpactGraphMainPage.this.checkDepthValue();
                        ((PrepareReportWizard)ImpactGraphMainPage.this.getWizard()).set(ImpactGraphMainPage.ACTION_SELECTION, (Object)ImpactGraphMainPage.NEW_ACTION);
                        ImpactGraphMainPage.this.setPageComplete(ImpactGraphMainPage.this.isLoadAction() || ImpactGraphMainPage.this.checkDirection() && ImpactGraphMainPage.this.checkDepthValue() && ImpactGraphMainPage.this.checkTargetSelection());
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Composite groups = new Composite(page, 0);
            gd = new GridData(256);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalIndent = 50;
            groups.setLayoutData((Object)gd);
            gl = new GridLayout(1, true);
            groups.setLayout((Layout)gl);
            if (this.showDirectionChoice) {
                this.createDirectionGroup(groups);
            }
            this.createTargetSelectionGroup(groups);
            this.createDepthChoiceGroup(groups);
            this.createExcludedResourcesGroup(groups);
            this.loadAnalysis = new Button(page, 16);
            this.loadAnalysis.setText(Messages.getString(ImpactGraphMainPage.class, "load.analysis.button.label"));
            gd = new GridData(32);
            this.loadAnalysis.setLayoutData((Object)gd);
            this.loadAnalysis.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (ImpactGraphMainPage.this.loadAnalysis.getSelection()) {
                        ImpactGraphMainPage.this.forward.setEnabled(false);
                        ImpactGraphMainPage.this.backward.setEnabled(false);
                        ImpactGraphMainPage.this.depthChoice.setEnabled(false);
                        ImpactGraphMainPage.this.depthText.setEnabled(false);
                        ImpactGraphMainPage.this.datasourceChoice.setEnabled(false);
                        ImpactGraphMainPage.this.locInIncludesButton.setEnabled(false);
                        ImpactGraphMainPage.this.locInProgramsButton.setEnabled(false);
                        ImpactGraphMainPage.this.targetSelectionCombo.setEnabled(false);
                        ImpactGraphMainPage.this.setMessage(DESCRIPTION_LOAD_ANALYSIS_TEXT, 0);
                        ((PrepareReportWizard)ImpactGraphMainPage.this.getWizard()).set(ImpactGraphMainPage.ACTION_SELECTION, (Object)ImpactGraphMainPage.LOAD_MODEL);
                        ImpactGraphMainPage.this.excludedBrowse.setEnabled(false);
                        ImpactGraphMainPage.this.excludedResText.setText("");
                        ImpactGraphMainPage.this.setPageComplete(ImpactGraphMainPage.this.isLoadAction() || ImpactGraphMainPage.this.checkDirection() && ImpactGraphMainPage.this.checkDepthValue() && ImpactGraphMainPage.this.checkTargetSelection());
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else {
            if (this.showDirectionChoice) {
                this.createDirectionGroup(page);
            }
            this.createDepthChoiceGroup(page);
            this.createExcludedResourcesGroup(page);
        }
        this.setControl((Control)page);
        this.setPageComplete(this.isLoadAction() || this.checkDirection() && this.checkDepthValue() && this.checkTargetSelection());
    }

    private boolean isLoadAction() {
        PrepareReportWizard wiz = (PrepareReportWizard)this.getWizard();
        return wiz.getValue(ACTION_SELECTION) != null && wiz.getValue(ACTION_SELECTION).equals(LOAD_MODEL);
    }

    private void createTargetSelectionGroup(Composite page) {
        this.targetSelectionGroup = new Group(page, 0);
        this.targetSelectionGroup.setText(Messages.getString(ImpactGraphMainPage.class, "target.selection.group"));
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.targetSelectionGroup.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(2, true);
        this.targetSelectionGroup.setLayout((Layout)gl);
        this.datasourceChoice = new Button((Composite)this.targetSelectionGroup, 16);
        gd = new GridData(256);
        this.datasourceChoice.setText(Messages.getString(ImpactGraphMainPage.class, "target.datasources"));
        this.datasourceChoice.setSelection(true);
        ((PrepareReportWizard)this.getWizard()).set("targetSelectionOption", (Object)BROWSE_DATASOURCE);
        this.datasourceChoice.setLayoutData((Object)gd);
        this.targetSelectionCombo = new Combo((Composite)this.targetSelectionGroup, 8);
        String[] fakeAvaiableResources = new String[]{DATASET, SQL_TABLE, DAL_FILE, BMS_PROXY};
        this.targetSelectionCombo.setItems(fakeAvaiableResources);
        this.targetSelectionCombo.setEnabled(true);
        this.targetSelectionCombo.select(0);
        ((PrepareReportWizard)this.getWizard()).set(DATASOURCE_TYPE, (Object)this.targetSelectionCombo.getItem(0));
        this.locInProgramsButton = new Button((Composite)this.targetSelectionGroup, 16);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.locInProgramsButton.setText(Messages.getString(ImpactGraphMainPage.class, "target.variable.in.programs"));
        this.locInProgramsButton.setLayoutData((Object)gd);
        this.locInIncludesButton = new Button((Composite)this.targetSelectionGroup, 16);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.locInIncludesButton.setText(Messages.getString(ImpactGraphMainPage.class, "target.variables.in.includes"));
        this.locInIncludesButton.setLayoutData((Object)gd);
        this.targetSelectionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ImpactGraphMainPage.this.targetSelectionCombo.getSelection() != null && ImpactGraphMainPage.this.datasourceChoice.getSelection()) {
                    ((PrepareReportWizard)ImpactGraphMainPage.this.getWizard()).set("targetSelectionOption", (Object)ImpactGraphMainPage.BROWSE_DATASOURCE);
                    ((PrepareReportWizard)ImpactGraphMainPage.this.getWizard()).set(ImpactGraphMainPage.DATASOURCE_TYPE, (Object)ImpactGraphMainPage.this.targetSelectionCombo.getItem(ImpactGraphMainPage.this.targetSelectionCombo.getSelectionIndex()));
                    ImpactGraphMainPage.this.setPageComplete(ImpactGraphMainPage.this.isLoadAction() || ImpactGraphMainPage.this.checkDirection() && ImpactGraphMainPage.this.checkDepthValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.datasourceChoice.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ImpactGraphMainPage.this.datasourceChoice.getSelection()) {
                    ImpactGraphMainPage.this.targetSelectionCombo.setEnabled(true);
                    if (ImpactGraphMainPage.this.targetSelectionCombo.getSelectionIndex() != -1) {
                        ((PrepareReportWizard)ImpactGraphMainPage.this.getWizard()).set("targetSelectionOption", (Object)ImpactGraphMainPage.BROWSE_DATASOURCE);
                        ((PrepareReportWizard)ImpactGraphMainPage.this.getWizard()).set(ImpactGraphMainPage.DATASOURCE_TYPE, (Object)ImpactGraphMainPage.this.targetSelectionCombo.getItem(ImpactGraphMainPage.this.targetSelectionCombo.getSelectionIndex()));
                        ImpactGraphMainPage.this.setPageComplete(ImpactGraphMainPage.this.isLoadAction() || ImpactGraphMainPage.this.checkDirection() && ImpactGraphMainPage.this.checkDepthValue());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.locInProgramsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ImpactGraphMainPage.this.locInProgramsButton.getSelection()) {
                    ((PrepareReportWizard)ImpactGraphMainPage.this.getWizard()).set("targetSelectionOption", (Object)"locVarInPrograms");
                    ImpactGraphMainPage.this.targetSelectionCombo.setEnabled(false);
                    ImpactGraphMainPage.this.setPageComplete(ImpactGraphMainPage.this.isLoadAction() || ImpactGraphMainPage.this.checkDirection() && ImpactGraphMainPage.this.checkDepthValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.locInIncludesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ImpactGraphMainPage.this.locInIncludesButton.getSelection()) {
                    ((PrepareReportWizard)ImpactGraphMainPage.this.getWizard()).set("targetSelectionOption", (Object)"locVarInIncludes");
                    ImpactGraphMainPage.this.targetSelectionCombo.setEnabled(false);
                    ImpactGraphMainPage.this.setPageComplete(ImpactGraphMainPage.this.isLoadAction() || ImpactGraphMainPage.this.checkDirection() && ImpactGraphMainPage.this.checkDepthValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createDirectionGroup(Composite page) {
        this.directionGroup = new Group(page, 0);
        this.directionGroup.setText(Messages.getString(ImpactGraphMainPage.class, "direction.grp.txt"));
        GridLayout gl = new GridLayout(1, true);
        this.directionGroup.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.directionGroup.setLayoutData((Object)gd);
        DirectionAdapter da = new DirectionAdapter();
        this.forward = new Button((Composite)this.directionGroup, 16);
        this.forward.setText(Messages.getString(ImpactGraphMainPage.class, "forward.btn.txt"));
        this.forward.setSelection(true);
        this.forward.addSelectionListener((SelectionListener)da);
        this.setDirection();
        this.backward = new Button((Composite)this.directionGroup, 16);
        this.backward.setText(Messages.getString(ImpactGraphMainPage.class, "backward.btn.txt"));
        this.backward.setSelection(false);
        this.backward.addSelectionListener((SelectionListener)da);
    }

    private void createDepthChoiceGroup(Composite page) {
        this.depthChoiceGroup = new Group(page, 0);
        this.depthChoiceGroup.setText(Messages.getString(ImpactGraphMainPage.class, "depth.grp.txt"));
        GridLayout gl = new GridLayout(2, false);
        this.depthChoiceGroup.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.depthChoiceGroup.setLayoutData((Object)gd);
        this.depthChoice = new Button((Composite)this.depthChoiceGroup, 32);
        this.depthChoice.setText(Messages.getString(ImpactGraphMainPage.class, "depth.btn.txt"));
        this.depthChoice.setSelection(false);
        this.depthChoice.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ImpactGraphMainPage.this.depthChoice.getSelection();
                ImpactGraphMainPage.this.depthText.setEnabled(selected);
                ImpactGraphMainPage.this.setPageComplete(ImpactGraphMainPage.this.isLoadAction() || ImpactGraphMainPage.this.checkDepthValue() && ImpactGraphMainPage.this.checkDirection() && ImpactGraphMainPage.this.checkTargetSelection());
                ImpactGraphMainPage.this.setDepth();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.depthText = new Text((Composite)this.depthChoiceGroup, 2052);
        gd = new GridData(256);
        gd.horizontalIndent = 5;
        gd.minimumWidth = 50;
        gd.widthHint = 50;
        this.depthText.setLayoutData((Object)gd);
        this.depthText.setEnabled(false);
        this.depthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImpactGraphMainPage.this.setDepth();
                ImpactGraphMainPage.this.setPageComplete(ImpactGraphMainPage.this.checkDepthValue() && ImpactGraphMainPage.this.checkDirection() && ImpactGraphMainPage.this.checkTargetSelection());
            }
        });
        this.setDepth();
    }

    private void createExcludedResourcesGroup(Composite groups) {
        this.excludedResGroup = new Group(groups, 0);
        this.excludedResGroup.setText(Messages.getString(ImpactGraphMainPage.class, "excluded.res.grp.txt"));
        GridLayout gl = new GridLayout(2, false);
        this.excludedResGroup.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.excludedResGroup.setLayoutData((Object)gd);
        this.excludedResText = new Text((Composite)this.excludedResGroup, 2052);
        gd = new GridData(256);
        gd.horizontalIndent = 5;
        gd.minimumWidth = 50;
        gd.widthHint = 100;
        this.excludedResText.setLayoutData((Object)gd);
        this.excludedResText.setEnabled(false);
        this.excludedBrowse = new Button((Composite)this.excludedResGroup, 8);
        this.excludedBrowse.setText(Messages.getString(ImpactGraphMainPage.class, "exclude.browse.button"));
        gd = new GridData(256);
        this.excludedBrowse.setLayoutData((Object)gd);
        this.excludedBrowse.setSelection(false);
        this.excludedBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDg = new FileDialog(ImpactGraphMainPage.this.excludedBrowse.getShell(), 4);
                String filePath = fileDg.open();
                if (filePath != null) {
                    ImpactGraphMainPage.this.excludedResText.setText(filePath);
                }
                ((PrepareReportWizard)ImpactGraphMainPage.this.getWizard()).set("excludeResFromFile", (Object)filePath);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setErrorMessage() {
        this.setMessage(Messages.getString(ImpactGraphMainPage.class, "wrongDepth.error.message", new String[]{String.valueOf(1), String.valueOf(1000)}), 3);
    }

    private void setDirection() {
        boolean direction = this.forward.getSelection();
        ((PrepareReportWizard)this.getWizard()).set(IMPACT_DIRECTION, (Object)direction);
    }

    private void setDepth() {
        String depth;
        int depthInt = 0;
        if (this.depthChoice != null && this.depthChoice.getSelection() && !(depth = this.depthText.getText()).isEmpty()) {
            try {
                depthInt = Integer.valueOf(depth);
            }
            catch (NumberFormatException ex) {
                L.info("wrong value for depth; default (0) is used", (Throwable)ex);
            }
        }
        ((PrepareReportWizard)this.getWizard()).set(MAX_CYCLES, (Object)depthInt);
    }

    private boolean checkTargetSelection() {
        boolean ret = false;
        if (!this.targetSelection) {
            ret = true;
        } else if (this.datasourceChoice.getSelection() && this.targetSelectionCombo.getSelectionIndex() != -1) {
            ret = true;
        } else if (this.locInIncludesButton.getSelection() || this.locInProgramsButton.getSelection()) {
            ret = true;
        }
        return ret;
    }

    private boolean checkDirection() {
        boolean ret = this.forward == null && this.backward == null || this.forward != null && this.forward.getSelection() || this.backward != null && this.backward.getSelection();
        return ret;
    }

    boolean checkDepthValue() {
        boolean complete;
        block8: {
            complete = true;
            if (this.depthChoice != null) {
                if (this.depthChoice.getSelection()) {
                    String depth = this.depthText.getText();
                    try {
                        if (depth.isEmpty()) {
                            complete = false;
                        } else {
                            int depthInt = Integer.valueOf(depth);
                            boolean bl = complete = depthInt > 0 && depthInt <= 1000;
                        }
                        if (complete) {
                            this.setMessage(this.description, 0);
                            break block8;
                        }
                        this.setErrorMessage();
                    }
                    catch (NumberFormatException ex) {
                        L.warn("wrong value for depth", (Throwable)ex);
                        this.setErrorMessage();
                        complete = false;
                    }
                } else {
                    this.setMessage(this.description, 0);
                }
            }
        }
        return complete;
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
    }

    protected class DirectionAdapter
    extends SelectionAdapter {
        protected DirectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            ImpactGraphMainPage.this.setDirection();
            ImpactGraphMainPage.this.setPageComplete(ImpactGraphMainPage.this.isLoadAction() || ImpactGraphMainPage.this.checkDirection() && ImpactGraphMainPage.this.checkTargetSelection() && ImpactGraphMainPage.this.checkDepthValue());
        }
    }
}

