/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.wizard;

import com.ez.gdb.core.itf.IODBAdminService;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceDataset;
import com.ez.internal.analysis.config.inputs.EZSourceInclude;
import com.ez.internal.analysis.config.inputs.EZSourceProgram;
import com.ez.internal.analysis.config.inputs.EZSourceSQLTable;
import com.ez.internal.analysis.config.inputs.EZSourceSQLTableField;
import com.ez.internal.analysis.config.inputs.EZSourceVariable;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.filters.AbstractSingleMainframeProjectOrResourcesFilter;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProgramTypeIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceVariableIDSg;
import java.util.Collection;
import java.util.Map;

public class ImpactGraphFilter
extends AbstractSingleMainframeProjectOrResourcesFilter {
    protected boolean checkDefinition(ProjectInfo pInfo) {
        boolean ok = pInfo.hasDefinition();
        String pName = pInfo.getName();
        IODBAdminService service = (IODBAdminService)ServiceUtils.getService(IODBAdminService.class);
        if (service != null) {
            ok = service.hasDatabase(pName);
        }
        return ok;
    }

    protected boolean checkResources(Collection inputs) {
        boolean accepted = true;
        Class<?> clazz = null;
        for (Object inpObj : inputs) {
            if (clazz != null && !inpObj.getClass().equals(clazz)) {
                accepted = false;
            } else if (inpObj instanceof EZSourceSQLTable && clazz != null) {
                accepted = false;
            }
            clazz = inpObj.getClass();
        }
        return accepted ? super.checkResources(inputs) : accepted;
    }

    protected boolean isAcceptedResourceInput(Object inpObj) {
        boolean ret = false;
        if (inpObj instanceof EZSourceVariable) {
            EZEntityID entity = ((EZSourceVariable)inpObj).getEntID();
            EZSourceProgramTypeIDSg prgtypeSg = (EZSourceProgramTypeIDSg)entity.getSegment(EZSourceProgramTypeIDSg.class);
            EZSourceVariableIDSg varSg = (EZSourceVariableIDSg)entity.getSegment(EZSourceVariableIDSg.class);
            Integer progrTypeId = prgtypeSg.getProgramTypeId();
            if (varSg != null && progrTypeId == 2) {
                ret = true;
            }
        } else {
            ret = inpObj instanceof EZSourceSQLTableField || inpObj instanceof EZSourceSQLTable || inpObj instanceof EZSourceDataset && (Boolean)((EZObjectType)inpObj).getProperty("holds the load modules of the program to be executed in the JCL") == false && !this.isCICSds((EZObjectType)inpObj);
        }
        return ret;
    }

    protected boolean isAcceptedPrgInput(Object inpObj, Collection inputs) {
        EZSourceProgramTypeIDSg prgSg;
        EZEntityID entid;
        EZSourceInclude ezInclude;
        Map properties;
        boolean ret = false;
        if (inputs.size() == 1 && inpObj instanceof EZSourceProgram) {
            EZSourceProgramIDSg prgSg2;
            EZEntityID entid2;
            EZSourceProgram ezPrg = (EZSourceProgram)inpObj;
            Map properties2 = ezPrg.getProperties();
            if ((Boolean)properties2.get("program occur") != null && Boolean.valueOf(properties2.get("program occur").equals(true)).booleanValue() && (entid2 = ezPrg.getEntID()) != null && (prgSg2 = (EZSourceProgramIDSg)entid2.getSegment(EZSourceProgramIDSg.class)) != null) {
                ret = prgSg2.getTypeId() == 2;
            }
        } else if (inputs.size() == 1 && inpObj instanceof EZSourceInclude && (Boolean)(properties = (ezInclude = (EZSourceInclude)inpObj).getProperties()).get("include is not on disk") != null && Boolean.valueOf(properties.get("include is not on disk").equals(false)).booleanValue() && (entid = ezInclude.getEntID()) != null && (prgSg = (EZSourceProgramTypeIDSg)entid.getSegment(EZSourceProgramTypeIDSg.class)) != null) {
            ret = prgSg.getProgramTypeId() == 2;
        }
        return ret;
    }

    protected boolean verifySpecificCondition(EZObjectType inpObj) {
        boolean ret = false;
        if (inpObj != null) {
            EZSourceProjectIDSg prjIdSg;
            EZEntityID entity;
            ProjectInfo pInfo = (ProjectInfo)inpObj.getProperty("PROJECT_INFO");
            if (pInfo == null && (entity = inpObj.getEntID()) != null && (prjIdSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class)) != null) {
                pInfo = prjIdSg.getProjectInfo();
            }
            if (pInfo != null) {
                ret = this.checkDefinition(pInfo);
            }
        }
        return ret;
    }
}

