/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.wizard;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcludedResourcesFromImpactGraph {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ExcludedResourcesFromImpactGraph.class);

    public static HashMap<String, List<?>> readExcludedResFromFile(String filePath) {
        HashMap excludedRes = new HashMap();
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(filePath));
                ArrayList excDatasets = new ArrayList();
                ArrayList excSQLTables = new ArrayList();
                ArrayList excSQLFields = new ArrayList();
                ArrayList excVariables = new ArrayList();
                ArrayList excDALFiles = new ArrayList();
                ArrayList excBMSProxy = new ArrayList();
                String line = null;
                int lineNo = 0;
                try {
                    line = br.readLine();
                    while (line != null) {
                        ++lineNo;
                        if (!line.isEmpty()) {
                            HashMap<String, String> resourceDetails = null;
                            String[] words = line.split(",");
                            int i = 0;
                            while (i < words.length) {
                                words[i] = words[i].trim();
                                ++i;
                            }
                            if (words.length == 2 && words[0].equals("dataset")) {
                                if (!words[1].isEmpty()) {
                                    resourceDetails = new HashMap<String, String>();
                                    resourceDetails.put("dataset", words[1]);
                                    excDatasets.add(resourceDetails);
                                } else {
                                    L.warn("no dataset name specified in exclude resources file after dataset keyword at line " + lineNo);
                                }
                            } else if ((words.length == 2 || words.length == 4) && words[0].equals("sqlfield")) {
                                String tableName = new String();
                                if (words[words.length - 2].equals("sqltable")) {
                                    tableName = words[words.length - 1];
                                    if (!tableName.isEmpty()) {
                                        int i2 = 1;
                                        while (i2 < words.length - 2) {
                                            resourceDetails = new HashMap();
                                            resourceDetails.put("sqlfield", words[i2]);
                                            resourceDetails.put("sqltable", tableName);
                                            excSQLFields.add(resourceDetails);
                                            ++i2;
                                        }
                                    } else {
                                        L.warn("no sqltable name specified in exclude resources file after sqltable keyword at line " + lineNo);
                                    }
                                } else {
                                    resourceDetails = new HashMap();
                                    resourceDetails.put("sqlfield", words[1]);
                                    resourceDetails.put("sqltable", tableName);
                                    excSQLFields.add(resourceDetails);
                                }
                            } else if (words.length == 2 && words[0].equals("sqltable")) {
                                if (!words[1].isEmpty()) {
                                    HashMap<String, String> sqltableDet = new HashMap<String, String>();
                                    sqltableDet.put("sqltable", words[1]);
                                    excSQLTables.add(sqltableDet);
                                } else {
                                    L.warn("no sqltable name specified after sqltable keyword at line" + lineNo);
                                }
                            } else if (words.length >= 2 && words[0].equals("bmsproxy")) {
                                if (!words[1].isEmpty() && words.length == 2) {
                                    HashMap<String, String> bmsproxyDet = new HashMap<String, String>();
                                    bmsproxyDet.put("bmsproxy", words[1]);
                                    excBMSProxy.add(bmsproxyDet);
                                } else if (!words[1].isEmpty() && !words[3].isEmpty() && words.length == 4) {
                                    HashMap<String, String> bmsproxyDet = new HashMap<String, String>();
                                    bmsproxyDet.put("bmsproxy", words[1]);
                                    if (words[2].equals("mapset")) {
                                        bmsproxyDet.put("mapset", words[3]);
                                    }
                                    excBMSProxy.add(bmsproxyDet);
                                } else {
                                    L.warn("incorrect syntax for exclude bmsproxy at line " + lineNo);
                                }
                            } else if (words.length == 2 && words[0].equals("dalfile")) {
                                if (!words[1].isEmpty()) {
                                    HashMap<String, String> dalFileDet = new HashMap<String, String>();
                                    dalFileDet.put("dalfile", words[1]);
                                    excDALFiles.add(dalFileDet);
                                }
                            } else if (words.length >= 2 && words[0].equals("variable")) {
                                String varName = words[1];
                                if (!varName.isEmpty()) {
                                    String program = new String();
                                    String include = new String();
                                    String forefather = new String();
                                    int i3 = 2;
                                    while (i3 < words.length - 1) {
                                        if (words[i3].equals("program")) {
                                            program = words[i3 + 1];
                                        }
                                        if (words[i3].equals("include")) {
                                            include = words[i3 + 1];
                                        }
                                        if (words[i3].equals("forefather")) {
                                            forefather = words[i3 + 1];
                                        }
                                        if (words[i3 + 1].isEmpty()) {
                                            L.warn("no value for variable's details information: program, include or forefather at line " + lineNo);
                                        }
                                        if (!(words[i3].equals("program") || words[i3].equals("include") || words[i3].equals("forefather"))) {
                                            L.warn("unknown keyword for variable. please try only one of these keywords: program, include or forefather at line " + lineNo);
                                        }
                                        i3 += 2;
                                    }
                                    resourceDetails = new HashMap();
                                    resourceDetails.put("variable", varName);
                                    resourceDetails.put("program", program);
                                    resourceDetails.put("include", include);
                                    resourceDetails.put("forefather", forefather);
                                    excVariables.add(resourceDetails);
                                } else {
                                    L.warn("no variable name after variable keyword at line " + lineNo);
                                }
                            } else {
                                L.warn("incorrect excluded resources file sintax at line " + lineNo);
                            }
                        }
                        line = br.readLine();
                    }
                    excludedRes.put("dataset", excDatasets);
                    excludedRes.put("sqltable", excSQLTables);
                    excludedRes.put("sqlfield", excSQLFields);
                    excludedRes.put("variable", excVariables);
                    excludedRes.put("dalfile", excDALFiles);
                    excludedRes.put("bmsproxy", excBMSProxy);
                }
                catch (IOException e) {
                    L.debug("can't read a line from the file with excluded resources", (Throwable)e);
                    L.error("can't read a line from the file with excluded resources", (Throwable)e);
                }
            }
            catch (FileNotFoundException e) {
                L.debug("can't open the file with excluded resources", (Throwable)e);
                L.error("can't open the file with excluded resources", (Throwable)e);
                try {
                    br.close();
                }
                catch (IOException e2) {
                    L.debug("can't close the file with excluded resources", (Throwable)e2);
                    L.error("can't close the file with excluded resources", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                L.debug("can't close the file with excluded resources", (Throwable)e);
                L.error("can't close the file with excluded resources", (Throwable)e);
            }
        }
        return excludedRes;
    }
}

