/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.collectors;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.PrgOrIncludeWithPathInput;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import com.ez.workspace.model.segments.EZSourceIncludeIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableDetailProvider
implements SelectSingleFromListPage.ListDetailProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(VariableDetailProvider.class);
    public static final String ENTITY_TYPE = Messages.getString(VariableDetailProvider.class, "entityType.variable");
    private final String VARS_FROM_PRG_QUERY = "select $var as ss  from ? let $var=out('SourceInfo')[0].in('SourceInfo')[@class = 'Variable'] order by ss.sid, ss.father, ss.ancestor, ss.posInrecord UNWIND ss limit -1 ";
    private final String ALL_VARS_FROM_PRG_QUERY = "select $var.@rid as ssRid from Program let $var=out('HasV') where @rid = @@@@@EZLEGACY@@@@ order by ssRid, father, ancestor, posInrecord UNWIND ssRid limit -1";
    private final String VARS_FROM_INCLUDE_QUERY = "select $var.@rid as ssRid from Path let $var=in('SourceInfo')[@class = 'Variable'] where @rid = @@@@@EZLEGACY@@@@ order by ssRid, father, ancestor, posInRecord ASC unwind ssRid limit -1";
    private PrepareReportWizard wizard;
    String description = null;
    String project = null;
    private boolean isFromCopy = false;

    public VariableDetailProvider(PrepareReportWizard wizard, String ezPrjName) {
        this.wizard = wizard;
        this.project = ezPrjName;
    }

    private Node buildTree(Iterable<OrientVertex> results, OrientBaseGraph dbg) {
        Node head = new Node();
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        String headFather = "0";
        Node dsect = null;
        Node local = null;
        ArrayList<String> fakeFathers = new ArrayList<String>();
        nodes.put(headFather, head);
        for (OrientVertex vertex : results) {
            Vertex record = (Vertex)vertex.getProperty("ssRid");
            if (record == null) break;
            String varId = record.getProperty("sid").toString();
            String varType = record.getProperty("type") != null ? record.getProperty("type").toString() : null;
            String fatherId = record.getProperty("father").toString();
            String rid = record.getId().toString();
            Iterator procIt = record.getVertices(Direction.OUT, new String[]{"VinCB"}).iterator();
            String proc = null;
            if (procIt.hasNext()) {
                proc = (String)((Vertex)procIt.next()).getProperty("name");
            }
            Iterator lineIt = record.getEdges(Direction.OUT, new String[]{"SourceInfo"}).iterator();
            String sLine = null;
            if (lineIt.hasNext()) {
                sLine = ((Edge)lineIt.next()).getProperty("sLine").toString();
            }
            Iterator programIt = record.getVertices(Direction.IN, new String[]{"HasV"}).iterator();
            String program = null;
            if (programIt.hasNext()) {
                program = (String)((Vertex)programIt.next()).getProperty("name");
            }
            String[] row = new String[]{rid, (String)record.getProperty("name"), varId, varType, fatherId, record.getProperty("ancestor").toString(), (String)record.getProperty("pic"), record.getProperty("level").toString(), record.getProperty("isFiller").toString(), record.getProperty("isField").toString(), record.getProperty("posInRecord").toString(), sLine, proc, program};
            Node father = (Node)nodes.get(fatherId);
            if (father == null) {
                L.debug("unordered list, created fake node with id" + fatherId);
                father = new Node();
                nodes.put(fatherId, father);
                fakeFathers.add(fatherId);
            }
            if ("20".equals(varType) && fatherId.equals(headFather)) {
                if (dsect == null) {
                    dsect = new Node("DSECT");
                    head.children.add(dsect);
                }
                father = dsect;
            } else if (("21".equals(varType) || "22".equals(varType) || "23".equals(varType) || "24".equals(varType)) && fatherId.equals(headFather)) {
                if (local == null) {
                    local = new Node("Local");
                    head.children.add(local);
                }
                father = local;
            }
            Node cNode = (Node)nodes.get(varId);
            if (cNode != null) {
                cNode.row = row;
            } else {
                cNode = new Node();
                cNode.row = row;
                nodes.put(varId, cNode);
            }
            fakeFathers.remove(varId);
            father.children.add(cNode);
        }
        for (String id : fakeFathers) {
            head.children.add((Node)nodes.get(id));
        }
        return head;
    }

    public List<SelectSingleFromListPage.ListItem> getItems(EZSourceConnection bridge, IProgressMonitor monitor) {
        List<SelectSingleFromListPage.ListItem> items;
        block24: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.getString(VariableDetailProvider.class, "get.var.task.name"), (int)-1);
            items = null;
            String query = null;
            PrgOrIncludeWithPathInput prgInput = null;
            String rid = null;
            Integer prgSid = null;
            String includeName = null;
            boolean forPrograms = false;
            if ((Integer)this.wizard.getValue("input_type") == 0) {
                if (this.wizard.getValue("targetSelectionOption") != null) {
                    if (this.wizard.getValue("targetSelectionOption").equals("locVarInPrograms")) {
                        forPrograms = true;
                    } else if (this.wizard.getValue("targetSelectionOption").equals("locVarInIncludes")) {
                        forPrograms = false;
                    }
                }
                if (this.wizard.getValue("selected id") instanceof ArrayList) {
                    List lst4GUI = (List)this.wizard.getValue("selected id");
                    BaseMainframeResource4GUI lst = (BaseMainframeResource4GUI)lst4GUI.get(0);
                    prgInput = (PrgOrIncludeWithPathInput)lst.getObject();
                }
                rid = prgInput.getOdbRID();
            } else if ((Integer)this.wizard.getValue("input_type") == 1) {
                List inputs = (List)this.wizard.getValue("cobolprg=true or include=false");
                if (inputs != null && ((EZEntityID)inputs.get(0)).getSegment(EZSourceProgramIDSg.class) != null) {
                    forPrograms = true;
                    prgSid = ((EZSourceProgramIDSg)((EZEntityID)inputs.get(0)).getSegment(EZSourceProgramIDSg.class)).getProgramId();
                    this.wizard.set("locVarInPrograms", (Object)true);
                } else if (inputs != null && ((EZEntityID)inputs.get(0)).getSegment(EZSourceIncludeIDSg.class) != null) {
                    forPrograms = false;
                    includeName = ((EZSourceIncludeIDSg)((EZEntityID)inputs.get(0)).getSegment(EZSourceIncludeIDSg.class)).getIncludeName();
                    this.wizard.set("locVarInPrograms", (Object)false);
                }
            }
            if (forPrograms) {
                query = "select $var.@rid as ssRid from Program let $var=out('HasV') where @rid = @@@@@EZLEGACY@@@@ order by ssRid, father, ancestor, posInrecord UNWIND ssRid limit -1";
                this.isFromCopy = false;
            } else {
                query = "select $var.@rid as ssRid from Path let $var=in('SourceInfo')[@class = 'Variable'] where @rid = @@@@@EZLEGACY@@@@ order by ssRid, father, ancestor, posInRecord ASC unwind ssRid limit -1";
                this.isFromCopy = true;
            }
            Properties env = ConnectionUtils.getODBSettings((String)this.project);
            OrientBaseGraph dbg = ConnectionUtils.getNoTxGraph((Properties)env);
            try {
                try {
                    Iterable results;
                    String getRIDQuery;
                    if (prgSid != null) {
                        getRIDQuery = "select @RID.asString() as prgOrIncRID from Program where sid = ?";
                        results = (Iterable)dbg.command((OCommandRequest)new OCommandSQL(getRIDQuery)).execute(new Object[]{prgSid});
                        for (OrientVertex ov : results) {
                            rid = (String)ov.getProperty("prgOrIncRID");
                        }
                    } else if (includeName != null) {
                        getRIDQuery = String.format("select @RID.asString() as prgOrIncRID from Path where name.toUpperCase() = '%s'", includeName.toUpperCase());
                        results = (Iterable)dbg.command((OCommandRequest)new OCommandSQL(getRIDQuery)).execute(new Object[0]);
                        for (OrientVertex ov : results) {
                            rid = (String)ov.getProperty("prgOrIncRID");
                        }
                    }
                    String query_ = query.replace("@@@@@EZLEGACY@@@@", rid);
                    results = (Iterable)dbg.command((OCommandRequest)new OCommandSQL(query_)).execute(new Object[0]);
                    Node head = this.buildTree(results, dbg);
                    HashMap<String, SelectSingleFromListPage.ArrayListItem> usedNames = new HashMap<String, SelectSingleFromListPage.ArrayListItem>();
                    items = this.buildListItems(head, 0, usedNames);
                }
                catch (EZSourceNativeException e) {
                    L.error("getItems()", (Throwable)e);
                    items = null;
                    ConnectionUtils.releaseGraph((OrientBaseGraph)dbg, (Properties)env);
                    break block24;
                }
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseGraph((OrientBaseGraph)dbg, (Properties)env);
                throw throwable;
            }
            ConnectionUtils.releaseGraph((OrientBaseGraph)dbg, (Properties)env);
        }
        this.description = items == null || items.size() == 0 ? Messages.getString(VariableDetailProvider.class, "noVariable.message") : Messages.getString(VariableDetailProvider.class, "default.description");
        return items;
    }

    private List<SelectSingleFromListPage.ListItem> buildListItems(Node cNode, int level, Map<String, SelectSingleFromListPage.ArrayListItem> usedNames) {
        ArrayList<SelectSingleFromListPage.ListItem> items = new ArrayList<SelectSingleFromListPage.ListItem>();
        SelectSingleFromListPage.ListItem cItem = this.buildItem(cNode, level, usedNames);
        if (cItem != null) {
            items.add(cItem);
            ++level;
        }
        for (Node child : cNode.children) {
            List<SelectSingleFromListPage.ListItem> cItems = this.buildListItems(child, level, usedNames);
            items.addAll(cItems);
        }
        return items;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SelectSingleFromListPage.ListItem buildItem(Node cNode, int level, Map<String, SelectSingleFromListPage.ArrayListItem> usedNames) {
        String program;
        if (!cNode.isDrawable()) {
            return null;
        }
        StringBuilder textBuf = new StringBuilder();
        SelectSingleFromListPage.ArrayListItem item = new SelectSingleFromListPage.ArrayListItem();
        String varName = cNode.getName();
        if (cNode.row != null) {
            item.setStringArray(cNode.row);
        }
        this.ident(textBuf, level);
        textBuf.append(cNode.getLevel());
        String varLine = cNode.row[11] != null ? cNode.row[11] : null;
        String varFather = item.getStringArray()[4];
        String varKey = this.isFromCopy ? varName.toUpperCase() : String.valueOf(varName.toUpperCase()) + varFather;
        String procName = cNode.row[12] != null ? cNode.row[12] : "";
        String string = program = cNode.row[13] != null ? cNode.row[13] : "";
        if (usedNames.containsKey(varKey)) {
            SelectSingleFromListPage.ArrayListItem it = usedNames.get(varKey);
            if (it != null) {
                String[] array = it.getStringArray();
                if (array.length == 3) {
                    if (array[0].equals(varLine) && array[1].equals(procName) && array[2] != null && array[2].equals(program)) {
                        return null;
                    }
                } else {
                    if (it.getStringArray()[11] != null && it.getStringArray()[11].equals(varLine)) {
                        if (!this.isFromCopy) return null;
                        if (it.getStringArray()[12] != null && it.getStringArray()[12].equals(procName) && it.getStringArray()[13] != null && it.getStringArray()[13].equals(program)) {
                            return null;
                        }
                    }
                    String internalvarKey = this.isFromCopy ? varName.toUpperCase() : String.valueOf(varName.toUpperCase()) + it.getStringArray()[4];
                    usedNames.remove(internalvarKey);
                    String newText = String.valueOf(it.getListText()) + " (" + (this.isFromCopy ? String.valueOf(it.getStringArray()[13]) + "|" : "") + it.getStringArray()[12] + " line:" + it.getStringArray()[11] + ")";
                    it.setListText(newText);
                    it.setDuplicateName(true);
                    SelectSingleFromListPage.ArrayListItem ait = new SelectSingleFromListPage.ArrayListItem();
                    String[] s = new String[]{it.getStringArray()[11], it.getStringArray()[12], it.getStringArray()[13]};
                    ait.setStringArray(s);
                    usedNames.put(internalvarKey, ait);
                }
            }
            if (item.hasDuplicateName()) return null;
            textBuf.append(varName).append(" (" + (this.isFromCopy ? String.valueOf(cNode.row[13]) + "|" : "") + cNode.row[12]).append(" line:").append(cNode.row[11]).append(")");
            item.setDuplicateName(true);
        } else {
            usedNames.put(varKey, item);
            textBuf.append(varName);
        }
        item.setListText(textBuf.toString());
        return item;
    }

    private void ident(StringBuilder textBuf, int ident) {
        int j = 0;
        while (j < ident) {
            textBuf.append("      ");
            ++j;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getEntityType() {
        return ENTITY_TYPE;
    }

    public String getTitle() {
        return Messages.getString(VariableDetailProvider.class, "title.4multipleVarSelection");
    }

    public boolean isCheckBox() {
        return false;
    }

    public boolean hasFilters() {
        return true;
    }

    class Node {
        String name = null;
        String[] row = null;
        List<Node> children = new LinkedList<Node>();

        Node() {
        }

        Node(String name) {
            this.name = name;
        }

        String getName() {
            return this.name != null ? this.name : this.row[1];
        }

        String getLevel() {
            return this.name != null ? "" : String.valueOf(String.format("%02d", Integer.parseInt(this.row[7]))) + " ";
        }

        boolean isFiller() {
            return this.row == null ? false : this.row[9].equals("true");
        }

        public boolean isDrawable() {
            return this.row != null || this.name != null;
        }
    }
}

