/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.collectors;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.gdb.core.analysis.inputs.SQLTable;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.ui.collectors.InputsCollector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLTablesCollector
extends InputsCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String SQL_TABLES_QUERY = "SELECT DISTINCT SqlTables.TableName FROM SqlTables INNER JOIN StatementReference ON SqlTables.SqlTableID =StatementReference.ResourceID WHERE (StatementReference.ResourceType = 1)";
    private static final Logger L = LoggerFactory.getLogger(SQLTablesCollector.class);

    public SQLTablesCollector() {
        this.resourcesQuery = SQL_TABLES_QUERY;
        this.setResourcesQuery(SQL_TABLES_QUERY);
    }

    public List<BaseResourceInput4GUI> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        ArrayList<BaseResourceInput4GUI> tablesList = new ArrayList<BaseResourceInput4GUI>();
        HashSet<String> tablesName = new HashSet<String>();
        try {
            String[][] results = conn.executeSQL(this.resourcesQuery);
            if (results != null && results.length > 0) {
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] result = stringArray[n2];
                    String tableName = result[0];
                    if (!tablesName.contains(tableName)) {
                        SQLTable root = new SQLTable(tableName);
                        tablesList.add((BaseResourceInput4GUI)new BaseMainframeResource4GUI((BaseResourceInput)root));
                        tablesName.add(tableName);
                    }
                    ++n2;
                }
            }
        }
        catch (EZSourceConnectionException eZSourceConnectionException) {}
        return tablesList;
    }
}

