/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.collectors;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.graphs.viewer.odb.analysis.wizard.SQLField;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.ui.collectors.InputsCollector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLFieldsCollector
extends InputsCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SQLFieldsCollector.class);
    private String parameter;
    private String query = "SELECT SqlFields.FieldName,SqlFields.SqlFieldID FROM SqlFields INNER JOIN SqlTables ON SqlFields.SqlTableID=SqlTables.SqlTableID WHERE Sqltables.Tablename = '";

    public SQLFieldsCollector(String parameter) {
        this.parameter = parameter;
        this.resourcesQuery = String.valueOf(this.query) + parameter + "'";
    }

    public List<BaseResourceInput4GUI> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        ArrayList<BaseResourceInput4GUI> fieldsList = new ArrayList<BaseResourceInput4GUI>();
        HashSet<String> fieldsName = new HashSet<String>();
        try {
            ArrayList<String> a = new ArrayList<String>();
            a.add(this.parameter);
            String[][] results = conn.executeSQL(this.resourcesQuery);
            if (results != null && results.length > 0) {
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] result = stringArray[n2];
                    String fieldName = result[0];
                    if (!fieldsName.contains(fieldName)) {
                        SQLField root = new SQLField(fieldName);
                        fieldsList.add((BaseResourceInput4GUI)new BaseMainframeResource4GUI((BaseResourceInput)root));
                        fieldsName.add(fieldName);
                    }
                    ++n2;
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return fieldsList;
    }
}

