/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.collectors;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.common.ui.listselection.ItemType;
import com.ez.gdb.core.collectors.ODBAbstractCollector;
import com.ez.graphs.viewer.odb.analysis.collectors.TransactionInput;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODBTransactionCollector
extends ODBAbstractCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    Logger L = LoggerFactory.getLogger(ODBTransactionCollector.class);
    private static List<ImageObj4Wizard> imagesObjsList;
    public String QUERY = "select name, @class.asString() as tranClass from Proxy where @class= 'TranProxy' or @class= 'IMSTransactionProxy' or @class= 'GenericTranProxy' @@@@@EZLEGACY@@@@ limit " + LIMIT;

    public List doCollect(boolean useFilters, Set<String> apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)150);
        monitor.setTaskName(Messages.getString(ODBTransactionCollector.class, "collectingData.taskName"));
        ArrayList<BaseMainframeResource4GUI> resources = new ArrayList<BaseMainframeResource4GUI>();
        imagesObjsList = new ArrayList<ImageObj4Wizard>();
        HashSet<Integer> availableTypesForFilters = new HashSet<Integer>();
        try {
            boolean next = true;
            String rid = "#-1:-1";
            HashSet<String> namesWithMember = new HashSet<String>();
            long start = System.currentTimeMillis();
            while (next && !monitor.isCanceled()) {
                String partialQuery = this.QUERY.replace("@@@@@EZLEGACY@@@@", rid != null ? " and @rid > " + rid + " " : "");
                super.setPartialQuery(partialQuery);
                Iterable results = super.getResults();
                rid = this.createObjects(resources, namesWithMember, results, availableTypesForFilters, monitor.newChild(10));
                if (rid != null) continue;
                next = false;
            }
            this.L.debug("endODBTransactionCollector " + (System.currentTimeMillis() - start) + " ms");
            this.L.debug("transaction in wizard size: " + resources.size());
        }
        catch (ODatabaseException e) {
            this.L.error("odb connection error", (Throwable)e);
        }
        if (!availableTypesForFilters.isEmpty()) {
            for (Integer type : availableTypesForFilters) {
                ItemType wizType = new ItemType(type);
                String textType = Utils.getExternalizedType4Transaction((Integer)type);
                ImageDescriptor image_desc = Utils.getImageDescType4Transaction((Integer)type);
                ImageObj4Wizard imageObj = new ImageObj4Wizard(wizType, textType, image_desc);
                imagesObjsList.add(imageObj);
            }
        }
        return resources;
    }

    private String createObjects(List<BaseMainframeResource4GUI> resources, Set<String> namesWithMember, Iterable<OrientElement> results, Set<Integer> availableTypesForFilters, SubMonitor pMonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)10);
        String ridId = null;
        int count = 0;
        for (OrientElement element : results) {
            if (monitor.isCanceled()) {
                return null;
            }
            String name = (String)element.getProperty("name");
            String tranClass = (String)element.getProperty("tranClass");
            Integer tranType = TransactionInput.getTransactionType(tranClass);
            TransactionInput trans = new TransactionInput(name, tranType);
            resources.add(new BaseMainframeResource4GUI((BaseResourceInput)trans));
            availableTypesForFilters.add(tranType);
            ++count;
        }
        if (count < LIMIT) {
            ridId = null;
        }
        return ridId;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return imagesObjsList;
    }
}

