/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.collectors;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.gdb.core.collectors.ODBAbstractCollector;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.viewer.odb.analysis.wizard.SQLField;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODBTableFieldsCollector
extends ODBAbstractCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ODBTableFieldsCollector.class);
    private String QUERY = "select name as fieldName from SQLFieldProxy where tableName= '";
    private String tableName;

    public ODBTableFieldsCollector(String tableName) {
        this.tableName = tableName;
    }

    public List doCollect(boolean useFilters, Set<String> apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)150);
        monitor.setTaskName(Messages.getString(ODBTableFieldsCollector.class, "collectingData.taskName"));
        ArrayList<BaseResourceInput4GUI> resources = new ArrayList<BaseResourceInput4GUI>();
        try {
            boolean next = true;
            String rid = "#-1:-1";
            HashSet<Integer> availableTypesForFilters = new HashSet<Integer>();
            monitor.worked(100);
            while (next && !monitor.isCanceled()) {
                String partialQuery = String.valueOf(this.QUERY) + this.tableName + "'";
                partialQuery = partialQuery.replace("@@@@@EZLEGACY@@@@", rid != null ? " where @rid > " + rid + " " : "");
                super.setPartialQuery(partialQuery);
                Iterable results = super.getResults();
                rid = this.createObjects(resources, results, availableTypesForFilters, pMonitor);
                if (rid != null) continue;
                next = false;
            }
        }
        catch (ODatabaseException e) {
            L.error("odb connection error", (Throwable)e);
        }
        return resources;
    }

    private String createObjects(List<BaseResourceInput4GUI> resources, Iterable<OrientElement> results, Set<Integer> availableTypesForFilters, IProgressMonitor pMonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)10);
        String ridId = null;
        int count = 0;
        HashSet<String> fieldsName = new HashSet<String>();
        for (OrientElement element : results) {
            if (monitor.isCanceled()) {
                return null;
            }
            OrientVertex vertex = null;
            if (element instanceof OrientVertex) {
                vertex = (OrientVertex)element;
            }
            ridId = vertex.getId().toString();
            String fieldName = (String)vertex.getProperty("fieldName");
            if (!fieldsName.contains(fieldName)) {
                SQLField root = new SQLField(fieldName);
                resources.add((BaseResourceInput4GUI)new BaseMainframeResource4GUI((BaseResourceInput)root));
                fieldsName.add(fieldName);
            }
            ++count;
        }
        if (count < LIMIT) {
            ridId = null;
        }
        return ridId;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return null;
    }

    public OrientExtendedGraph setODBConnection(Properties env) {
        OrientBaseGraph dbg = ConnectionUtils.getNoTxGraph((Properties)env);
        return dbg;
    }
}

