/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.collectors;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.gdb.core.analysis.inputs.SQLTable;
import com.ez.gdb.core.collectors.ODBAbstractCollector;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODBTableCollector
extends ODBAbstractCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ODBTableCollector.class);
    private String QUERY = "select @rid.asString() as trid, name as tableName from SQLTableProxy @@@@@EZLEGACY@@@@ limit " + LIMIT;

    public List doCollect(boolean useFilters, Set apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)150);
        monitor.setTaskName(Messages.getString(ODBTableCollector.class, "collectingData.taskName"));
        ArrayList<BaseResourceInput4GUI> resources = new ArrayList<BaseResourceInput4GUI>();
        try {
            boolean next = true;
            String rid = "#-1:-1";
            new HashSet();
            monitor.worked(100);
            while (next && !monitor.isCanceled()) {
                String partialQuery = this.QUERY.replace("@@@@@EZLEGACY@@@@", rid != null ? " where @rid > " + rid + " " : "");
                super.setPartialQuery(partialQuery);
                Iterable results = super.getResults();
                rid = this.createObjects(resources, results, pMonitor);
                if (rid != null) continue;
                next = false;
            }
        }
        catch (ODatabaseException oDatabaseException) {
            L.error("odb connection error");
        }
        return resources;
    }

    private String createObjects(List<BaseResourceInput4GUI> resources, Iterable<OrientElement> results, IProgressMonitor pMonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)10);
        String ridId = null;
        int count = 0;
        HashSet<String> tablesName = new HashSet<String>();
        for (OrientElement element : results) {
            if (monitor.isCanceled()) {
                return null;
            }
            ridId = (String)element.getProperty("trid");
            String tableName = (String)element.getProperty("tableName");
            if (!tablesName.contains(tableName)) {
                SQLTable root = new SQLTable(tableName);
                resources.add((BaseResourceInput4GUI)new BaseMainframeResource4GUI((BaseResourceInput)root));
                tablesName.add(tableName);
            }
            ++count;
        }
        if (count < LIMIT) {
            ridId = null;
        }
        return ridId;
    }

    public List getAvailableImages() {
        return null;
    }
}

