/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.collectors;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.gdb.core.collectors.ODBAbstractCollector;
import com.ez.graphs.viewer.odb.analysis.collectors.ODBJobCollector;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.mainframe.data.utils.Utils;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.ScreenInput;
import com.ez.report.application.ui.collectors.ProgramInputsFactory4Wizard;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODBScreenCollector
extends ODBAbstractCollector {
    private static final int GENERIC_MAP_RES_ID = 220;
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ODBScreenCollector.class);
    private List<ImageObj4Wizard> availableImages;
    private String QUERY = "select @rid.asString() as rid, name, mapSet, @class.asString() AS screenClass, $a as dof from Proxy \n let $a = out('IMSModProxyOf')[0].dof \n where (@class instanceof 'ScreenProxy' or @class='IMSMODProxy' or @class = 'GenericScreenProxy') \n@@@@@EZLEGACY@@@@ limit " + LIMIT;

    public List doCollect(boolean useFilters, Set<String> apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)150);
        monitor.setTaskName(Messages.getString(ODBJobCollector.class, "collectingData.taskName"));
        if (this.availableImages != null) {
            this.availableImages.clear();
        }
        ArrayList<BaseMainframeResource4GUI> resources = new ArrayList<BaseMainframeResource4GUI>();
        try {
            boolean next = true;
            String rid = "#-1:-1";
            HashSet<Integer> availableTypesForFilters = new HashSet<Integer>();
            monitor.worked(100);
            while (next && !monitor.isCanceled()) {
                String partialQuery = this.QUERY.replace("@@@@@EZLEGACY@@@@", rid != null ? " and @rid > " + rid + " " : "");
                super.setPartialQuery(partialQuery);
                Iterable results = super.getResults();
                rid = this.createObjects(resources, results, availableTypesForFilters, monitor.newChild(50));
                if (rid != null) continue;
                next = false;
            }
            ProgramInputsFactory4Wizard factory = ProgramInputsFactory4Wizard.getInstance();
            this.availableImages = factory.buildAvailableImagesFromTypes(availableTypesForFilters);
        }
        catch (ODatabaseException ex) {
            L.error("odb connection error", (Throwable)ex);
        }
        return resources;
    }

    private String createObjects(List<BaseMainframeResource4GUI> resources, Iterable<OrientElement> results, Set<Integer> availableTypesForFilters, SubMonitor pMonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)10);
        String ridId = null;
        int count = 0;
        for (OrientElement element : results) {
            String dof;
            if (monitor.isCanceled()) {
                return null;
            }
            ridId = (String)element.getProperty("rid");
            String screenName = (String)element.getProperty("name");
            String mapSetName = (String)element.getProperty("mapSet");
            String screenClass = (String)element.getProperty("screenClass");
            int screenType = -1;
            switch (screenClass) {
                case "NaturalMapProxy": {
                    screenType = 120;
                    break;
                }
                case "BMSProxy": {
                    screenType = 119;
                    break;
                }
                case "GenericScreenProxy": {
                    screenType = 220;
                    break;
                }
                case "ADSMapProxy": {
                    screenType = 118;
                    break;
                }
                case "IMSMODProxy": {
                    screenType = 65;
                }
            }
            String name = screenName;
            if (this.hasMapSet(screenType)) {
                if (Utils.filterNullValue((String)mapSetName) != null) {
                    screenName = mapSetName.concat("-").concat(screenName);
                }
            } else if (screenType == 65 && (dof = (String)element.getProperty("dof")) != null) {
                screenName = screenName.concat("(").concat(dof).concat(")");
            }
            ScreenInput screen = new ScreenInput(screenName, Integer.valueOf(screenType), ridId);
            screen.setScreenName(name);
            if (this.hasMapSet(screenType)) {
                screen.setMapSet(mapSetName);
            }
            resources.add(new BaseMainframeResource4GUI((BaseResourceInput)screen));
            availableTypesForFilters.add(screenType);
            ++count;
        }
        if (count < LIMIT) {
            ridId = null;
        }
        return ridId;
    }

    private boolean hasMapSet(int screenType) {
        return screenType == 120 || screenType == 119 || screenType == 220;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return this.availableImages;
    }
}

