/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.collectors;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.gdb.core.collectors.ODBAbstractCollector;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.JobInput;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODBJobCollector
extends ODBAbstractCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ODBJobCollector.class);
    private String QUERY = "select name as jobName, sid as jobID, member as memberName, @rid.asString() as jobRID from JCLJob @@@@@EZLEGACY@@@@ limit " + LIMIT;
    private List<ImageObj4Wizard> availableImages;

    public List doCollect(boolean useFilters, Set<String> apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)150);
        monitor.setTaskName(Messages.getString(ODBJobCollector.class, "collectingData.taskName"));
        if (this.availableImages != null) {
            this.availableImages.clear();
        }
        ArrayList<BaseMainframeResource4GUI> resources = new ArrayList<BaseMainframeResource4GUI>();
        try {
            boolean next = true;
            String rid = "#-1:-1";
            monitor.worked(100);
            while (next && !monitor.isCanceled()) {
                String partialQuery = this.QUERY.replace("@@@@@EZLEGACY@@@@", rid != null ? " where @rid > " + rid + " " : "");
                super.setPartialQuery(partialQuery);
                Iterable results = super.getResults();
                rid = this.createObjects(resources, results, monitor.newChild(50));
                if (rid != null) continue;
                next = false;
            }
        }
        catch (ODatabaseException e) {
            L.error("odb connection error", (Throwable)e);
        }
        return resources;
    }

    private String createObjects(List<BaseMainframeResource4GUI> resources, Iterable<OrientElement> results, SubMonitor pMonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)10);
        String ridId = null;
        JobInput jobRes = null;
        int count = 0;
        for (OrientElement element : results) {
            if (monitor.isCanceled()) {
                return null;
            }
            String jobID = element.getProperty("jobID").toString();
            String jobName = (String)element.getProperty("jobName");
            ridId = (String)element.getProperty("jobRID");
            String memberName = (String)element.getProperty("memberName");
            jobRes = new JobInput(jobName, memberName, jobID, ridId);
            resources.add(new BaseMainframeResource4GUI((BaseResourceInput)jobRes));
            ++count;
        }
        if (count < LIMIT) {
            ridId = null;
        }
        return ridId;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return null;
    }
}

