/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.collectors;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.gdb.core.collectors.ODBAbstractCollector;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.PrgOrIncludeWithPathInput;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODBIncludeCollector
extends ODBAbstractCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String INCLUDE_WITH_VARIABLE_QUERY = "select @rid.asString() as prid, full as path, name, type \n from Path where hasVarDef = true and in('ProgramSourceInfo').size() = 0 and type = 2 @@@@@EZLEGACY@AND@@@@  limit " + LIMIT;
    private static final Logger L = LoggerFactory.getLogger(ODBIncludeCollector.class);
    private String query;

    public List doCollect(boolean useFilters, Set<String> apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)150);
        monitor.setTaskName(Messages.getString(ODBIncludeCollector.class, "collectingData.taskName"));
        ArrayList<BaseMainframeResource4GUI> resources = new ArrayList<BaseMainframeResource4GUI>();
        try {
            String queryToExec = null;
            queryToExec = this.query != null ? this.query : INCLUDE_WITH_VARIABLE_QUERY;
            boolean next = true;
            String rid = "#-1:-1";
            HashMap<String, PrgOrIncludeWithPathInput> names = new HashMap<String, PrgOrIncludeWithPathInput>();
            monitor.worked(100);
            long start = System.currentTimeMillis();
            while (next && !monitor.isCanceled()) {
                String partialQuery = queryToExec.replace("@@@@@EZLEGACY@AND@@@@", rid != null ? " and @rid > " + rid : "");
                partialQuery = partialQuery.replace("@@@@@EZLEGACY@@@@", rid != null ? " where @rid > " + rid + " " : "");
                super.setPartialQuery(partialQuery);
                Iterable results = super.getResults();
                rid = this.createObjects(results, resources, names, (IProgressMonitor)monitor.newChild(50));
                if (rid != null) continue;
                next = false;
            }
            L.debug("endODBIncludeCollector " + (System.currentTimeMillis() - start) + " ms");
            L.debug("resources size in wizard " + resources.size());
        }
        catch (ODatabaseException e) {
            L.error("odb connection error", (Throwable)e);
        }
        return resources;
    }

    private String createObjects(Iterable<OrientElement> results, List<BaseMainframeResource4GUI> resources, Map<String, PrgOrIncludeWithPathInput> names, IProgressMonitor pMonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)10);
        String ridId = null;
        int count = 0;
        for (OrientElement vertex : results) {
            if (monitor.isCanceled()) {
                return null;
            }
            ridId = (String)vertex.getProperty("prid");
            String path = (String)vertex.getProperty("path");
            if (path != null) {
                path = path.replace("|", "\\");
            }
            String name = (String)vertex.getProperty("name");
            Integer programType = (Integer)vertex.getProperty("type");
            PrgOrIncludeWithPathInput prgInput = new PrgOrIncludeWithPathInput(name, programType, null, path, ridId);
            resources.add(new BaseMainframeResource4GUI((BaseResourceInput)prgInput));
            ++count;
        }
        if (count < LIMIT) {
            ridId = null;
        }
        return ridId;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return null;
    }
}

