/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.collectors;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.gdb.core.collectors.ODBAbstractCollector;
import com.ez.graphs.viewer.odb.analysis.wizard.DALFilesInput;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODBDALCollector
extends ODBAbstractCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ODBDALCollector.class);
    private List<ImageObj4Wizard> availableImages;
    private String dalFilesQuery = "select name as dalname, @rid.asString() as dalrid from DALProxy @@@@@EZLEGACY@@@@ and occurId<>-1 limit " + LIMIT;

    public List<ImageObj4Wizard> getAvailableImages() {
        return null;
    }

    protected List doCollect(boolean useFilters, Set<String> apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)150);
        subMonitor.setTaskName(Messages.getString(ODBDALCollector.class, "collectingData.taskName"));
        if (this.availableImages != null) {
            this.availableImages.clear();
        }
        ArrayList<BaseResourceInput4GUI> resources = new ArrayList<BaseResourceInput4GUI>();
        try {
            boolean next = true;
            String rid = "#-1:-1";
            subMonitor.worked(100);
            while (next && !subMonitor.isCanceled()) {
                String partialQuery = this.dalFilesQuery.replace("@@@@@EZLEGACY@@@@", rid != null ? " where @rid > " + rid + " " : "");
                super.setPartialQuery(partialQuery);
                Iterable results = super.getResults();
                rid = this.createObjects(resources, results, pMonitor);
                if (rid != null) continue;
                next = false;
            }
        }
        catch (ODatabaseException oDatabaseException) {
            L.error("odb connection error");
        }
        return resources;
    }

    private String createObjects(List<BaseResourceInput4GUI> resources, Iterable<OrientElement> results, IProgressMonitor pMonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)10);
        String ridID = null;
        int count = 0;
        HashSet<String> dalFilesNames = new HashSet<String>();
        for (OrientElement element : results) {
            if (monitor.isCanceled()) {
                return null;
            }
            ridID = (String)element.getProperty("dalrid");
            String dalName = (String)element.getProperty("dalname");
            if (!dalFilesNames.contains(dalName)) {
                dalFilesNames.add(dalName);
                resources.add((BaseResourceInput4GUI)new BaseMainframeResource4GUI((BaseResourceInput)new DALFilesInput(dalName, ridID)));
            }
            ++count;
        }
        if (count < LIMIT) {
            ridID = null;
        }
        return ridID;
    }
}

