/*
 * Decompiled with CFR 0.152.
 */
package com.ez.scl.procedures;

import com.ez.scl.procedures.SCLProceduresContainer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLProceduresReader {
    private static final Logger logger = LoggerFactory.getLogger(SCLProceduresReader.class);
    public static final String JSON_FILE = "stdproc.json";
    public static final String PRODUCT_CFG_FILE = "productGroups.txt";
    public static final String KEY_ARRAY_BUILTIN = "builtIn";
    public static final String KEY_ARRAY_LIBRARY = "library";
    public static final String KEY_PROCEDURE = "procedure";
    public static final String KEY_PRODUCT = "product";
    public static final String KEY_VERSION = "systemVersion";
    public static final String KEY_ALIASES = "aliases";
    public static final String KEY_PARAMS = "parameters";
    public static final String KEY_PARAM_INDEX = "index";
    public static final String KEY_PARAM_DEFAULT = "default";
    public static final String KEY_PARAM_MANDATORY = "mandatory";
    public static final String KEY_PARAM_TYPE = "type";
    public static final String KEY_PARAM_RES_NAME = "resourceName";
    public static final String KEY_PARAM_ACCESS = "accessType";
    public static final String KEY_PARAM_RES_TYPE = "resourceType";
    public static final String KEY_PARAM_COLUMN = "columnName";
    public static final String KEY_PARAM_RESID = "resId";
    public static final String KEY_PARAM_MATCHER = "match";
    public static final String KEY_PARAM_VALUES = "values";
    public static final String KEY_PARAM_MULTIPLICITY = "multiplicity";
    private static SCLProceduresContainer PROCEDURES_CONTAINER;
    private static final Object G;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SCLProceduresContainer getSCLProceduresContainer() {
        Object object = G;
        synchronized (object) {
            if (PROCEDURES_CONTAINER == null) {
                try {
                    String version;
                    JSONObject jsonRoot;
                    try (InputStreamReader reader = new InputStreamReader(SCLProceduresReader.class.getResourceAsStream(JSON_FILE));){
                        JSONTokener jtok = new JSONTokener((Reader)reader);
                        jsonRoot = new JSONObject(jtok);
                        version = jsonRoot.getString("version");
                    }
                    PROCEDURES_CONTAINER = new SCLProceduresContainer(version, SCLProceduresReader.getProcedures(jsonRoot, KEY_ARRAY_BUILTIN), SCLProceduresReader.getProcedures(jsonRoot, KEY_ARRAY_LIBRARY), SCLProceduresReader.getProductGroups());
                }
                catch (IOException e) {
                    throw new RuntimeException("Can't load standard procedures.", e);
                }
            }
        }
        return PROCEDURES_CONTAINER;
    }

    private static List<String> getProductGroups() {
        BufferedReader reader = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            String p;
            reader = new BufferedReader(new InputStreamReader(SCLProceduresReader.class.getResourceAsStream(PRODUCT_CFG_FILE)));
            do {
                if ((p = reader.readLine()) == null) continue;
                result.add(p);
            } while (p != null);
        }
        catch (IOException e) {
            logger.error("caught exception while reading product groups:");
            logger.error(e.getMessage());
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                logger.error("failed to close product group reader!");
                logger.error(e.getMessage());
            }
        }
        return result;
    }

    private static JSONArray getProcedures(JSONObject jsonRoot, String key) {
        try {
            return jsonRoot.getJSONArray(key);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        G = new Object();
    }
}

