/*
 * Decompiled with CFR 0.152.
 */
package com.ez.scl.procedures;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLProceduresContainer {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00c2\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger logger = LoggerFactory.getLogger(SCLProceduresContainer.class);
    public static final String PREFIX_KEY_ICL9 = "icl9";
    public static final String PREFIX_KEY_ICLSTDSW_DOT = "iclstdsw.";
    public static final String PREFIX_KEY_ICLCTM_DOT = "iclctm.";
    private JSONArray builtInProcedures;
    private JSONArray libraryProcedures;
    private List<String> productGroups;
    private Set<String> procedureNames;
    private String version;

    public SCLProceduresContainer(String version, JSONArray builtInProcedures, JSONArray libraryProcedures, List<String> productGroups) {
        this.version = version;
        this.builtInProcedures = builtInProcedures;
        this.libraryProcedures = libraryProcedures;
        this.productGroups = productGroups;
        this.procedureNames = new HashSet<String>();
        try {
            for (int i = 0; i < builtInProcedures.length(); ++i) {
                this.procedureNames.add(builtInProcedures.getString(i));
            }
            for (int i = 0; i < libraryProcedures.length(); ++i) {
                JSONObject jp = libraryProcedures.getJSONObject(i);
                this.procedureNames.add(jp.getString("procedure"));
                if (!jp.has("aliases")) continue;
                JSONArray procAliases = jp.getJSONArray("aliases");
                for (int j = 0; j < procAliases.length(); ++j) {
                    this.procedureNames.add(procAliases.getString(j));
                }
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public JSONArray getBuiltInProcedures() {
        return this.builtInProcedures;
    }

    public JSONArray getLibraryProcedures() {
        return this.libraryProcedures;
    }

    public List<String> getProductGroups() {
        return this.productGroups;
    }

    public Set<String> getProcedureNames() {
        return this.procedureNames;
    }

    public boolean isSCLStandardProcedure(String procedureName) {
        boolean isStandard = false;
        isStandard = this.procedureNames.contains(procedureName);
        if (!isStandard) {
            isStandard = procedureName.toLowerCase().startsWith(PREFIX_KEY_ICL9) || procedureName.toLowerCase().startsWith(PREFIX_KEY_ICLSTDSW_DOT) || procedureName.toLowerCase().startsWith(PREFIX_KEY_ICLCTM_DOT);
        }
        return isStandard;
    }
}

