/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ssdp.impl.message;

import com.ez.ssdp.impl.message.InvalidMessageException;
import com.ez.ssdp.impl.message.Location;
import com.ez.ssdp.impl.message.MessageType;
import com.ez.ssdp.impl.util.ScannerEx;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Message {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00c2\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LogManager.getLogger(Message.class);
    public static final Pattern PATTERN_FIELD = Pattern.compile("([^:]+):(.*)");
    public static final Pattern PATTERN_FILED_DQ = Pattern.compile("([^:]+):\\s*[\"]([^\"]*)[\"]\\s*");
    public static final Pattern PATTERN_LOCATION = Pattern.compile("[ ]*([^:> ]+):(?://)?([^:> ]+)(?:[:](.+))?[ ]*");
    public static final Pattern PATTERN_AL = Pattern.compile("[ ]*<([^:> ]+):(?://)?([^:> ]+)(?:[:](.+))?>[ ]*");
    public static final Pattern PATTERN_MAX_AGE = Pattern.compile("(?:\\s|,)*max-age\\s*=\\s*\"?(\\d+)\"?");

    public static String buildSearchMessage(Map<String, Object> values) {
        return String.format("M-SEARCH * HTTP/1.1\r\nMAN: \"%s\"\r\nST: \"%s\"\r\nMX: %d\r\nS: \"%s\"\r\nHost: %s:%d\r\n\r\n", "ssdp:discover", "ssdp:all", 5, Message.getValue(values, "S", null), Message.getValue(values, "GROUP", "239.255.255.250"), Message.getValue(values, "PORT", 1900));
    }

    public static String buildSearchResponseMessage(Map<String, Object> values) {
        return String.format("HTTP/1.1 200 OK\r\nS: %s\r\nExt:\r\nCache-Control: no-cache=\"Ext\", max-age = %d\r\nST: %s\r\nUSN: \"%s\"\r\nX-Environments: %s\r\nAL: <%s>\r\n\r\n", Message.getValue(values, "S", null), Message.getValue(values, "MAX-AGE", Integer.MAX_VALUE), Message.getValue(values, "ST", null), Message.getValue(values, "USN", null), Message.getValue(values, "X-ENVIRONMENTS", null), Message.getValue(values, "AL", null));
    }

    public static String buildAliveMessage(Map<String, Object> values) {
        return String.format("NOTIFY * HTTP/1.1\r\nHost: %s:%d\r\nNT: \"%s\"\r\nNTS: \"ssdp:alive\"\r\nUSN: \"%s\"\r\nX-Environments: %s\r\nAL: <%s>\r\nCache-Control: max-age = %d\r\n", Message.getValue(values, "GROUP", "239.255.255.250"), Message.getValue(values, "PORT", 1900), Message.getValue(values, "NT", null), Message.getValue(values, "USN", null), Message.getValue(values, "X-ENVIRONMENTS", null), Message.getValue(values, "AL", null), Message.getValue(values, "MAX-AGE", null));
    }

    public static String buildByeByeMessage(Map<String, Object> values) {
        return String.format("NOTIFY * HTTP/1.1\r\nHost: %s:%d\r\nNT: \"%s\"\r\nNTS: \"ssdp:byebye\"\r\nUSN: \"%s\"\r\n", Message.getValue(values, "GROUP", "239.255.255.250"), Message.getValue(values, "PORT", 1900), Message.getValue(values, "NT", null), Message.getValue(values, "USN", null));
    }

    public static Map<String, Object> parse(String message) {
        Map<String, Object> parsed = Message.rawParse(message);
        MessageType type = (MessageType)((Object)parsed.get("MSG_TYPE"));
        switch (type) {
            case SEARCH_RESPONSE: {
                List locs = (List)parsed.get("AL");
                if (locs == null || locs.size() == 0) {
                    throw new InvalidMessageException("Missing field: AL and/or LOCATION");
                }
                Message.checkFields(parsed, new String[]{"S", "ST", "USN", "X-ENVIRONMENTS"});
                break;
            }
            case SEARCH: {
                Message.checkFields(parsed, new String[]{"MAN", "ST", "S", "GROUP", "PORT"});
                break;
            }
            case NOTIFY_LIVE: {
                List locs = (List)parsed.get("AL");
                if (locs == null || locs.size() == 0) {
                    throw new InvalidMessageException("Missing field: AL and/or LOCATION");
                }
                Message.checkFields(parsed, new String[]{"GROUP", "PORT", "NT", "USN", "X-ENVIRONMENTS", "AL"});
                break;
            }
            case NOTIFY_BYEBYE: {
                Message.checkFields(parsed, new String[]{"GROUP", "PORT", "NT", "USN"});
            }
        }
        return parsed;
    }

    public static Map<String, Object> rawParse(String message) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        MessageType type = null;
        String line0 = null;
        List<String> lines = Message.split(message, "\r\n");
        if (lines.size() > 0 && (line0 = lines.get(0)).toUpperCase().startsWith("M-SEARCH")) {
            type = MessageType.SEARCH;
        }
        block4: for (String line : lines) {
            if ((line = line.trim()).length() <= 0) continue;
            for (Pattern p : new Pattern[]{PATTERN_FILED_DQ, PATTERN_FIELD}) {
                List<Location> locations;
                Matcher m = p.matcher(line);
                if (!m.matches()) continue;
                String field = m.group(1);
                String strValue = m.group(2).trim();
                if (field.equalsIgnoreCase("LOCATION")) {
                    Location l;
                    locations = (LinkedList<Location>)values.get("AL");
                    if (locations == null) {
                        locations = new LinkedList<Location>();
                    }
                    if ((l = Message.parseLocation(strValue)) == null) continue block4;
                    locations.add(0, l);
                    values.put("AL", locations);
                    continue block4;
                }
                if (field.equalsIgnoreCase("AL")) {
                    List<Location> newLocations;
                    locations = (List)values.get("AL");
                    if (locations == null) {
                        locations = new LinkedList();
                    }
                    if ((newLocations = Message.parseAL(strValue)).size() <= 0) continue block4;
                    locations.addAll(newLocations);
                    values.put("AL", locations);
                    continue block4;
                }
                if (field.equalsIgnoreCase("HOST")) {
                    String[] pieces = strValue.split(":");
                    String host = null;
                    Integer port = null;
                    if (pieces.length > 0) {
                        host = pieces[0];
                    }
                    if (pieces.length > 1) {
                        try {
                            port = Integer.parseInt(pieces[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (host != null) {
                        values.put("GROUP", host);
                    }
                    if (port == null) continue block4;
                    values.put("PORT", port);
                    continue block4;
                }
                if (field.equalsIgnoreCase("CACHE-CONTROL")) {
                    Integer maxAge = Message.scanForMaxAge(strValue);
                    if (maxAge == null) continue block4;
                    values.put("MAX-AGE", maxAge);
                    continue block4;
                }
                if (field.equalsIgnoreCase("X-ENVIRONMENTS")) {
                    List<String> envs = Message.split(strValue, ',', '\"');
                    values.put("X-ENVIRONMENTS", envs);
                    continue block4;
                }
                Integer i = null;
                try {
                    i = Integer.parseInt(strValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                values.put(field.toUpperCase(), i != null ? i : strValue);
                continue block4;
            }
            L.debug("Malformed line: " + line);
        }
        if (type == null) {
            if (line0 != null && Message.fieldStartsWith(line0, "NOTIFY")) {
                if (Message.fieldEquals(values, "NTS", "ssdp:alive")) {
                    type = MessageType.NOTIFY_LIVE;
                } else if (Message.fieldEquals(values, "NTS", "ssdp:byebye")) {
                    type = MessageType.NOTIFY_BYEBYE;
                } else {
                    L.debug("Unknown NTS field: " + values.get("NTS"));
                }
            }
            if (type == null && values.containsKey("S")) {
                type = MessageType.SEARCH_RESPONSE;
            }
        }
        if (type == null) {
            throw new InvalidMessageException("Can't detect type.");
        }
        values.put("MSG_TYPE", (Object)type);
        L.trace("Splitted message: " + values);
        return values;
    }

    private static void checkFields(Map<String, Object> message, String[] fields) {
        for (String f : fields) {
            if (message.containsKey(f)) continue;
            throw new InvalidMessageException("Missing field: " + f);
        }
    }

    private static boolean fieldStartsWith(String value, String what) {
        return value.toUpperCase().startsWith(what);
    }

    private static boolean fieldEquals(Map<String, Object> values, String key, Object expected) {
        Object value = values.get(key);
        if (value == null) {
            return expected == null;
        }
        if (value instanceof String) {
            String strValue = (String)value;
            return strValue.equals(expected);
        }
        return value.equals(expected);
    }

    private static Location parseLocation(String value) {
        Location l = null;
        Matcher m = PATTERN_LOCATION.matcher(value);
        if (m.matches()) {
            Integer port = null;
            try {
                port = m.groupCount() == 3 ? Integer.valueOf(Integer.parseInt(m.group(3))) : null;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            l = new Location(m.group(1), m.group(2), port);
        }
        return l;
    }

    private static List<Location> parseAL(String value) {
        LinkedList<Location> locations = new LinkedList<Location>();
        int start = 0;
        Matcher m = PATTERN_AL.matcher(value);
        while (start < value.length()) {
            if (m.find(start) && m.start() == start) {
                Integer port = null;
                try {
                    port = m.groupCount() == 3 ? Integer.valueOf(Integer.parseInt(m.group(3))) : null;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                locations.add(new Location(m.group(1), m.group(2), port));
                start = m.end();
                continue;
            }
            L.debug("Invalid AL line: " + value);
            locations.clear();
            break;
        }
        return locations;
    }

    private static Object getValue(Map<String, Object> values, String key, Object defaultValue) {
        Object r = values.get(key);
        if (r == null) {
            if (defaultValue == null) {
                throw new IllegalArgumentException(String.format("Value %s not supplied.", key));
            }
            r = defaultValue;
        }
        if (r != null && r instanceof Collection) {
            r = Message.join((Collection)r, ",", "\"");
        }
        return r;
    }

    private static String join(Collection<String> list, String sep, String quote) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        for (String le : list) {
            if (i > 0) {
                b.append(sep);
            }
            if (le.contains(sep)) {
                b.append(quote);
                b.append(le.replaceAll(quote, "\\" + quote));
                b.append(quote);
            } else {
                b.append(le);
            }
            ++i;
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> split(String string, char sep, char quote) {
        LinkedList<String> els = new LinkedList<String>();
        try (Scanner sc = new Scanner(string);){
            ScannerEx sce = new ScannerEx(sc, quote);
            sc.useDelimiter(String.valueOf(sep));
            while (sc.hasNext()) {
                els.add(sce.next());
            }
        }
        return els;
    }

    public static void main(String[] args) {
        System.out.println(Message.split("fdfd,\"ddd\"", ',', '\"'));
    }

    private static List<String> split(String string, String sep) {
        int start = 0;
        LinkedList<String> pieces = new LinkedList<String>();
        while (start < string.length()) {
            int index = string.indexOf(sep, start);
            if (index > -1) {
                pieces.add(string.substring(start, index));
                start = index + sep.length();
                continue;
            }
            pieces.add(string.substring(start));
            break;
        }
        return pieces;
    }

    private static Integer scanForMaxAge(String fieldValue) {
        Integer maxAge = null;
        Matcher m = PATTERN_MAX_AGE.matcher(fieldValue);
        if (m.find()) {
            String raw = m.group(1);
            try {
                maxAge = Integer.valueOf(raw);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return maxAge;
    }
}

