/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ssdp.impl;

import com.ez.ssdp.impl.SocketListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatagramSocketMonitor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00c2\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Logger logger = LogManager.getLogger(this.getClass());
    private Thread t = new Thread(){

        @Override
        public void run() {
            DatagramSocketMonitor.this.loop();
        }
    };
    private volatile boolean canceled;
    private DatagramSocket s;
    private SocketListener l;
    private int bufferSize;

    public DatagramSocketMonitor(DatagramSocket s, int bufferSize, SocketListener l) {
        if (s == null) {
            throw new IllegalArgumentException("s");
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize");
        }
        if (l == null) {
            throw new IllegalArgumentException("l");
        }
        this.bufferSize = bufferSize;
        this.s = s;
        this.l = l;
    }

    public void start() {
        this.t = new Thread("SocketMonitor"){

            @Override
            public void run() {
                DatagramSocketMonitor.this.loop();
            }
        };
        try {
            this.s.setSoTimeout(1000);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        this.t.start();
    }

    public void stop() {
        if (this.t != null) {
            this.canceled = true;
            try {
                this.t.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.t = null;
                this.canceled = false;
            }
        }
    }

    private void loop() {
        while (true) {
            if (this.canceled) {
                this.logger.debug("Canceled.");
                break;
            }
            byte[] buffer = new byte[this.bufferSize];
            DatagramPacket p = new DatagramPacket(buffer, this.bufferSize);
            boolean hasData = false;
            try {
                if (this.logger.isTraceEnabled()) {
                    this.logger.log(Level.TRACE, "Enter receive.");
                }
                try {
                    this.s.receive(p);
                    hasData = true;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.log(Level.TRACE, "Exit receive.");
                }
            }
            catch (IOException ex) {
                this.logger.trace("Exit receive with error.");
                try {
                    this.l.onException(ex);
                }
                catch (Exception e2) {
                    this.logger.error("Can't call listener.", (Throwable)e2);
                }
            }
            if (this.canceled) {
                this.logger.debug("Canceled.");
                break;
            }
            if (!hasData || p.getLength() <= 0) continue;
            this.logger.trace("Data read.");
            try {
                this.l.onDataRead(buffer, 0, p.getLength(), p.getSocketAddress());
            }
            catch (Exception ex) {
                this.logger.error("Can't call listener.", (Throwable)ex);
            }
        }
    }
}

