/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ssdp;

import com.ez.ssdp.ServiceLocation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class SsdpServiceInfo {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00c2\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private final String serviceType;
    private final String serviceName;
    private final ServiceLocation location;
    private final Set<String> environments;
    private final int maxAge;
    private final int hashCode;

    public SsdpServiceInfo(String serviceType, String serviceName, ServiceLocation location, String environment, int maxAge) {
        this(serviceType, serviceName, location, Collections.singleton(environment), maxAge);
    }

    public SsdpServiceInfo(String serviceType, String serviceName, ServiceLocation location, Set<String> environments, int maxAge) {
        if (serviceType == null) {
            throw new IllegalArgumentException("serviceType: " + serviceType);
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName: " + serviceName);
        }
        if (location == null) {
            throw new IllegalArgumentException("location: " + location);
        }
        if (environments == null) {
            throw new IllegalArgumentException("environments not set");
        }
        if (maxAge < 0) {
            throw new IllegalArgumentException("maxAge < 0");
        }
        this.serviceName = serviceName;
        this.serviceType = serviceType;
        this.location = location;
        this.environments = Collections.unmodifiableSet(environments);
        this.maxAge = maxAge;
        this.hashCode = Arrays.hashCode(new Object[]{this.serviceType, this.serviceName, this.location, this.maxAge});
    }

    public Set<String> getEnvironments() {
        return this.environments;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ServiceLocation getLocation() {
        return this.location;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SsdpServiceInfo)) {
            return false;
        }
        SsdpServiceInfo si = (SsdpServiceInfo)o;
        return this.serviceType.equalsIgnoreCase(si.serviceType) && this.serviceName.equalsIgnoreCase(si.serviceName) && this.location.equals(si.location) && this.environments.equals(si.environments) && this.maxAge == si.maxAge;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("[");
        b.append(this.getClass().getSimpleName());
        b.append(", serviceName:");
        b.append(this.serviceName);
        b.append(", serviceType:");
        b.append(this.serviceType);
        b.append(", location:");
        b.append(this.location);
        b.append(", environments:");
        b.append(this.environments.toArray());
        b.append(", maxAge:");
        b.append(this.maxAge);
        b.append("]");
        return b.toString();
    }
}

