/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ssdp;

import com.ez.ssdp.MessageCallback;
import com.ez.ssdp.NetworkCallback;
import com.ez.ssdp.ServiceLocation;
import com.ez.ssdp.SsdpListener;
import com.ez.ssdp.SsdpServiceInfo;
import com.ez.ssdp.impl.message.InvalidMessageException;
import com.ez.ssdp.impl.message.Location;
import com.ez.ssdp.impl.message.Message;
import com.ez.ssdp.impl.message.MessageType;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.apache.commons.configuration.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SsdpService {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00c2\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LogManager.getLogger(SsdpService.class);
    public static final String SSDP_SERVICE_HOST = "ssdp.server.host";
    public static final String SSDP_SERVICE_HOST_DEFAULT = "localhost";
    public static final String SSDP_SERVICE_DISABLE_LOOPBACK = "ssdp.server.disable_loopback";
    public static final boolean SSDP_SERVICE_DISABLE_LOOPBACK_DEFAULT = true;
    public static final String ENABLE_ANNOUNCE_SELF = "ssdp.announce_self";
    public static final boolean ENABLE_ANNOUNCE_SELF_DEFAULT = true;
    public static final String ENABLE_SEARCH = "ssdp.enable_search";
    public static final boolean ENABLE_SEARCH_DEFAULT = true;
    public static final String UDP_GROUP = "ssdp.group";
    public static final String UDP_GROUP_DEFAULT = "239.255.255.250";
    public static final String SSDP_PORT = "ssdp.port";
    public static final int SSDP_PORT_DEFAULT = 1900;
    public static final String SSDP_SEARCH_INTERVAL = "ssdp.search_period";
    public static final int SSDP_SEARCH_INTERVAL_DEFAULT = 60;
    public static final String SSDP_NOTIFY_INTERVAL = "ssdp.notify_interval";
    public static final int SSDP_NOTIFY_INTERVAL_DEFAULT = 60;
    public static final String SSDP_STALLED_CHECK_INTERVAL = "ssdp.stalled_check_interval";
    public static final int SSDP_STALLED_CHECK_INTERVAL_DEFAULT = 60;
    private final String group;
    private final int port;
    private NetworkCallback network = null;
    private Timer timer;
    private SsdpServiceInfo serviceInfo;
    private String lastId;
    private HashSet<SsdpListener> listeners;
    private Map<String, ServiceInfo> services;
    private Configuration conf;
    private State state = State.Created;

    public SsdpService(SsdpServiceInfo serviceInfo, Configuration conf) {
        this(conf);
        if (serviceInfo == null) {
            throw new IllegalArgumentException("serviceInfo");
        }
        this.serviceInfo = serviceInfo;
    }

    public SsdpService(Configuration conf) {
        if (conf == null) {
            throw new IllegalArgumentException("conf");
        }
        this.conf = conf;
        this.group = conf.getString(UDP_GROUP, UDP_GROUP_DEFAULT);
        this.port = conf.getInt(SSDP_PORT, 1900);
        this.listeners = new HashSet();
        this.services = new HashMap<String, ServiceInfo>();
    }

    public synchronized void setNetworkCallback(NetworkCallback network) {
        if (this.state != State.Created) {
            throw new IllegalStateException();
        }
        this.network = network;
        this.network.setMessageCallback(new MessageCallback(){

            @Override
            public void receive(String message, InetSocketAddress remoteAddress) {
                SsdpService.this.receive(message, remoteAddress);
            }
        });
    }

    public synchronized void addListener(SsdpListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeListener(SsdpListener l) {
        this.listeners.remove(l);
    }

    public synchronized void start() {
        if (this.state != State.Created) {
            throw new IllegalStateException("Service started.");
        }
        if (this.network == null) {
            throw new IllegalStateException("Network not set or setNetworkCallback() not called.");
        }
        this.timer = new Timer();
        if (this.serviceInfo != null && this.conf.getBoolean(ENABLE_ANNOUNCE_SELF, true)) {
            L.info("Self announcement enabled.");
            this.announceAlive();
            this.scheduleAnnounce();
        }
        if (this.conf.getBoolean(ENABLE_SEARCH, true)) {
            L.info("Search enabled.");
            this.searchServices();
            this.scheduleSearch();
        }
        this.scheduleStalledWatcher();
        this.state = State.Started;
    }

    public synchronized void stop() {
        if (this.state == State.Started) {
            try {
                this.timer.cancel();
                if (this.serviceInfo != null && this.conf.getBoolean(ENABLE_ANNOUNCE_SELF, true)) {
                    try {
                        this.announceByebye();
                    }
                    catch (Exception ex) {
                        L.error("Can't say byebye.", (Throwable)ex);
                    }
                }
            }
            finally {
                this.timer = null;
                this.services.clear();
                this.state = State.Created;
            }
        }
    }

    public void reset() {
        this.reset(null, this.conf);
    }

    public synchronized void reset(SsdpServiceInfo si, Configuration conf) {
        if (this.state == State.Started) {
            this.timer.cancel();
            this.services.clear();
            if (si != null) {
                this.serviceInfo = si;
            }
            if (conf != null) {
                this.conf = conf;
            }
            this.timer = new Timer();
            if (this.serviceInfo != null && this.conf.getBoolean(ENABLE_ANNOUNCE_SELF, true)) {
                this.announceAlive();
                this.scheduleAnnounce();
            }
            if (this.conf.getBoolean(ENABLE_SEARCH, true)) {
                this.searchServices();
                this.scheduleSearch();
            }
        }
    }

    public synchronized Set<SsdpServiceInfo> getSsdpServices() {
        HashSet<SsdpServiceInfo> r = new HashSet<SsdpServiceInfo>();
        for (ServiceInfo si : this.services.values()) {
            r.add(si.ssdpi);
        }
        return r;
    }

    private void receive(String message, InetSocketAddress remoteAddress) {
        this.process(message, remoteAddress);
    }

    private synchronized void process(String message, InetSocketAddress remoteAddress) {
        Map<String, Object> parsed;
        block13: {
            parsed = null;
            if (L.isTraceEnabled()) {
                L.trace("Message content: " + message);
            }
            try {
                parsed = Message.parse(message);
            }
            catch (InvalidMessageException ex) {
                if (L.isTraceEnabled()) {
                    L.trace("Invalid message: " + ex.getMessage());
                }
            }
            catch (Exception ex) {
                if (!L.isTraceEnabled()) break block13;
                L.debug("Can't parse message.", (Throwable)ex);
            }
        }
        if (parsed != null) {
            if (L.isDebugEnabled()) {
                L.debug("Message arrived from " + remoteAddress + " :" + this.getMessageHeader(message, null));
            }
            switch ((MessageType)((Object)parsed.get("MSG_TYPE"))) {
                case SEARCH: {
                    this.onSearch(parsed, remoteAddress);
                    break;
                }
                case SEARCH_RESPONSE: {
                    this.onSearchResponse(parsed);
                    break;
                }
                case NOTIFY_LIVE: {
                    this.onAliveMessage(parsed);
                    break;
                }
                case NOTIFY_BYEBYE: {
                    this.onByeByeMessage(parsed);
                    break;
                }
                default: {
                    L.debug("Unknown message type: " + parsed.get("MSG_TYPE"));
                }
            }
        }
    }

    private synchronized void processStalled() {
        HashSet<String> keys = new HashSet<String>(this.services.keySet());
        long now = System.currentTimeMillis();
        for (String k : keys) {
            ServiceInfo si = this.services.get(k);
            if (now - si.lastAlive <= (long)(si.ssdpi.getMaxAge() * 1000)) continue;
            L.info("Service stalled, will be removed: " + si.ssdpi);
            this.services.remove(k);
            this.notifyListeners(Notification.EXPIRED, si.ssdpi, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(Notification n, SsdpServiceInfo si, SsdpServiceInfo newSi) {
        Set all;
        SsdpService ssdpService = this;
        synchronized (ssdpService) {
            all = (Set)this.listeners.clone();
        }
        for (SsdpListener l : all) {
            try {
                n.process(l, si, newSi);
            }
            catch (Exception ex) {
                L.error("Failed listener " + l, (Throwable)ex);
            }
        }
    }

    private void scheduleAnnounce() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    SsdpService.this.announceAlive();
                }
                finally {
                    SsdpService.this.scheduleAnnounce();
                }
            }
        }, (long)((double)(this.serviceInfo.getMaxAge() * 1000) * 0.8));
    }

    private void scheduleStalledWatcher() {
        long checkDelay = 1000 * this.conf.getInteger(SSDP_STALLED_CHECK_INTERVAL, Integer.valueOf(60));
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    SsdpService.this.processStalled();
                }
                finally {
                    SsdpService.this.scheduleStalledWatcher();
                }
            }
        }, checkDelay * 1000L);
    }

    private void scheduleSearch() {
        long searchDelay = 1000 * this.conf.getInteger(SSDP_SEARCH_INTERVAL, Integer.valueOf(60));
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    SsdpService.this.searchServices();
                }
                finally {
                    SsdpService.this.scheduleSearch();
                }
            }
        }, searchDelay);
    }

    private void announceAlive() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("GROUP", this.conf.getString(UDP_GROUP, UDP_GROUP_DEFAULT));
        values.put("PORT", this.conf.getInteger(SSDP_PORT, Integer.valueOf(1900)));
        values.put("NT", this.serviceInfo.getServiceType());
        values.put("USN", this.serviceInfo.getServiceName());
        values.put("AL", this.serviceInfo.getLocation().toUrl());
        values.put("MAX-AGE", this.serviceInfo.getMaxAge());
        values.put("X-ENVIRONMENTS", this.serviceInfo.getEnvironments());
        String message = Message.buildAliveMessage(values);
        L.debug("Announce message NOTIFY ALIVE");
        this.network.broadcast(message);
    }

    private void announceByebye() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("GROUP", this.conf.getString(UDP_GROUP, UDP_GROUP_DEFAULT));
        values.put("PORT", this.conf.getInteger(SSDP_PORT, Integer.valueOf(1900)));
        values.put("NT", this.serviceInfo.getServiceType());
        values.put("USN", this.serviceInfo.getServiceName());
        String message = Message.buildByeByeMessage(values);
        L.debug("Announce message NOTIFY BYE BYE");
        this.network.broadcast(message);
    }

    private synchronized void searchServices() {
        this.lastId = UUID.randomUUID().toString();
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("GROUP", this.conf.getString(UDP_GROUP, UDP_GROUP_DEFAULT));
        values.put("PORT", this.conf.getInteger(SSDP_PORT, Integer.valueOf(1900)));
        values.put("S", this.lastId);
        String message = Message.buildSearchMessage(values);
        L.debug("Broadcast message M-SEARCH");
        this.network.broadcast(message);
    }

    private void onSearch(Map<String, Object> messageValues, InetSocketAddress addr) {
        if (this.serviceInfo == null) {
            if (L.isTraceEnabled()) {
                L.trace("No self service info, discard SEARCH message.");
            }
        } else {
            final String sid = (String)messageValues.get("S");
            if (sid == null) {
                if (L.isTraceEnabled()) {
                    L.trace("No sid.");
                }
            } else {
                String serviceType = (String)messageValues.get("ST");
                if (!serviceType.equals(this.serviceInfo.getServiceType()) && !serviceType.equals("ssdp:all")) {
                    if (L.isTraceEnabled()) {
                        L.trace("Unknown service type: " + serviceType);
                    }
                } else {
                    String group = (String)messageValues.get("GROUP");
                    if (!group.equals(this.group)) {
                        if (L.isTraceEnabled()) {
                            L.trace("Unknown group: " + group);
                        }
                    } else {
                        Integer port = (Integer)messageValues.get("PORT");
                        if (!port.equals(this.port)) {
                            if (L.isTraceEnabled()) {
                                L.trace("Unknown port: " + port);
                            }
                        } else {
                            String man = (String)messageValues.get("MAN");
                            if (!man.equals("ssdp:discover")) {
                                if (L.isTraceEnabled()) {
                                    L.trace("Unknown MAN field: " + man);
                                }
                            } else {
                                L.debug("Send M-SEARCH REPONSE");
                                final SsdpServiceInfo si = this.serviceInfo;
                                this.network.send(Message.buildSearchResponseMessage((Map<String, Object>)new HashMap<String, Object>(){
                                    {
                                        this.put("S", sid);
                                        this.put("MAX-AGE", si.getMaxAge());
                                        this.put("ST", si.getServiceType());
                                        this.put("USN", si.getServiceName());
                                        this.put("X-ENVIRONMENTS", si.getEnvironments());
                                        this.put("AL", si.getLocation().toUrl());
                                    }
                                }), addr);
                            }
                        }
                    }
                }
            }
        }
    }

    private synchronized void onSearchResponse(Map<String, Object> message) {
        if (this.lastId == null) {
            if (L.isTraceEnabled()) {
                L.trace("Not waiting for response, discard message.");
            }
        } else {
            String sid = (String)message.get("S");
            if (sid == null || !sid.equals(this.lastId)) {
                if (L.isTraceEnabled()) {
                    L.trace("Sid doesn't match, discard: " + sid);
                }
            } else {
                this.lastId = null;
                this.updateServiceInfo(message, "ST");
            }
        }
    }

    private void onAliveMessage(Map<String, Object> messageValues) {
        String group = (String)messageValues.get("GROUP");
        if (!group.equals(this.group)) {
            if (L.isTraceEnabled()) {
                L.trace("Unknown group: " + group);
            }
        } else {
            Integer port = (Integer)messageValues.get("PORT");
            if (!port.equals(this.port)) {
                if (L.isTraceEnabled()) {
                    L.trace("Unknown port: " + port);
                }
            } else {
                String nts = (String)messageValues.get("NTS");
                if (!nts.equals("ssdp:alive")) {
                    if (L.isTraceEnabled()) {
                        L.trace("Unknown notification: " + nts);
                    }
                } else {
                    this.updateServiceInfo(messageValues, "NT");
                }
            }
        }
    }

    private void onByeByeMessage(Map<String, Object> messageValues) {
        String group = (String)messageValues.get("GROUP");
        if (!group.equals(this.group)) {
            if (L.isTraceEnabled()) {
                L.trace("Unknown group: " + group);
            }
        } else {
            Integer port = (Integer)messageValues.get("PORT");
            if (!port.equals(this.port)) {
                if (L.isTraceEnabled()) {
                    L.trace("Unknown port: " + port);
                }
            } else {
                String serviceName = (String)messageValues.get("USN");
                ServiceInfo si = this.services.remove(serviceName);
                if (si != null) {
                    this.notifyListeners(Notification.REMOVED, si.ssdpi, null);
                } else {
                    L.debug("Unknown service: " + serviceName);
                }
            }
        }
    }

    private void updateServiceInfo(Map<String, Object> message, String serviceTypeField) {
        String serviceName = (String)message.get("USN");
        String serviceType = (String)message.get(serviceTypeField);
        Integer maxAge = (Integer)message.get("MAX-AGE");
        Collection environments = (Collection)message.get("X-ENVIRONMENTS");
        List locs = (List)message.get("AL");
        Location loc = null;
        if (maxAge == null) {
            maxAge = Integer.MAX_VALUE;
        }
        if (locs.size() > 1) {
            L.warn(String.format("Service %s has multiple locations, keeping first only: %s", serviceName, locs));
        }
        loc = (Location)locs.get(0);
        ServiceInfo si = this.services.get(serviceName);
        if (si != null) {
            SsdpServiceInfo ssdp = new SsdpServiceInfo(serviceType, serviceName, new ServiceLocation(loc.getProtocol(), loc.getHost(), loc.getPort()), new HashSet<String>(environments), (int)maxAge);
            if (!ssdp.equals(si.ssdpi)) {
                SsdpServiceInfo oldssdp = si.ssdpi;
                si.ssdpi = ssdp;
                si.lastAlive = System.currentTimeMillis();
                this.notifyListeners(Notification.UPDATED, oldssdp, ssdp);
            }
        } else {
            SsdpServiceInfo ssdp = new SsdpServiceInfo(serviceType, serviceName, new ServiceLocation(loc.getProtocol(), loc.getHost(), loc.getPort()), new HashSet<String>(environments), (int)maxAge);
            si = new ServiceInfo(ssdp);
            this.services.put(serviceName, si);
            this.notifyListeners(Notification.ADDED, ssdp, null);
        }
    }

    private String getMessageHeader(String msg, Integer msgLen) {
        int len;
        int origLen = msg.length();
        int n = len = msgLen != null ? msgLen : 32;
        if (msg.length() < len) {
            len = msg.length();
        }
        msg = msg.substring(0, len);
        msg = msg.replace("\r\n", "\\r\\n");
        msg = msg.replace("\n", "\\n");
        if ((msg = msg.replace("\r", "\\r")).length() < origLen) {
            msg = msg + "... [truncated]";
        }
        return msg;
    }

    private static class ServiceInfo {
        long lastAlive;
        SsdpServiceInfo ssdpi;

        public ServiceInfo(SsdpServiceInfo ssdpi) {
            this.ssdpi = ssdpi;
            this.lastAlive = System.currentTimeMillis();
        }
    }

    private static interface Notification {
        public static final Notification ADDED = new Notification(){

            @Override
            public void process(SsdpListener l, SsdpServiceInfo si, SsdpServiceInfo newSi) {
                l.serviceOnline(si);
            }
        };
        public static final Notification REMOVED = new Notification(){

            @Override
            public void process(SsdpListener l, SsdpServiceInfo si, SsdpServiceInfo newSi) {
                l.serviceOffline(si);
            }
        };
        public static final Notification EXPIRED = new Notification(){

            @Override
            public void process(SsdpListener l, SsdpServiceInfo si, SsdpServiceInfo newSi) {
                l.serviceExpired(si);
            }
        };
        public static final Notification UPDATED = new Notification(){

            @Override
            public void process(SsdpListener l, SsdpServiceInfo si, SsdpServiceInfo newSi) {
                l.serviceUpdated(si, newSi);
            }
        };

        public void process(SsdpListener var1, SsdpServiceInfo var2, SsdpServiceInfo var3);
    }

    private static enum State {
        Created,
        Started;

    }
}

