/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ssdp;

import com.ez.ssdp.MessageCallback;
import com.ez.ssdp.NetworkCallback;
import com.ez.ssdp.impl.DatagramSocketMonitor;
import com.ez.ssdp.impl.SocketListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import org.apache.commons.configuration.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SsdpNetworkService
implements NetworkCallback {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00c2\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Logger L = LogManager.getLogger(this.getClass());
    public final int UDP_BUFFER_SIZE = 4096;
    private final String serverHost;
    private final String group;
    private final int port;
    private DatagramSocketMonitor socketMon;
    private MulticastSocket socket;
    private MessageCallback msgCbk;
    private InetSocketAddress groupAddr;
    private boolean enableSearch;
    private boolean disableLoopback;

    public SsdpNetworkService(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("config");
        }
        this.serverHost = config.getString("ssdp.server.host", "localhost");
        this.group = config.getString("ssdp.group", "239.255.255.250");
        this.port = config.getInt("ssdp.port", 1900);
        this.enableSearch = config.getBoolean("ssdp.enable_search", true);
        this.disableLoopback = config.getBoolean("ssdp.server.disable_loopback", true);
        String group = config.getString("ssdp.group", "239.255.255.250");
        this.groupAddr = new InetSocketAddress(group, this.port);
    }

    @Override
    public void setMessageCallback(MessageCallback msgCbk) {
        this.msgCbk = msgCbk;
    }

    @Override
    public void send(String message, InetSocketAddress addr) {
        this.onSendMessage(message, addr);
    }

    @Override
    public void broadcast(String message) {
        this.onSendBroadcastMessage(message);
    }

    public synchronized void start() {
        try {
            this.L.info("Listen on port: " + this.port);
            this.socket = new MulticastSocket(this.port);
            if (this.disableLoopback) {
                this.L.info("Set loopback mode hint to true");
                this.socket.setLoopbackMode(true);
            }
            InetAddress gaddr = Inet4Address.getByName(this.group);
            this.L.info("Joining group " + gaddr);
            this.socket.joinGroup(gaddr);
            NetworkInterface ni = NetworkInterface.getByInetAddress(InetAddress.getByName(this.serverHost));
            if (ni == null) {
                this.L.warn("Can't find network interface for: " + this.serverHost);
            } else {
                this.L.info("... interface " + ni.getDisplayName());
                this.socket.setNetworkInterface(ni);
            }
            if (!this.enableSearch) {
                this.L.info("Search not enabled, network monitor will not be started.");
            } else {
                this.socketMon = new DatagramSocketMonitor(this.socket, 4096, new SocketListener(){

                    @Override
                    public void onException(Exception ex) {
                        SsdpNetworkService.this.L.error("Connection broken.", (Throwable)ex);
                    }

                    @Override
                    public void onDataRead(byte[] data, int start, int end, SocketAddress sender) {
                        SsdpNetworkService.this.onMessageReceived(new String(data, start, end - start), (InetSocketAddress)sender);
                    }
                });
                this.socketMon.start();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void stop() {
        if (this.socketMon != null) {
            try {
                this.socketMon.stop();
            }
            catch (Exception ex) {
                this.L.error("Unexpceted error.", (Throwable)ex);
            }
        }
        try {
            this.socket.close();
        }
        catch (Exception ex) {
            this.L.error("Unexpceted error.", (Throwable)ex);
        }
    }

    private void onSendBroadcastMessage(String message) {
        DatagramPacket p;
        byte[] b = message.getBytes();
        try {
            p = new DatagramPacket(b, b.length, this.groupAddr);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        try {
            this.socket.send(p);
            if (this.L.isTraceEnabled()) {
                this.L.trace("Message sent: " + message);
            }
        }
        catch (IOException e) {
            this.L.error("Can't send.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSendMessage(String message, InetSocketAddress receiver) {
        DatagramPacket p;
        byte[] b = message.getBytes();
        try {
            p = new DatagramPacket(b, b.length, receiver);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        try {
            try (DatagramSocket s = new DatagramSocket();){
                s.send(p);
            }
            if (this.L.isTraceEnabled()) {
                this.L.trace("Message sent: " + message);
            }
        }
        catch (IOException e) {
            this.L.error("Can't send.", (Throwable)e);
        }
    }

    private synchronized void onMessageReceived(String message, InetSocketAddress senderAddress) {
        if (this.L.isTraceEnabled()) {
            this.L.trace("Message from " + senderAddress + " received: " + message);
        }
        if (senderAddress.equals(this.socket.getLocalSocketAddress())) {
            if (this.L.isTraceEnabled()) {
                this.L.trace("Ignore own broadcasted messages: " + senderAddress);
            }
        } else if (this.msgCbk != null) {
            try {
                this.msgCbk.receive(message, senderAddress);
            }
            catch (Exception ex) {
                this.L.error("Unexpected error.", (Throwable)ex);
            }
        } else {
            this.L.error("Sink not set.");
        }
    }
}

