/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ssdp;

import java.util.Arrays;

public class ServiceLocation {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00c2\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private final String protocol;
    private final String host;
    private final Integer port;
    private final String toString;
    private final String toUrl;
    private final int hashCode;

    public ServiceLocation(String protocol, String host, Integer port) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol");
        }
        if (host == null) {
            throw new IllegalArgumentException("host");
        }
        if (port == null) {
            throw new IllegalArgumentException("port");
        }
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.protocol).append("://").append(this.host);
        if (this.port != null) {
            urlBuilder.append(":").append(this.port);
        }
        this.toUrl = urlBuilder.toString();
        this.toString = "[protocol: " + this.protocol + ", host: " + this.host + ", port: " + this.port + "]";
        this.hashCode = Arrays.hashCode(new Object[]{this.protocol.toLowerCase(), this.host.toLowerCase(), this.port});
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ServiceLocation)) {
            return false;
        }
        ServiceLocation l = (ServiceLocation)o;
        return this.protocol.equalsIgnoreCase(l.protocol) && this.host.equalsIgnoreCase(l.host) && this.port.equals(l.port);
    }

    public String toString() {
        return this.toString;
    }

    public String toUrl() {
        return this.toUrl;
    }
}

