/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.structure;

import com.ez.mainframe.model.ProjectInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ProjectStructureModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Map<String, List<ProjectFolder>> children = new HashMap<String, List<ProjectFolder>>();
    private Map<String, ProjectFolder> elements = new HashMap<String, ProjectFolder>();
    private String rootLevel = "-1";
    private ProjectInfo pinfo;

    private ProjectStructureModel() {
    }

    public static ProjectStructureModel build(ProjectInfo pinfo, String[][] data, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        ProjectStructureModel model = new ProjectStructureModel();
        model.pinfo = pinfo;
        ProjectFolder root = new ProjectFolder("-1", pinfo.getName(), "-2", "0");
        model.elements.put("-1", root);
        List<Object> clist = new ArrayList<ProjectFolder>();
        clist.add(root);
        model.children.put("-2", clist);
        if (data != null) {
            monitor.setWorkRemaining(data.length);
            String[][] stringArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                String[] row = stringArray[n2];
                String idFolder = row[0];
                String folderName = row[1];
                String folderAncestor = row[2];
                String resources = row[3];
                ProjectFolder folder = new ProjectFolder(idFolder, folderName, folderAncestor, resources);
                model.elements.put(idFolder, folder);
                clist = model.children.get(folderAncestor);
                if (clist == null) {
                    clist = new ArrayList();
                    model.children.put(folderAncestor, clist);
                }
                clist.add(folder);
                monitor.worked(1);
                ++n2;
            }
        }
        return model;
    }

    public ProjectFolder[] getElements() {
        List<ProjectFolder> clist = this.children.get(this.rootLevel);
        if (clist != null && !clist.isEmpty()) {
            return clist.toArray(new ProjectFolder[0]);
        }
        return null;
    }

    public boolean isEmpty() {
        List<ProjectFolder> clist = this.children.get(this.rootLevel);
        return clist == null || clist.isEmpty();
    }

    public ProjectFolder[] getChildren(ProjectFolder pf) {
        String folderID = pf.getID();
        List<ProjectFolder> clist = this.children.get(folderID);
        if (clist != null) {
            return clist.toArray(new ProjectFolder[0]);
        }
        return null;
    }

    public ProjectFolder getParent(ProjectFolder pf) {
        String ancestor = pf.getAncestorID();
        ProjectFolder parent = this.elements.get(ancestor);
        return parent;
    }

    public boolean hasChildren(ProjectFolder pf) {
        String folderID = pf.getID();
        List<ProjectFolder> clist = this.children.get(folderID);
        return clist != null && clist.size() > 0;
    }

    public static class ProjectFolder
    implements Comparable<ProjectFolder> {
        private String idFolder;
        private String folderName;
        private String folderAncestor;
        private String resources;

        public ProjectFolder(String idFolder, String folderName, String folderAncestor, String resources) {
            this.idFolder = idFolder;
            this.folderName = folderName;
            this.folderAncestor = folderAncestor;
            this.resources = resources;
        }

        public String getID() {
            return this.idFolder;
        }

        public String getAncestorID() {
            return this.folderAncestor;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.idFolder == null ? 0 : this.idFolder.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectFolder other = (ProjectFolder)obj;
            return !(this.idFolder == null ? other.idFolder != null : !this.idFolder.equals(other.idFolder));
        }

        public String toString() {
            return "ProjectFolder [idFolder=" + this.idFolder + ", folderName=" + this.folderName + ", folderAncestor=" + this.folderAncestor + ", resources=" + this.resources + "]";
        }

        public String getListableName() {
            return String.valueOf(this.folderName) + " (" + this.resources + ")";
        }

        @Override
        public int compareTo(ProjectFolder o) {
            return o == null ? 1 : this.folderName.compareTo(o.folderName);
        }

        public String getFolderName() {
            return this.folderName;
        }

        public String getResources() {
            return this.resources;
        }
    }
}

