/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.structure;

import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.structure.MainframeProjectStructureDescriptor;
import com.ez.analysis.mainframe.explore.structure.PSComparator;
import com.ez.analysis.mainframe.explore.structure.PSContentProvider;
import com.ez.analysis.mainframe.explore.structure.PSDirection;
import com.ez.analysis.mainframe.explore.structure.PSLabelProvider;
import com.ez.analysis.mainframe.explore.structure.ProjectStructureModel;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionManager;
import com.ez.analysisbrowser.actions.IResultViewer;
import com.ez.internal.utils.PathMapping;
import com.ez.mainframe.model.ProjectInfo;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeProjectStructureViewer
implements IResultViewer {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MainframeProjectStructureViewer.class);
    private MainframeProjectStructureDescriptor descriptor;
    private TreeViewer treeViewer;
    private ProjectInfo pinfo;
    private Label path;
    private String pjLocation;

    public MainframeProjectStructureViewer(MainframeProjectStructureDescriptor mainframeProjectStructureDescriptor) {
        this.descriptor = mainframeProjectStructureDescriptor;
    }

    public Composite create(Composite parent, IAction action, IActionManager manager) {
        manager.setCurrentContext(null);
        Map data = this.descriptor.getState().getData();
        ProjectStructureModel model = (ProjectStructureModel)data.get("projectStructureModel");
        this.pinfo = (ProjectInfo)data.get("projectinfo");
        String prjLocation = (String)this.pinfo.getInfo().get("projectLocation");
        String resPath = PathMapping.convertToMapped((String)prjLocation);
        this.pjLocation = resPath.substring(0, FilenameUtils.indexOfLastSeparator((String)resPath));
        this.pjLocation = PathMapping.convertToMapped((String)this.pjLocation);
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(3, false));
        this.path = new Label(panel, 0);
        this.path.setText(this.pjLocation == null ? "nolocation" : this.pjLocation);
        this.path.setLayoutData((Object)new GridData(4, 4, true, false));
        final Button sortAZ = new Button(panel, 2);
        sortAZ.setText(Messages.getString(MainframeProjectStructureViewer.class, "button.sortAZ.text"));
        sortAZ.setToolTipText(Messages.getString(MainframeProjectStructureViewer.class, "button.sortAZ.tooltip"));
        sortAZ.setLayoutData((Object)new GridData(3, 4, false, false));
        final Button sortRes = new Button(panel, 2);
        sortRes.setText("(#)");
        sortRes.setToolTipText(Messages.getString(MainframeProjectStructureViewer.class, "button.sortRes.tooltip"));
        sortRes.setLayoutData((Object)new GridData(3, 4, false, false));
        sortRes.setSelection(true);
        this.treeViewer = new TreeViewer(panel);
        sortAZ.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PSDirection primary = sortAZ.getSelection() ? PSDirection.AZ_DESC : PSDirection.AZ_ASC;
                PSDirection secondary = sortRes.getSelection() ? PSDirection.RES_DESC : PSDirection.RES_ASC;
                MainframeProjectStructureViewer.this.treeViewer.setComparator((ViewerComparator)new PSComparator(primary, secondary));
            }
        });
        sortRes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PSDirection primary = sortRes.getSelection() ? PSDirection.RES_DESC : PSDirection.RES_ASC;
                PSDirection secondary = sortAZ.getSelection() ? PSDirection.AZ_DESC : PSDirection.AZ_ASC;
                MainframeProjectStructureViewer.this.treeViewer.setComparator((ViewerComparator)new PSComparator(primary, secondary));
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new PSContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new PSLabelProvider());
        this.treeViewer.setComparator((ViewerComparator)new PSComparator(PSDirection.AZ_ASC, PSDirection.RES_DESC));
        this.treeViewer.setInput((Object)model);
        this.treeViewer.expandAll();
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 3;
        this.treeViewer.getTree().setLayoutData((Object)gd);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection s;
                ISelection selection = event.getSelection();
                if (selection != null && !selection.isEmpty() && selection instanceof TreeSelection && (s = (TreeSelection)selection).getPaths() != null && s.getPaths().length > 0) {
                    TreePath[] treePathArray = s.getPaths();
                    int n = treePathArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreePath tp = treePathArray[n2];
                        StringBuilder sb = new StringBuilder(MainframeProjectStructureViewer.this.pjLocation);
                        int i = 0;
                        while (i < tp.getSegmentCount()) {
                            sb.append(File.separator).append(((ProjectStructureModel.ProjectFolder)tp.getSegment(i)).getFolderName());
                            ++i;
                        }
                        String folderPath = sb.toString();
                        L.debug("will open externally: {}", (Object)folderPath);
                        Program.launch((String)folderPath);
                        ++n2;
                    }
                }
            }
        });
        return panel;
    }
}

