/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.structure;

import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.structure.MainframeProjectStructureDescriptor;
import com.ez.analysis.mainframe.explore.structure.ProjectStructureModel;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.util.ActionUtils;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.EZInputFilter;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeProjectStructureAction
implements IAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MainframeProjectStructureAction.class);
    public static final String PROJECTINFO = "projectinfo";
    public static final String PROJECT_STRUCTURE_MODEL = "projectStructureModel";
    private MainframeProjectStructureDescriptor descriptor;
    private EZAnalysisType analysisType;
    private EZInputFilter filter;
    private IActionContext context;
    private ProjectInfo pinfo;

    public MainframeProjectStructureAction(MainframeProjectStructureDescriptor mainframeProjectStructureDescriptor) {
        this.descriptor = mainframeProjectStructureDescriptor;
        this.analysisType = this.descriptor.getAnalysisType();
        this.filter = this.analysisType.getInputFilterInstance();
    }

    public boolean canHandle(IActionContext context) {
        return ActionUtils.canHandle((EZAnalysisType)this.analysisType, (EZInputFilter)this.filter, (IActionContext)context);
    }

    public void setInputContext(IActionContext context) {
        this.context = context;
        if (context != null) {
            Map data = context.getData();
            StructuredSelection sel = (StructuredSelection)data.get("selection");
            ProjectInfo pi = null;
            pi = sel != null ? (ProjectInfo)sel.getFirstElement() : (ProjectInfo)data.get("com.ez.analysis.base.explore.projects.PROJECT");
            if (pi != null && !pi.isEclipse()) {
                this.pinfo = pi;
                this.descriptor.nameHint(Messages.getString(MainframeProjectStructureAction.class, "descriptor.name", new String[]{pi.getName()}));
                this.descriptor.setImageDescriptor(pi.getDescriptor());
            }
        }
    }

    public IActionContext getOutputContext() {
        return this.context;
    }

    public void execute(IProgressMonitor pmonitor) {
        L.debug("getting project structure");
        Map data = this.descriptor.getState().getData();
        if (this.pinfo != null) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            monitor.setTaskName(Messages.getString(MainframeProjectStructureAction.class, "explore.project.structure"));
            monitor.subTask(Messages.getString(MainframeProjectStructureAction.class, "getConnection.monitor.task"));
            IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
            IMFProjectHandler ph = service.getProjectHandler(this.pinfo.getName(), null);
            monitor.worked(30);
            data.put(PROJECTINFO, this.pinfo);
            final String[][][] ret = new String[1][][];
            try {
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
                        monitor.subTask(Messages.getString(MainframeProjectStructureAction.class, "loading.data"));
                        L.debug("getting project structure for " + MainframeProjectStructureAction.this.pinfo.getName());
                        String[][] rez = conn.executeSQL("select pj_folder.Id_Folder, pj_folder.Name, pj_folder.ID_Ancestor, count(pj_file.id_file) as files  from Pj_Folder left join pj_file on pj_file.ID_Folder = pj_folder.id_folder\n\tgroup by pj_folder.id_folder, pj_folder.Name, pj_folder.ID_Ancestor\n   order by pj_folder.id_folder");
                        if (!monitor.isCanceled()) {
                            ret[0] = rez;
                        }
                    }
                }, LockType.Shared, (IProgressMonitor)monitor.newChild(50));
            }
            catch (Exception e) {
                L.error("could not retrieve data", (Throwable)e);
            }
            if (!monitor.isCanceled() && ret[0] != null) {
                monitor.subTask(Messages.getString(MainframeProjectStructureAction.class, "creating.model"));
                ProjectStructureModel model = ProjectStructureModel.build(this.pinfo, ret[0], (IProgressMonitor)monitor.newChild(40));
                data.put(PROJECT_STRUCTURE_MODEL, model);
            }
        }
        if (this.context != null) {
            data.putAll(this.context.getData());
        }
    }
}

