/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.project;

import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.project.MainframeProjectExploreDescriptor;
import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.util.ActionUtils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.EZInputFilter;
import com.ez.workspace.analysis.audit.IAudit;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeProjectExploreAction
implements IAction,
IAudit {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MainframeProjectExploreAction.class);
    public static final String AVAILABLETYPES = "availabletypes";
    public static final String PROJECTINFO = "projectinfo";
    private ProjectInfo pinfo = null;
    private MainframeProjectExploreDescriptor descriptor;
    private EZAnalysisType analysisType;
    private EZInputFilter filter;
    private IActionContext context;

    public MainframeProjectExploreAction(MainframeProjectExploreDescriptor descriptor) {
        this.descriptor = descriptor;
        this.analysisType = descriptor.getAnalysisType();
        this.filter = this.analysisType.getInputFilterInstance();
    }

    public boolean canHandle(IActionContext context) {
        return ActionUtils.canHandle((EZAnalysisType)this.analysisType, (EZInputFilter)this.filter, (IActionContext)context);
    }

    public void setInputContext(IActionContext context) {
        this.context = context;
        if (context != null) {
            Map data = context.getData();
            StructuredSelection sel = (StructuredSelection)data.get("selection");
            ProjectInfo pi = null;
            if (sel != null) {
                pi = (ProjectInfo)sel.getFirstElement();
            } else {
                List inputs;
                pi = (ProjectInfo)data.get("com.ez.analysis.base.explore.projects.PROJECT");
                if (pi == null && (inputs = (List)data.get("ANALYSIS_TYPE_INPUTS")) != null && inputs.size() > 0) {
                    EZSourceProjectIDSg sg = (EZSourceProjectIDSg)((EZObjectType)inputs.get(0)).getEntID().getSegment(EZSourceProjectIDSg.class);
                    pi = sg.getProjectInfo();
                }
            }
            if (pi != null && !pi.isEclipse()) {
                this.pinfo = pi;
                this.descriptor.nameHint(Messages.getString(MainframeProjectExploreAction.class, "descriptor.name", new String[]{pi.getName()}));
                this.descriptor.setImageDescriptor(pi.getDescriptor());
                this.context = new AbstractActionContext(){

                    public Map<String, Object> getData() {
                        IProjectsService service = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
                        List projects = service.getProjects();
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("com.ez.analysis.base.explore.projects.PROJECT", MainframeProjectExploreAction.this.pinfo);
                        data.put("projects", projects);
                        return data;
                    }

                    public String getId() {
                        return "com.ez.analysis.mainframe.explore.projects";
                    }
                };
            }
        }
    }

    public IActionContext getOutputContext() {
        return this.context;
    }

    public void execute(IProgressMonitor pmonitor) {
        L.debug("exploring project");
        Map data = this.descriptor.getState().getData();
        if (this.pinfo != null) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            monitor.setTaskName(Messages.getString(MainframeProjectExploreAction.class, "getConnection.monitor.task"));
            monitor.worked(30);
            data.put(PROJECTINFO, this.pinfo);
            monitor.worked(70);
        }
        if (this.context != null) {
            data.putAll(this.context.getData());
            this.auditAnalysis();
        }
    }

    public String getProjectNames4Audit() {
        ProjectInfo projectInfo = (ProjectInfo)this.descriptor.getState().getData().get(PROJECTINFO);
        return projectInfo.getName();
    }

    public Integer getOperationCode() {
        return this.analysisType.getImplementorInstance().getOperationType().getOperationCode();
    }

    public String getOperationName() {
        return this.analysisType.getImplementorInstance().getOperationType().toString();
    }
}

