/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.project;

import com.ez.analysis.mainframe.explore.Activator;
import com.ez.analysis.mainframe.explore.data.IContextReporter;
import com.ez.analysis.mainframe.explore.data.IPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.AbstractPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.Refresher;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.project.CombinationImagePainter;
import com.ez.analysis.mainframe.explore.project.DataSourceModel;
import com.ez.analysis.mainframe.explore.project.MainframeProjectExploreDescriptor;
import com.ez.analysis.mainframe.explore.project.PaginatedHandlerProxy;
import com.ez.analysis.mainframe.explore.project.SelectionLayerConfiguration;
import com.ez.analysis.mainframe.explore.project.TypeEntry;
import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IActionManager;
import com.ez.analysisbrowser.actions.IResultViewer;
import com.ez.analysisbrowser.views.BrowserManager;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.state.AEvent;
import com.ez.workspace.state.EZAnnotationEvent;
import com.ez.workspace.state.EventType;
import com.ez.workspace.state.IEZStateListener;
import com.ez.workspace.state.StateManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.grid.layer.config.DefaultRowStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.action.PageDownAction;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowsCommand;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultSelectionStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.ui.action.IKeyAction;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IKeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.KeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeExploreProjectViewer
implements IResultViewer,
IContextReporter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MainframeExploreProjectViewer.class);
    private static final String SORT_IMAGE_KEY = "sortImage";
    private static final String NO_PATH_IMAGE_KEY = "noPathImage";
    private static final String SELECTED_CONTEXT_KEY = "selectedContext";
    private static final String ANNOTATION_IMAGE_KEY = "annImage";
    private static final String RELATED_DEAD_CODE_IMAGE_KEY = "relDeadCodeImage";
    private MainframeProjectExploreDescriptor descriptor;
    private Combo resTypeCombo;
    private Text filterText;
    private DataSourceModel datasourceModel;
    private PaginatedHandlerProxy proxy;
    private NatTable table;
    private Text statusLabelAsText;
    private IActionManager manager;
    private Button sort;
    private Button annot;
    private Button dc;
    Map<String, Object> emptyData = new HashMap<String, Object>(){
        {
            this.put("selection", new StructuredSelection());
        }
    };
    private Composite customArea;
    private Composite panel;

    public MainframeExploreProjectViewer(MainframeProjectExploreDescriptor descriptor) {
        this.descriptor = descriptor;
        if (Activator.getDefault().getImageRegistry().get(SORT_IMAGE_KEY) == null) {
            Activator.getDefault().getImageRegistry().put(SORT_IMAGE_KEY, Activator.getImageDescriptor("icons/updown.png"));
        }
        if (Activator.getDefault().getImageRegistry().get(ANNOTATION_IMAGE_KEY) == null) {
            Activator.getDefault().getImageRegistry().put(ANNOTATION_IMAGE_KEY, Activator.getImageDescriptor("icons/annotation.png"));
        }
        if (Activator.getDefault().getImageRegistry().get(NO_PATH_IMAGE_KEY) == null) {
            Activator.getDefault().getImageRegistry().put(NO_PATH_IMAGE_KEY, Activator.getImageDescriptor("icons/no_path.png"));
        }
        if (Activator.getDefault().getImageRegistry().get(RELATED_DEAD_CODE_IMAGE_KEY) == null) {
            Activator.getDefault().getImageRegistry().put(RELATED_DEAD_CODE_IMAGE_KEY, Activator.getImageDescriptor("icons/quickfix_warning_obj.png"));
        }
    }

    public Composite create(Composite parent, IAction action, IActionManager manager) {
        this.manager = manager;
        if (this.datasourceModel == null) {
            this.datasourceModel = new DataSourceModel(this.descriptor);
        }
        this.panel = new Composite(parent, 0);
        this.panel.setLayout((Layout)new GridLayout());
        Composite header = this.setupHeader(this.panel);
        header.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fillHeader();
        if (this.datasourceModel.hasTypes()) {
            AbstractPaginatedHandler dp = (AbstractPaginatedHandler)this.resTypeCombo.getData(String.valueOf(this.resTypeCombo.getSelectionIndex()));
            this.proxy = new PaginatedHandlerProxy();
            this.setNewHandler(dp);
            this.table = this.createTable(this.panel, this.proxy);
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
            gd.horizontalAlignment = 4;
            this.table.setLayoutData((Object)gd);
            this.table.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainframeExploreProjectViewer.this.datasourceModel.close();
                }
            });
            this.resTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MainframeExploreProjectViewer.this.updateResourceType(false);
                }
            });
            Listener mouseVerticalWheelListener = new Listener(){

                public void handleEvent(Event arg0) {
                    arg0.doit = false;
                }
            };
            this.resTypeCombo.addListener(37, mouseVerticalWheelListener);
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MainframeExploreProjectViewer.this.updateFilter(!MainframeExploreProjectViewer.this.sort.getSelection());
                }
            });
            this.sort.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MainframeExploreProjectViewer.this.updateFilter(!MainframeExploreProjectViewer.this.sort.getSelection());
                }
            });
            this.annot.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MainframeExploreProjectViewer.this.updateFilter(!MainframeExploreProjectViewer.this.sort.getSelection());
                }
            });
            this.dc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MainframeExploreProjectViewer.this.updateFilter(!MainframeExploreProjectViewer.this.sort.getSelection());
                }
            });
            dp.createCustomArea(this.customArea);
            this.panel.layout(true);
            this.updateResourceType(true);
        }
        final AnnotationEventHandler annStateListener = new AnnotationEventHandler();
        final EventType evType = EventType.EZANNOTATION_EVENT_TYPE;
        StateManager.getInstance().register((IEZStateListener)annStateListener, evType);
        this.panel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StateManager.getInstance().unregister((IEZStateListener)annStateListener, evType);
            }
        });
        return this.panel;
    }

    private void refreshAnnotation(Map<String, Map<Integer, Boolean>> eventData) {
        Map<Integer, Boolean> data;
        boolean doRefresh = false;
        Integer dbIdCol = (Integer)this.proxy.getInfo("dbIdColumn");
        Integer column = (Integer)this.proxy.getInfo("annotationColumn");
        String resType = (String)this.proxy.getInfo("resType");
        if (column != null && (data = eventData.get(resType)) != null) {
            boolean acceptAnn = (Boolean)this.proxy.getInfo("acceptAnnotations");
            if (acceptAnn) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MainframeExploreProjectViewer.this.updateFilter(!MainframeExploreProjectViewer.this.sort.getSelection(), true);
                    }
                });
            } else {
                Map buf = (Map)this.proxy.getBuffer();
                for (Integer line : buf.keySet()) {
                    String[] row = (String[])buf.get(line);
                    Integer id = Integer.parseInt(row[dbIdCol]);
                    Boolean adnotated = data.get(id);
                    if (adnotated == null) continue;
                    row[column.intValue()] = adnotated.toString();
                    doRefresh = true;
                }
            }
        }
        if (doRefresh) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!MainframeExploreProjectViewer.this.table.isDisposed()) {
                        MainframeExploreProjectViewer.this.table.refresh();
                    }
                }
            });
        }
    }

    private void setNewHandler(AbstractPaginatedHandler dp) {
        this.proxy.setTarget(dp);
        this.proxy.setContextReporter(this);
        this.manager.setCurrentContext(null);
    }

    private Composite setupHeader(Composite panel) {
        Composite header = new Composite(panel, 2048);
        header.setLayout((Layout)new GridLayout(1, false));
        Composite filteringArea = new Composite(header, 0);
        filteringArea.setLayout((Layout)new GridLayout(7, false));
        filteringArea.setLayoutData((Object)new GridData(4, 0, true, false));
        Label resTypeLabel = new Label(filteringArea, 0x1000000);
        resTypeLabel.setText(Messages.getString(MainframeExploreProjectViewer.class, "resource.type"));
        this.resTypeCombo = new Combo(filteringArea, 12);
        this.resTypeCombo.setToolTipText(Messages.getString(MainframeExploreProjectViewer.class, "selectResource.combo.tooltip"));
        Label nameFilterLabel = new Label(filteringArea, 0x1000000);
        nameFilterLabel.setText(Messages.getString(MainframeExploreProjectViewer.class, "name.filter"));
        this.filterText = new Text(filteringArea, 2052);
        this.filterText.setToolTipText(Messages.getString(MainframeExploreProjectViewer.class, "filter.textbox.default.tooltip"));
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(MainframeExploreProjectViewer.class, "filter.textbox.default.tooltip");
            }
        });
        this.sort = new Button(filteringArea, 2);
        this.sort.setImage(Activator.getDefault().getImageRegistry().get(SORT_IMAGE_KEY));
        this.sort.setToolTipText(Messages.getString(MainframeExploreProjectViewer.class, "sort.button.tooltip"));
        this.sort.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(MainframeExploreProjectViewer.class, "sort.button.tooltip");
            }
        });
        this.annot = new Button(filteringArea, 2);
        this.annot.setImage(Activator.getDefault().getImageRegistry().get(ANNOTATION_IMAGE_KEY));
        this.annot.setToolTipText(Messages.getString(MainframeExploreProjectViewer.class, "annotations.button.tooltip"));
        this.annot.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(MainframeExploreProjectViewer.class, "annotations.button.tooltip");
            }
        });
        this.dc = new Button(filteringArea, 2);
        this.dc.setImage(Activator.getDefault().getImageRegistry().get(RELATED_DEAD_CODE_IMAGE_KEY));
        this.dc.setToolTipText(Messages.getString(MainframeExploreProjectViewer.class, "dc.button.tooltip"));
        this.dc.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(MainframeExploreProjectViewer.class, "dc.button.tooltip");
            }
        });
        this.customArea = new Composite(header, 0);
        this.customArea.setLayout((Layout)new RowLayout());
        this.statusLabelAsText = new Text(header, 8);
        GridData gridDataToFillHorizontal = new GridData(4, 0x1000000, true, false);
        this.resTypeCombo.setLayoutData((Object)gridDataToFillHorizontal);
        this.filterText.setLayoutData((Object)gridDataToFillHorizontal);
        this.statusLabelAsText.setLayoutData((Object)gridDataToFillHorizontal);
        return header;
    }

    private String getFilterTooltipText() {
        AbstractPaginatedHandler dp = (AbstractPaginatedHandler)this.resTypeCombo.getData(String.valueOf(this.resTypeCombo.getSelectionIndex()));
        String tooltipText = dp.getFilterTooltipText();
        return tooltipText;
    }

    public void fillHeader() {
        List<TypeEntry> types = this.datasourceModel.getTypes();
        if (types.size() == 0) {
            this.resTypeCombo.setEnabled(false);
            this.resTypeCombo.add(Messages.getString(MainframeExploreProjectViewer.class, "nodata"));
        }
        int i = 0;
        int def = -1;
        String index = (String)this.descriptor.getState().getData().get("resourceType");
        if (index != null) {
            def = Integer.parseInt(index);
        }
        for (TypeEntry te : types) {
            this.resTypeCombo.add(te.listableName());
            AbstractPaginatedHandler handler = this.datasourceModel.getProvider((Integer)te.getId());
            this.resTypeCombo.setData(String.valueOf(i), (Object)handler);
            if (te.isDefault() && def == -1) {
                def = i;
            }
            ++i;
        }
        if (def == -1 && i > 0) {
            def = 1;
        }
        this.resTypeCombo.select(def);
    }

    private void updateResourceType(boolean useContextFilter) {
        Object filter;
        this.descriptor.getState().getData().put("resourceType", String.valueOf(this.resTypeCombo.getSelectionIndex()));
        AbstractPaginatedHandler dp = (AbstractPaginatedHandler)this.resTypeCombo.getData(String.valueOf(this.resTypeCombo.getSelectionIndex()));
        AbstractPaginatedHandler old_dp = this.proxy.getTarget();
        this.annot.setEnabled(dp.acceptAnnotations());
        boolean prefDC = PreferenceUtils.getPreferenceStore().getBoolean("displayDeadCode");
        this.dc.setEnabled(prefDC && dp.acceptDeadCode());
        if (!dp.equals(old_dp)) {
            if (old_dp.isStarted()) {
                old_dp.pause();
            }
            this.setNewHandler(dp);
            filter = dp.getFilter();
            if (filter == null) {
                this.filterText.setText("");
            } else {
                this.filterText.setText(filter.getUIText());
            }
            Control[] controlArray = this.customArea.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
            dp.createCustomArea(this.customArea);
        }
        if (useContextFilter && (filter = (String)this.descriptor.getState().getData().get("filterText")) != null) {
            this.filterText.setText((String)filter);
        }
        this.filterText.setToolTipText(this.getFilterTooltipText());
        this.panel.layout(true);
        this.startOrResume(dp);
    }

    private void updateFilter(boolean ascending, boolean forceFilter) {
        this.statusLabelAsText.setText(Messages.getString(MainframeExploreProjectViewer.class, "updatingFilter.status.text"));
        AbstractPaginatedHandler dp = (AbstractPaginatedHandler)this.resTypeCombo.getData(String.valueOf(this.resTypeCombo.getSelectionIndex()));
        this.reportContextData(this.emptyData);
        boolean considerAnn = this.annot.isEnabled() ? this.annot.getSelection() : false;
        boolean onlyDC = this.dc.isEnabled() ? this.dc.getSelection() : false;
        ISQLFilter filter = dp.newFilter(ascending, considerAnn, onlyDC);
        filter.setUIText(this.filterText.getText());
        dp.setFilter(filter, forceFilter);
        this.descriptor.getState().getData().put("filterText", this.filterText.getText());
        this.manager.setCurrentContext(null);
    }

    private void updateFilter(boolean ascending) {
        this.updateFilter(ascending, false);
    }

    private void startOrResume(final AbstractPaginatedHandler dp) {
        this.reportContextData(this.emptyData);
        if (!dp.isStarted()) {
            dp.start(new Refresher(){

                @Override
                public void run(final Exception error) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!MainframeExploreProjectViewer.this.table.isDisposed()) {
                                MainframeExploreProjectViewer.this.table.refresh();
                                if (error != null) {
                                    MainframeExploreProjectViewer.this.statusLabelAsText.setText(Messages.getString(MainframeExploreProjectViewer.class, "problem.aquiring.data", new String[]{error.getMessage()}));
                                } else if (dp.hasData()) {
                                    MainframeExploreProjectViewer.this.statusLabelAsText.setText(Messages.getString(MainframeExploreProjectViewer.class, "noOfItems.status.text", new String[]{String.valueOf(dp.getRowCount())}));
                                } else {
                                    MainframeExploreProjectViewer.this.statusLabelAsText.setText("");
                                    MainframeExploreProjectViewer.this.manager.setCurrentContext(null);
                                    MainframeExploreProjectViewer.this.descriptor.getState().getData().put(MainframeExploreProjectViewer.SELECTED_CONTEXT_KEY, null);
                                }
                            }
                        }
                    });
                }
            });
            this.statusLabelAsText.setText(Messages.getString(MainframeExploreProjectViewer.class, "collectionData.status.text"));
        } else if (dp.isPaused()) {
            dp.resume();
            this.table.refresh();
            if (dp.hasData()) {
                this.statusLabelAsText.setText(Messages.getString(MainframeExploreProjectViewer.class, "noOfItems.status.text", new String[]{String.valueOf(dp.getRowCount())}));
            } else {
                this.statusLabelAsText.setText("");
                this.manager.setCurrentContext(null);
                this.descriptor.getState().getData().put(SELECTED_CONTEXT_KEY, null);
            }
        }
    }

    private void addCustomStyling(NatTable natTable) {
        AnnotatedStyleConfiguration natTableConfiguration = new AnnotatedStyleConfiguration();
        natTableConfiguration.hAlign = HorizontalAlignmentEnum.LEFT;
        natTableConfiguration.vAlign = VerticalAlignmentEnum.MIDDLE;
        DefaultRowStyleConfiguration rowStyleConfiguration = new DefaultRowStyleConfiguration();
        rowStyleConfiguration.oddRowBgColor = GUIHelper.getColor((int)200, (int)200, (int)200);
        rowStyleConfiguration.evenRowBgColor = GUIHelper.COLOR_WHITE;
        DefaultSelectionStyleConfiguration selectionStyle = new DefaultSelectionStyleConfiguration();
        FontData[] fontData = natTable.getParent().getFont().getFontData();
        selectionStyle.selectionFont = GUIHelper.getFont((FontData[])fontData);
        selectionStyle.selectionBgColor = GUIHelper.COLOR_LIST_SELECTION;
        selectionStyle.selectionFgColor = GUIHelper.COLOR_WHITE;
        selectionStyle.anchorBorderStyle = new BorderStyle(1, GUIHelper.COLOR_DARK_GRAY, BorderStyle.LineStyleEnum.SOLID);
        selectionStyle.anchorBgColor = GUIHelper.COLOR_LIST_SELECTION;
        natTable.addConfiguration((IConfiguration)natTableConfiguration);
        natTable.addConfiguration((IConfiguration)rowStyleConfiguration);
        natTable.addConfiguration((IConfiguration)selectionStyle);
    }

    private NatTable createTable(Composite parent, final IPaginatedHandler<String[]> dp) {
        DataLayer dl = new DataLayer(dp);
        dl.setColumnPercentageSizing(true);
        dl.setColumnWidthPercentageByPosition(0, 100);
        dl.clearConfiguration();
        dl.setConfigLabelAccumulator((IConfigLabelAccumulator)new AnnotatedLabelAccumulator(dp));
        SelectionLayer sl = new SelectionLayer((IUniqueIndexLayer)dl, false);
        sl.addConfiguration((IConfiguration)new SelectionLayerConfiguration(dp));
        CopyDataCommandHandler copyHandler = new CopyDataCommandHandler(sl);
        copyHandler.setCopyFormattedText(true);
        ViewportLayer vl = new ViewportLayer((IUniqueIndexLayer)sl);
        vl.setRegionName("BODY");
        vl.registerCommandHandler((ILayerCommandHandler)copyHandler);
        final NatTable table = new NatTable(parent, (ILayer)vl, false);
        final RowSelectionProvider selectionProvider = new RowSelectionProvider(sl, dp, false);
        selectionProvider.setProcessColumnSelection(false);
        selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (table.isVisible()) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    dp.handleSelection(selection);
                    int selSize = 0;
                    if (selection == null || selection.isEmpty()) {
                        MainframeExploreProjectViewer.this.reportContextData(MainframeExploreProjectViewer.this.emptyData);
                    } else {
                        selSize = selection.size();
                    }
                    if (selSize == 0) {
                        MainframeExploreProjectViewer.this.statusLabelAsText.setText(Messages.getString(MainframeExploreProjectViewer.class, "noOfItems.status.text", new String[]{"" + dp.getRowCount()}));
                    } else {
                        MainframeExploreProjectViewer.this.statusLabelAsText.setText(Messages.getString(MainframeExploreProjectViewer.class, "noOfSelectedItems.status.text", new String[]{"" + selSize, "" + dp.getRowCount()}));
                    }
                }
            }
        });
        this.addCustomStyling(table);
        table.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                MainframeExploreProjectViewer.this.doSelect((RowSelectionProvider<String[]>)selectionProvider);
            }
        });
        table.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (selectionProvider.getSelection().isEmpty() && table.isFocusControl()) {
                    table.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)table, 0, 0, false, false));
                }
            }
        });
        table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 8: 
                    case 16: {
                        e.doit = true;
                    }
                }
            }
        });
        this.doSelect((RowSelectionProvider<String[]>)selectionProvider);
        table.getUiBindingRegistry().registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(32), (IKeyAction)new PageDownAction());
        table.configure();
        return table;
    }

    private void doSelect(RowSelectionProvider<String[]> selectionProvider) {
        IStructuredSelection selection;
        IActionContext selectedContext = (IActionContext)this.descriptor.getState().getData().get(SELECTED_CONTEXT_KEY);
        if (selectedContext != null && (selection = (IStructuredSelection)selectedContext.getData().get("tableSelection")) != null) {
            selectionProvider.setProcessColumnSelection(false);
            selectionProvider.setSelection((ISelection)selection);
        }
    }

    @Override
    public void reportContextData(final Map<String, Object> contextData) {
        contextData.put("projects", this.descriptor.getState().getData().get("projects"));
        AbstractActionContext context = new AbstractActionContext(){

            public Map<String, Object> getData() {
                return contextData;
            }

            public String getId() {
                return MainframeExploreProjectViewer.this.descriptor.getId();
            }
        };
        this.descriptor.getState().getData().put(SELECTED_CONTEXT_KEY, context);
        this.descriptor.getState().getData().put("tableSelection", contextData.get("tableSelection"));
        contextData.put("sourceView", new Pair((Object)"com.ez.analysisbrowser.views.AnalysisBrowserView", (Object)((BrowserManager)this.manager).getViewSecondaryId()));
        this.manager.setCurrentContext((IActionContext)context);
    }

    public class AnnotatedLabelAccumulator
    implements IConfigLabelAccumulator {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        private IPaginatedHandler<String[]> dp;

        public AnnotatedLabelAccumulator(IPaginatedHandler<String[]> dp) {
            this.dp = dp;
        }

        public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
            if (columnPosition != 0) {
                return;
            }
            String[] rowObject = (String[])this.dp.getRowObject(rowPosition);
            if (rowObject != null) {
                Integer pathColumn;
                Integer annCol;
                Integer dcColumn = (Integer)this.dp.getInfo("dcColumn");
                if (dcColumn != null && rowObject.length > dcColumn && rowObject[dcColumn] != null && "-1".equals(rowObject[dcColumn])) {
                    configLabels.addLabel("relDeadCode");
                }
                if ((annCol = (Integer)this.dp.getInfo("annotationColumn")) != null && rowObject.length > annCol && Boolean.parseBoolean(rowObject[annCol])) {
                    configLabels.addLabel("annotated");
                }
                if ((pathColumn = (Integer)this.dp.getInfo("pathColumn")) != null && rowObject.length > pathColumn && (rowObject[pathColumn] == null || rowObject[pathColumn].isEmpty())) {
                    configLabels.addLabel("noPath");
                }
            }
        }
    }

    public class AnnotatedStyleConfiguration
    extends DefaultNatTableStyleConfiguration {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        CombinationImagePainter painter = new CombinationImagePainter(2, true);

        public AnnotatedStyleConfiguration() {
            this.painter.add("relDeadCode", Activator.getDefault().getImageRegistry().get(MainframeExploreProjectViewer.RELATED_DEAD_CODE_IMAGE_KEY));
            this.painter.add("annotated", Activator.getDefault().getImageRegistry().get(MainframeExploreProjectViewer.ANNOTATION_IMAGE_KEY));
            this.painter.add("noPath", Activator.getDefault().getImageRegistry().get(MainframeExploreProjectViewer.NO_PATH_IMAGE_KEY));
            this.cellPainter = new PaddingDecorator((ICellPainter)new CellPainterDecorator((ICellPainter)new TextPainter(), CellEdgeEnum.RIGHT, (ICellPainter)this.painter), 1);
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            super.configureRegistry(configRegistry);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.painter, "NORMAL", "COMBINATION_IMAGE_CELL_PAINTER");
        }
    }

    class AnnotationEventHandler
    implements IEZStateListener {
        AnnotationEventHandler() {
        }

        public void notify(AEvent event) {
            HashMap<String, HashMap<Integer, Boolean>> eventData = new HashMap<String, HashMap<Integer, Boolean>>();
            String project = MainframeExploreProjectViewer.this.proxy.getTarget().getProjectName();
            String cfr_ignored_0 = (String)MainframeExploreProjectViewer.this.proxy.getInfo("resType");
            Map stateMap = ((EZAnnotationEvent)event).getStateMap();
            for (EZEntityID key : stateMap.keySet()) {
                EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)key.getSegment(EZSourceProjectIDSg.class);
                EZSourceProgramIDSg prg = (EZSourceProgramIDSg)key.getSegment(EZSourceProgramIDSg.class);
                EZSourceJobIDSg job = (EZSourceJobIDSg)key.getSegment(EZSourceJobIDSg.class);
                String prjName = prjSg.getProjectName();
                if (!prjName.equals(project)) continue;
                String resType = null;
                Integer id = null;
                if (prg != null) {
                    resType = "5";
                    id = prg.getProgramId();
                }
                if (job != null) {
                    resType = "22";
                    id = job.getJobId();
                }
                Boolean annotated = (Boolean)stateMap.get(key);
                HashMap<Integer, Boolean> resInfo = (HashMap<Integer, Boolean>)eventData.get(resType);
                if (resInfo == null) {
                    resInfo = new HashMap<Integer, Boolean>();
                    eventData.put(resType, resInfo);
                }
                resInfo.put(id, annotated);
            }
            MainframeExploreProjectViewer.this.refreshAnnotation(eventData);
        }
    }
}

