/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.project;

import com.ez.analysis.mainframe.explore.data.impl.AbstractPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.NoDataHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.AAUTOJobsPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.AAUTONetworksPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.AdabasFilePaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.AdsMapPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.AssemblerIncludePaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.CA7JobPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.CICSMapPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.CICSTransactionPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.CobolIncludePaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.CtrlMJobPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.DALPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.DDCLElementsPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.DatacomPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.DatasetPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.IDMSRecordPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.IDMSSetPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.IDMSXRecordPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.IDMSXSetPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.IMSDBPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.IMSMapPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.IMSTMTransactionPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.JCLPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.MQPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.NaturalDAPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.NaturalIncludePaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.NaturalMapPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.Pl1IncludePaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.ProgramPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.SCLProgramPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.SQLTablePaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.SmartScreenPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.TPMSXScreenPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.handlers.TWSApplicationsPaginatedHandler;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.project.MainframeProjectExploreDescriptor;
import com.ez.analysis.mainframe.explore.project.TypeEntry;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.mainframe.model.ProjectInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DataSourceModel.class);
    private MainframeProjectExploreDescriptor descriptor;
    public static final int NO_DATA = 0;
    public static final int COBOL_PROGRAM = 1;
    public static final int PL1_PROGRAM = 2;
    public static final int NATURAL_PROGRAM = 3;
    public static final int SCL_PROGRAM = 4;
    public static final int JCL_JOB = 5;
    public static final int DATASET = 6;
    public static final int VARIABLE = 7;
    public static final int IDMSSET = 8;
    public static final int IDMSRECORD = 9;
    public static final int SQLTABLE = 10;
    public static final int CICSTRANSACTION = 11;
    public static final int CICSMAP = 12;
    public static final int ASSEMBLER_PROGRAM = 13;
    public static final int FORTRAN_PROGRAM = 14;
    public static final int ALGOL_PROGRAM = 15;
    public static final int TWS_APPLICATIONS = 16;
    public static final int DDCLElement = 17;
    public static final int MQQUEUE = 19;
    public static final int DATACOM = 20;
    public static final int ADABAS = 21;
    public static final int IMSDB = 22;
    public static final int ADSMAP = 23;
    public static final int NATURAL_MAP = 24;
    public static final int TPMSX = 25;
    public static final int SMART_SCREEN = 26;
    public static final int CA7JOB = 27;
    public static final int IDMSXSET = 28;
    public static final int IDMSXRECORD = 29;
    public static final int ADS_PROCESS = 30;
    public static final int ADS_DIALOG = 31;
    public static final int IMS_MAP = 32;
    public static final int DAL = 33;
    public static final int AAUTO_NETWORK = 34;
    public static final int AAUTO_JOB = 35;
    public static final int DBI = 36;
    public static final int NATURAL_DA = 37;
    public static final int NATURAL_INCLUDE = 38;
    public static final int COBOL_INCLUDE = 39;
    public static final int PL1_INCLUDE = 40;
    public static final int ASSEMBLER_INCLUDE = 41;
    public static final int IMSTRANSACTION = 42;
    public static final int CTRL_M = 224;
    private Map<Integer, AbstractPaginatedHandler> handlers = new HashMap<Integer, AbstractPaginatedHandler>();
    private List<TypeEntry> entries = new ArrayList<TypeEntry>();

    public DataSourceModel(MainframeProjectExploreDescriptor descriptor) {
        this.descriptor = descriptor;
        Map data = descriptor.getState().getData();
        ProjectInfo pi = (ProjectInfo)data.get("projectinfo");
        List inputs = (List)data.get("ANALYSIS_TYPE_INPUTS");
        if (pi == null && inputs != null) {
            for (Object inpObj : inputs) {
                if (!(inpObj instanceof EZSourceProjectInputType)) continue;
                pi = (ProjectInfo)((EZSourceProjectInputType)inpObj).getProperty("PROJECT_INFO");
                break;
            }
        }
        if (pi == null) {
            L.error("insufficient information to create project model. Please report this!");
        } else {
            this.registerHandlers(pi);
        }
    }

    private void registerHandlers(ProjectInfo pi) {
        this.registerHandler(pi, "", 0, new NoDataHandler());
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.assemblerProgram.type"), 13, new ProgramPaginatedHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.program.assembler"), 15, 16));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.cobolProgram.type"), 1, new ProgramPaginatedHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.program.cobol"), 1));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.pl1Program.type"), 2, new ProgramPaginatedHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.program.pl1"), 2));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.naturalProgram.type"), 3, new ProgramPaginatedHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.program.natural"), 3));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.fortranProgram.type"), 14, new ProgramPaginatedHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.program.fortran"), 17));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.algolProgram.type"), 15, new ProgramPaginatedHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.program.algol"), 18));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.adsProcess.type"), 30, new ProgramPaginatedHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.program.adsProcess"), 10));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.adsDialog.type"), 31, new ProgramPaginatedHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.program.adsDialog"), 11));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.sclProgram.type"), 4, new SCLProgramPaginatedHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.program.scl")));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.jclJob.type"), 5, new JCLPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.dataset.type"), 6, new DatasetPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.idmsSet.type"), 8, new IDMSSetPaginatedHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.idms")));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.idmsRecord.type"), 9, new IDMSRecordPaginatedHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.idms")));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.sqlTable.type"), 10, new SQLTablePaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.cicsTransaction.type"), 11, new CICSTransactionPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.cicsMap.type"), 12, new CICSMapPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.twsApplication.type"), 16, new TWSApplicationsPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.ddclElement.type"), 17, new DDCLElementsPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.mqQueue.type"), 19, new MQPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.datacom.type"), 20, new DatacomPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.adabasFile.type"), 21, new AdabasFilePaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.imsDB.type"), 22, new IMSDBPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.adsMap.type"), 23, new AdsMapPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.naturalMap.type"), 24, new NaturalMapPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.tpmsx.type"), 25, new TPMSXScreenPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.smartScreen.type"), 26, new SmartScreenPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.ca7Job.type"), 27, new CA7JobPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.idmsxSet.type"), 28, new IDMSXSetPaginatedHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.idmsx")));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.idmsxRecord.type"), 29, new IDMSXRecordPaginatedHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.idmsx")));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.IMSMap.type"), 32, new IMSMapPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.DAL.type"), 33, new DALPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.AAUTONetwork.type"), 34, new AAUTONetworksPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.AAUTOJob.type"), 35, new AAUTOJobsPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.IMSTM.type"), 42, new IMSTMTransactionPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.naturalDA.type"), 37, new NaturalDAPaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.naturalInclude.type"), 38, new NaturalIncludePaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.cobolInclude.type"), 39, new CobolIncludePaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.pl1Include.type"), 40, new Pl1IncludePaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.assembler1Include.type"), 41, new AssemblerIncludePaginatedHandler(pi));
        this.registerHandler(pi, Messages.getString(DataSourceModel.class, "exploreResource.CTRLM.type"), 224, new CtrlMJobPaginatedHandler(pi));
    }

    private void registerHandler(ProjectInfo pi, String description, int type, AbstractPaginatedHandler handler) {
        boolean[] pdi = this.getProjectDependentInfo(pi, type);
        if (pdi[0]) {
            this.handlers.put(type, handler);
            TypeEntry entry = new TypeEntry(description, type);
            entry.setDefault(pdi[1]);
            this.entries.add(entry);
        }
    }

    private boolean[] getProjectDependentInfo(ProjectInfo pi, int type) {
        boolean[] accept = new boolean[2];
        List ls = (List)pi.getInfo().get("languages");
        HashSet languages = new HashSet(ls);
        String environment = (String)pi.getInfo().get("environment");
        HashSet dbTypes = new HashSet((List)pi.getInfo().get("dbTypes"));
        HashSet screenTypes = new HashSet((List)pi.getInfo().get("mapTypes"));
        switch (type) {
            case 27: {
                if (!environment.equals("MVS")) break;
                accept[0] = true;
                break;
            }
            case 26: {
                if (!environment.equals("SMART AS/400")) break;
                accept[0] = true;
                break;
            }
            case 25: {
                if (!pi.isVME()) break;
                accept[0] = true;
                break;
            }
            case 24: {
                if (!screenTypes.contains("NATURAL(LNM)")) break;
                accept[0] = true;
                break;
            }
            case 21: {
                if (!dbTypes.contains("ADABAS")) break;
                accept[0] = true;
                break;
            }
            case 23: 
            case 30: 
            case 31: {
                if (!languages.contains("ADS")) break;
                accept[0] = true;
                if (languages.size() != 1) break;
                accept[1] = true;
                break;
            }
            case 22: {
                if (!dbTypes.contains("IMS/DB")) break;
                accept[0] = true;
                break;
            }
            case 17: {
                if (!pi.isVME()) break;
                accept[0] = true;
                break;
            }
            case 4: {
                if (!pi.isVME()) break;
                accept[0] = true;
                accept[1] = true;
                break;
            }
            case 1: 
            case 39: {
                if (languages.contains("COBOL") || languages.contains("VME COBOL")) {
                    accept[0] = true;
                }
                if (type != 1 || environment.contains("VME") && languages.size() != 1) break;
                accept[1] = true;
                break;
            }
            case 13: 
            case 41: {
                if (!languages.contains("ASSEMBLER")) break;
                accept[0] = true;
                if (type != 13 || languages.size() != 1) break;
                accept[1] = true;
                break;
            }
            case 2: 
            case 40: {
                if (!languages.contains("PL1")) break;
                accept[0] = true;
                if (type != 2 || languages.size() != 1) break;
                accept[1] = true;
                break;
            }
            case 3: 
            case 37: 
            case 38: {
                if (!languages.contains("NATURAL")) break;
                accept[0] = true;
                if (type != 3 || languages.size() != 1) break;
                accept[1] = true;
                break;
            }
            case 14: {
                if (!languages.contains("FORTRAN")) break;
                accept[0] = true;
                break;
            }
            case 15: {
                if (!languages.contains("ALGOL")) break;
                accept[0] = true;
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 42: {
                if (!environment.equals("MVS") && !environment.equals("VSE")) break;
                accept[0] = true;
                break;
            }
            case 8: 
            case 9: {
                if (!dbTypes.contains("IDMS")) break;
                accept[0] = true;
                break;
            }
            case 28: 
            case 29: {
                if (!dbTypes.contains("IDMSX")) break;
                accept[0] = true;
                break;
            }
            case 10: {
                if (!dbTypes.contains("RELATIONAL")) break;
                accept[0] = true;
                break;
            }
            case 12: {
                if (!screenTypes.contains("CICS")) break;
                accept[0] = true;
                break;
            }
            case 7: {
                if (!pi.isVME() && languages.isEmpty()) break;
                accept[0] = true;
                break;
            }
            case 16: {
                if (!pi.isZOS()) break;
                accept[0] = true;
                break;
            }
            case 19: {
                if (!languages.contains("COBOL") && !languages.contains("PL1") && !languages.contains("NATURAL")) break;
                accept[0] = true;
                break;
            }
            case 20: {
                if (!dbTypes.contains("DATACOM")) break;
                accept[0] = true;
                break;
            }
            case 32: {
                if (!screenTypes.contains("IMS/DC")) break;
                accept[0] = true;
                break;
            }
            case 33: 
            case 36: {
                if (!pi.isZOS() || !languages.contains("COBOL")) break;
                accept[0] = true;
                break;
            }
            case 34: 
            case 35: {
                if (!pi.isZOS()) break;
                accept[0] = true;
                break;
            }
            case 224: {
                accept[0] = true;
            }
        }
        return accept;
    }

    public List<TypeEntry> getTypes() {
        ArrayList<TypeEntry> types = new ArrayList<TypeEntry>(this.entries);
        Collections.sort(types);
        return types;
    }

    public boolean hasTypes() {
        return this.entries.size() != 0;
    }

    public AbstractPaginatedHandler getProvider(int type) {
        return this.handlers.get(type);
    }

    public void close() {
        for (AbstractPaginatedHandler dp : this.handlers.values()) {
            if (!dp.isStarted() || dp.isStopped()) continue;
            dp.close();
        }
    }
}

