/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.project;

import com.ez.analysis.mainframe.explore.project.LabelImagePair;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinationImagePainter
extends BackgroundPainter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CombinationImagePainter.class);
    private List<LabelImagePair> labelImagePairs = new ArrayList<LabelImagePair>();
    private final boolean paintBackground;
    private int spacing;

    public CombinationImagePainter(int spacing, boolean paintBackground) {
        this.spacing = spacing;
        this.paintBackground = paintBackground;
        L.trace("CombinationImagePainter created! spacing: " + spacing + " paintBackground: " + paintBackground);
    }

    public void add(String label, Image image) {
        this.labelImagePairs.add(new LabelImagePair(label, image));
        L.trace("CombinationImagePainter added LabelImagePair for label: " + label);
    }

    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        int width = 0;
        for (Image image : this.getImages(cell)) {
            if (width != 0) {
                width += this.spacing;
            }
            width += image.getBounds().width;
        }
        return width;
    }

    protected List<Image> getImages(ILayerCell cell) {
        ArrayList<Image> images = new ArrayList<Image>();
        for (LabelImagePair labelImage : this.labelImagePairs) {
            if (!cell.getConfigLabels().hasLabel(labelImage.getLabel())) continue;
            images.add(labelImage.getImage());
        }
        return images;
    }

    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        int height = 0;
        for (Image image : this.getImages(cell)) {
            height = Math.max(height, image.getBounds().height);
        }
        return height;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        if (this.paintBackground) {
            super.paintCell(cell, gc, bounds, configRegistry);
            L.trace("CombinationImagePainter paintCell paintBackground");
        }
        IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
        List<Image> images = this.getImages(cell);
        if (images == null || images.size() == 0) {
            return;
        }
        int boundX = bounds.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)this.getPreferredWidth(cell, gc, configRegistry));
        int paddingY = CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)this.getPreferredHeight(cell, gc, configRegistry));
        for (Image image : images) {
            Rectangle imageBounds = image.getBounds();
            gc.drawImage(image, boundX, bounds.y + paddingY);
            boundX += imageBounds.width + this.spacing;
        }
        L.trace("CombinationImagePainter paintCell images painted");
    }
}

