/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.login;

import com.ez.internal.utils.ServiceUtils;
import com.ibm.ad.oauth2.AuthenticationEvent;
import com.ibm.ad.oauth2.AuthenticationStatusListener;
import com.ibm.ad.oauth2.service.SSOService;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutHandler
implements IHandler,
AuthenticationStatusListener {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(LogoutHandler.class);
    private static final String LOGOUT_COMMAND_ID = "com.ez.analysis.mainframe.explore.logout";
    private boolean inProgress = false;
    boolean useDummy = Boolean.getBoolean("useDummy");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        SSOService ssos = (SSOService)ServiceUtils.getService(SSOService.class);
        if (ssos == null) {
            if (this.useDummy) {
                L.debug("could not get SSOService");
            } else {
                L.warn("could not get SSOService");
            }
        } else {
            ssos.addListener((AuthenticationStatusListener)this);
            if (ssos.isAuthEnabled() && ssos.isAuthenticated()) {
                try {
                    this.inProgress = true;
                    ssos.logout();
                }
                catch (Exception e) {
                    L.error("exception at login", (Throwable)e);
                    this.inProgress = false;
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        boolean enabled = false;
        if (!this.inProgress) {
            SSOService ssos = (SSOService)ServiceUtils.getService(SSOService.class);
            if (ssos == null) {
                if (this.useDummy) {
                    L.debug("could not get SSOService");
                } else {
                    L.warn("could not get SSOService");
                }
            }
            if (ssos.isAuthEnabled() && ssos.isAuthenticated()) {
                enabled = true;
            }
        }
        L.trace("logout enabled={}", (Object)enabled);
        return enabled;
    }

    public boolean isHandled() {
        return true;
    }

    public void onEvent(AuthenticationEvent event) {
        L.trace("logout event={}", (Object)event.getStatus());
        this.inProgress = false;
        IEvaluationService service = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        service.requestEvaluation(LOGOUT_COMMAND_ID);
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

