/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.login;

import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.internal.utils.ServiceUtils;
import com.ibm.ad.oauth2.AuthenticationEvent;
import com.ibm.ad.oauth2.AuthenticationStatusListener;
import com.ibm.ad.oauth2.service.SSOService;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthControlContribution
extends WorkbenchWindowControlContribution
implements AuthenticationStatusListener {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(AuthControlContribution.class);
    private Label lblAuthStatus;
    private SSOService ssos = null;
    boolean useDummy = Boolean.getBoolean("useDummy");

    public AuthControlContribution() {
        this.ssos = (SSOService)ServiceUtils.getService(SSOService.class);
        if (this.ssos == null) {
            if (this.useDummy) {
                L.debug("could not get SSOService");
            } else {
                L.warn("could not get SSOService");
            }
        } else {
            this.ssos.addListener((AuthenticationStatusListener)this);
        }
    }

    public AuthControlContribution(String id) {
        super(id);
    }

    protected Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout();
        container.setLayout((Layout)glContainer);
        GridData glReader = new GridData(4, 4, false, false, 1, 1);
        glReader.widthHint = 200;
        this.lblAuthStatus = new Label(container, 2048);
        this.lblAuthStatus.setLayoutData((Object)glReader);
        this.checkAuthStatus(null);
        return container;
    }

    public void onEvent(AuthenticationEvent event) {
        this.checkAuthStatus(event);
    }

    private void checkAuthStatus(final AuthenticationEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String txt = Messages.getString(AuthControlContribution.class, "notAuthenticated.state");
                if (event != null) {
                    switch (event.getStatus()) {
                        case 3: {
                            txt = Messages.getString(AuthControlContribution.class, "restartNeeded.state");
                            break;
                        }
                        default: {
                            if (AuthControlContribution.this.ssos != null) {
                                txt = AuthControlContribution.this.getAuthLabel();
                                break;
                            }
                            txt = Messages.getString(AuthControlContribution.class, "noService.state");
                            break;
                        }
                    }
                } else {
                    txt = AuthControlContribution.this.ssos != null ? AuthControlContribution.this.getAuthLabel() : "";
                }
                AuthControlContribution.this.lblAuthStatus.setText(txt);
            }
        });
    }

    private String getAuthLabel() {
        String txt = "";
        txt = this.ssos.isAuthEnabled() ? (this.ssos.isAuthenticated() ? Messages.getString(AuthControlContribution.class, "authenticated.state") : Messages.getString(AuthControlContribution.class, "notAuthenticated.state")) : "";
        return txt;
    }
}

