/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.mainframe.model.ProjectInfo;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;

public class VariablePaginatedHandler
extends MFPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String baseQuery = "SELECT Variables.VarID, Variables.VarName, Paths.PathStr, Programs.ProgramTypeId, Occurrences.StartRow \nFROM     Occurrences INNER JOIN\n                      Paths ON Occurrences.PathID = Paths.PathID INNER JOIN \n                      Variables ON Occurrences.OccurID = Variables.OccurID \n          left join Programs on programs.ProgramID = Occurrences.ProgID \nWHERE     (Variables.OccurID <> 0) @1@";
    private String countQuery = "SELECT count(Variables.VarID) \nFROM     Occurrences INNER JOIN\n                      Paths ON Occurrences.PathID = Paths.PathID INNER JOIN\n                      Variables ON Occurrences.OccurID = Variables.OccurID\nWHERE     (Variables.OccurID <> 0) @1@";

    public VariablePaginatedHandler(ProjectInfo pi) {
        super(pi);
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "Variables.VarName", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), new String[]{"1", Messages.getString(VariablePaginatedHandler.class, "noData.message")});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " and Variables.VarName ");
    }

    @Override
    public void handleDoubleClick(NatTable natTable, NatEventData eventData, int row, String[] rowObject) {
        String path = null;
        String type = null;
        int startRow = 0;
        if (rowObject.length >= 7) {
            path = rowObject[4];
            type = rowObject[5];
        }
        if (path != null) {
            startRow = Integer.parseInt(rowObject[6]);
            this.openEditor(type, path, new int[]{startRow}, this.pi.getName());
        } else {
            this.reportNoSource(Messages.getString(VariablePaginatedHandler.class, "noSource.type"), rowObject[1]);
        }
    }
}

