/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZAppTWSInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceAppTWSSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class TWSApplicationsPaginatedHandler
extends MFPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String baseQuery = "select AppId, ApplicationName, Description from TWS_Applications @1@";
    private String countQuery = "select count(AppId) from TWS_Applications @1@";

    public TWSApplicationsPaginatedHandler(ProjectInfo pi) {
        super(pi);
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    public AnalysisType getOperationType() {
        return AnalysisType.EZSOURCE_TWS_GRAPH_ANALYSIS;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "TWS_Applications.ApplicationName", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), new String[]{"1", Messages.getString(TWSApplicationsPaginatedHandler.class, "noData.message")});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " where TWS_Applications.ApplicationName");
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZAppTWSInputType> inputs = new ArrayList<EZAppTWSInputType>();
        String appId = null;
        String appName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            appId = row[2];
            appName = row[3];
            EZAppTWSInputType inputType = new EZAppTWSInputType();
            inputs.add(inputType);
            EZSourceAppTWSSg appsg = new EZSourceAppTWSSg(appId, appName);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)appsg);
            inputType.setEntID(entityId);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String appName = null;
        String desc = null;
        for (String[] row : selection) {
            if (row == null) continue;
            appName = row[3];
            desc = row[4];
            break;
        }
        if (appName != null) {
            MainframeGenericNode node = new MainframeGenericNode();
            node.addRow(new String[]{Messages.getString(TWSApplicationsPaginatedHandler.class, "properties.name.text"), appName});
            node.addRow(new String[]{Messages.getString(TWSApplicationsPaginatedHandler.class, "properties.description.text"), desc});
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            return new StructuredSelection((Object)entID);
        }
        return super.prepareSelection4Properties(selection);
    }
}

