/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;

public class SQLTablePaginatedHandler
extends MFPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public SQLTablePaginatedHandler(ProjectInfo pi) {
        super(pi);
        this.info.put("dcColumn", 7);
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.getBaseQuery(filter != null && filter.onlyDC()), this.getParamObject(filter));
        query = this.paginate(query, "SqlTables.TableName", start, end, filter);
        return new PagedRunnable(query);
    }

    private String getBaseQuery(boolean isDC) {
        String baseQuery = "SELECT     SqlTables.SqlTableID, SqlTables.TableName, Paths.PathStr, Programs.ProgramTypeId, Occurrences.StartRow\n" + (this.prefDC ? ", p.UnreachablePara as relDeadCode" : "") + "\n" + "FROM         SqlTables left JOIN Occurrences \n" + "                             ON SqlTables.OccurID = Occurrences.OccurID and (SqlTables.OccurID <> 0) \n" + "             left JOIN Paths ON Occurrences.PathID = Paths.PathID" + "             left join Programs on programs.ProgramID = Occurrences.ProgID " + this.getDCQueryPart(isDC) + " @1@";
        return baseQuery;
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.getCountQuery(filter != null && filter.onlyDC()), this.getParamObject(filter)), new String[]{"1", Messages.getString(SQLTablePaginatedHandler.class, "noData.message")});
    }

    private String getCountQuery(boolean isDC) {
        String countQuery = "SELECT count(SqlTables.SqlTableID) \nFROM         SqlTables left JOIN Occurrences \n                             ON SqlTables.OccurID = Occurrences.OccurID and (SqlTables.OccurID <> 0) \n" + this.getDCQueryPart(isDC) + " @1@";
        return countQuery;
    }

    private String getDCQueryPart(boolean isDC) {
        String s1 = " join (Select DISTINCT ResourceID, UnreachablePara from StatementReference \r\n\tinner join  OccurrencesStmt oc_stmt on oc_stmt.OccurID = StatementReference.OccurID\r\n\tinner join Paragraphs on UnreachablePara = -1 and Paragraphs.ParaID = oc_stmt.ParaID \r\n\twhere StatementReference.ResourceType = MARKER_1 ) as p on p.ResourceID = MARKER_2\n".replace(MARKER_1, "1");
        String s2 = s1.replace(MARKER_2, "SqlTables.SqlTableID");
        return this.prefDC ? String.valueOf(isDC ? " inner" : " left") + s2 : "";
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " where SqlTables.TableName");
    }

    @Override
    public void handleDoubleClick(NatTable natTable, NatEventData eventData, int row, String[] rowObject) {
        String path = null;
        String type = null;
        int startRow = 0;
        if (rowObject.length >= 7) {
            path = rowObject[4];
            type = rowObject[5];
        }
        if (path != null) {
            startRow = Integer.parseInt(rowObject[6]);
            this.openEditor(type, path, new int[]{startRow}, this.pi.getName());
        } else {
            this.reportNoSource(Messages.getString(SQLTablePaginatedHandler.class, "noSource.type.name"), rowObject[1]);
        }
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        String tableName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            tableName = row[3];
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(1), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            inputs.add(inputType);
            EZSourceSQLTableIDSg tableSg = new EZSourceSQLTableIDSg(tableName);
            inputType.setName(tableName);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)tableSg);
            inputType.setEntID(entityId);
            inputType.addProperty("mainframe resource id sg", (Object)tableSg);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String tableName = null;
        String path = null;
        for (String[] row : selection) {
            if (row == null) continue;
            tableName = row[3];
            path = row[4];
            break;
        }
        MainframeGenericNode node = new MainframeGenericNode();
        node.addRow(new String[]{Messages.getString(SQLTablePaginatedHandler.class, "properties.name.label"), tableName});
        node.addRow(new String[]{Messages.getString(SQLTablePaginatedHandler.class, "properties.path.label"), path != null ? path : ""});
        EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
        EZEntityID entID = new EZEntityID();
        entID.addSegment((EZSegment)sg);
        return new StructuredSelection((Object)entID);
    }

    @Override
    public boolean acceptDeadCode() {
        return true;
    }
}

