/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.data.impl.handlers.ProgramPaginatedHandler;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;

public class SCLProgramPaginatedHandler
extends ProgramPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected String baseQuery = "select progAl.AliasName as ProgramName, pgms.ProgramID, Paths.PathStr, proct.AliasName as procName, proct.ProgramID as procid\n\t\t\tFROM         Programs as pgms  inner join ProgramAliases progAl on progAl.programid = pgms.ProgramId and progAl.AliasType = 0 \n\t\t\t\t\tleft JOIN Occurrences ON pgms.OccurID = Occurrences.OccurID and (pgms.OccurID <> 0)\n\t\t\t             left JOIN  Paths ON Occurrences.PathID = Paths.PathID\n\t\t\t             left join ( select AliasName, procs.ProgramID, ProgramTypeID, Ancestor from Programs as procs \t\t\t\t\t\t\t\tinner join ProgramAliases procAl on procAl.programid = procs.ProgramId and procAl.AliasType = 0 ) proct\t\t\ton proct.Ancestor = progAl.AliasName and proct.ProgramTypeID = 19\n\t\t\tWHERE  pgms.ProgramTypeID = 13 @1@";

    public SCLProgramPaginatedHandler(ProjectInfo pi, String name) {
        super(pi, name, 13);
        this.acceptAnnotations = false;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "progAl.AliasName", start, end, filter);
        return new PagedRunnable(query);
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        String like = filter == null ? "" : filter.getLikeExpression();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.programTypes.length) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.programTypes[i]);
            ++i;
        }
        sb.toString();
        return new Object[][]{{2, like.isEmpty() ? "" : "and progAl.AliasName" + like}};
    }

    @Override
    public void handleDoubleClick(NatTable natTable, NatEventData eventData, int row, String[] rowObject) {
        String path = null;
        String programType = null;
        if (rowObject.length >= 6) {
            path = rowObject[4];
            programType = "13";
        }
        if (path != null) {
            this.openEditor(programType, path, null, this.pi.getName());
        } else {
            this.reportNoSource(Messages.getString(SCLProgramPaginatedHandler.class, "noSource.type.name"), rowObject[1]);
        }
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        String programId = null;
        String programName = null;
        String programTypeID = null;
        String ancestor = null;
        String ancestorID = null;
        String path = null;
        for (String[] row : selection) {
            if (row == null) continue;
            programId = Utils.filterNullValue((String)row[6]);
            programName = row[5];
            programTypeID = "19";
            ancestor = row[2];
            ancestorID = row[3];
            path = row[4];
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(Integer.parseInt(programTypeID)));
            inputs.add(inputType);
            Boolean occur = path != null && !path.isEmpty();
            EZSourceProgramIDSg prgSg = new EZSourceProgramIDSg(programName != null ? programName : "", Integer.valueOf(programId != null ? Integer.parseInt(programId) : new Integer(-1)), Integer.valueOf(Integer.parseInt(programTypeID)), ancestor, Integer.valueOf(Integer.parseInt(ancestorID)), occur);
            inputType.addProperty("program occur", (Object)occur);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)prgSg);
            inputType.setEntID(entityId);
            inputType.setName(programName);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String prgPath = null;
        String programName = null;
        String ancestor = null;
        for (String[] row : selection) {
            if (row == null) continue;
            prgPath = row[4];
            programName = row[5];
            ancestor = row[2];
            break;
        }
        MainframeGenericNode node = new MainframeGenericNode();
        node.addRow(new String[]{Messages.getString(SCLProgramPaginatedHandler.class, "properties.name.label"), ancestor});
        node.addRow(new String[]{Messages.getString(SCLProgramPaginatedHandler.class, "properties.procedure.label"), programName});
        node.addRow(new String[]{Messages.getString(SCLProgramPaginatedHandler.class, "properties.path.label"), prgPath != null ? prgPath : ""});
        EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
        EZEntityID entID = new EZEntityID();
        entID.addSegment((EZSegment)sg);
        return new StructuredSelection((Object)entID);
    }
}

