/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.AnnPagedRunnable;
import com.ez.analysis.mainframe.explore.data.impl.AnnotatedCounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.handlers.AnnotatedPaginatedHandler;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.MenuItemProviders;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramPaginatedHandler
extends AnnotatedPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramPaginatedHandler.class);
    private static final String PRG_TYPE_MARKER = "prg_type_marker";
    protected int[] programTypes;
    protected String name;
    private String whereAnnCondition = " @1@ ";
    private String fromPart = "FROM  Programs \n inner join ProgramAliases on ProgramAliases.programid = Programs.ProgramId and ProgramAliases.AliasType = 0  left JOIN Occurrences ON Programs.OccurID = Occurrences.OccurID and (Programs.OccurID <> 0)\n";
    private String wherePart = "WHERE  (Programs.ProgramTypeID in (@1@)) @2@";
    private boolean prefDC = PreferenceUtils.getPreferenceStore().getBoolean("displayDeadCode");

    public ProgramPaginatedHandler(ProjectInfo pi, String name, int ... programType) {
        super(pi);
        this.programTypes = programType;
        this.name = name;
        this.resIdColumn = 2;
        this.annotationcolum = 7;
        this.pathColumn = 4;
        this.resType = 5;
        this.init();
        this.annBaseQ = String.valueOf(this.annBaseQ) + " and det.progType in (prg_type_marker)";
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        boolean onlyAnn;
        boolean annDBAvailable = this.isAnnDbAvailable();
        String query = this.getBaseQuery(filter != null && filter.onlyDC());
        query = this.paginate(query, "ProgramAliases.AliasName", start, end, filter);
        L.trace("{}", (Object)query);
        String qAnn = null;
        if (annDBAvailable) {
            qAnn = String.valueOf(this.prepareAnnBaseQuery(annDBAvailable, "distinct res.dbid")) + this.whereAnnCondition;
            qAnn = this.prepare(qAnn, this.getParamObjects(filter, " and UPPER(det.resName) "));
        }
        Object[][] paramObject = this.getParamObject(filter);
        boolean bl = onlyAnn = annDBAvailable && filter != null && filter.considerAnnotations();
        if (onlyAnn) {
            Integer dbEngineInt = (Integer)this.pi.getInfo().get("dbEngine");
            ServerType dbEngine = ServerType.findByValue((int)dbEngineInt);
            paramObject[1] = new Object[]{0, " and Programs.ProgramId in (select * from " + Utils.getTempTableName((ServerType)dbEngine, (String)"numeric_param_temp") + ")"};
        }
        query = this.prepare(query, paramObject);
        return new AnnPagedRunnable(query, qAnn, onlyAnn, 7);
    }

    private String getBaseQuery(boolean isDC) {
        String ret = "select Programs.ProgramID, ProgramAliases.AliasName as ProgramName, Paths.PathStr, Programs.ProgramTypeID, Programs.Ancestor , '' as hasAnn" + (this.prefDC ? ", p.UnreachablePara as relDeadCode" : "") + "\n" + this.fromPart + " left JOIN  Paths ON Occurrences.PathID = Paths.PathID\n" + this.getDCQueryPart(isDC) + this.wherePart;
        return ret;
    }

    private String getCountQuery(boolean countInPrjRepo, boolean annDBAvailable, boolean isDC) {
        String q = "";
        q = countInPrjRepo ? "select count(Programs.ProgramID) " + this.fromPart + this.getDCQueryPart(isDC) + this.wherePart : String.valueOf(this.prepareAnnBaseQuery(annDBAvailable, "count (distinct res.dbid)")) + this.whereAnnCondition;
        return q;
    }

    private String getDCQueryPart(boolean isDC) {
        String s1 = " join (Select DISTINCT ResourceID, UnreachablePara from StatementReference \r\n\tinner join  OccurrencesStmt oc_stmt on oc_stmt.OccurID = StatementReference.OccurID\r\n\tinner join Paragraphs on UnreachablePara = -1 and Paragraphs.ParaID = oc_stmt.ParaID \r\n\twhere StatementReference.ResourceType = MARKER_1 ) as p on p.ResourceID = MARKER_2\n".replace(MARKER_1, "5");
        String s2 = s1.replace(MARKER_2, "Programs.ProgramId");
        return this.prefDC ? String.valueOf(isDC ? " inner" : " left") + s2 : "";
    }

    @Override
    protected String prepareAnnBaseQuery(boolean annDBAvailable, String annReplacement) {
        String q = super.prepareAnnBaseQuery(annDBAvailable, annReplacement);
        StringBuilder replacement = new StringBuilder();
        int i = 0;
        while (i < this.programTypes.length) {
            replacement.append(this.programTypes[i]);
            replacement.append(",");
            ++i;
        }
        replacement.deleteCharAt(replacement.length() - 1);
        q = q.replaceAll(PRG_TYPE_MARKER, replacement.toString());
        return q;
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        boolean annDBAvailable = this.isAnnDbAvailable();
        boolean countInPrjRepo = this.countInPrjRepo(filter, annDBAvailable);
        String query = this.getCountQuery(countInPrjRepo, annDBAvailable, filter != null && filter.onlyDC());
        query = countInPrjRepo ? this.prepare(query, this.getParamObject(filter)) : this.prepare(query, this.getParamObjects(filter, " and UPPER(det.resName) "));
        L.trace("{}", (Object)query);
        String[] noDataRow = new String[]{"1", Messages.getString(ProgramPaginatedHandler.class, "noData.message", new String[]{this.name})};
        CounterRunnable cr = null;
        if (countInPrjRepo) {
            cr = new CounterRunnable(query, noDataRow);
        } else {
            cr = new AnnotatedCounterRunnable(query, noDataRow);
            cr.setQueryParams(new Object[]{this.pi.getName()});
        }
        return cr;
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        String like = filter == null ? "" : filter.getLikeExpression();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.programTypes.length) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.programTypes[i]);
            ++i;
        }
        String pTypes = sb.toString();
        return new Object[][]{{2, pTypes}, {2, like.isEmpty() ? "" : "and UPPER(ProgramAliases.AliasName) " + like}};
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    public IMenuItemProvider contributeContextMenu() {
        IMenuItemProvider menuItemProvider = new IMenuItemProvider(){

            public void addMenuItem(NatTable natTable, Menu popupMenu) {
                MenuItem menuItem = new MenuItem(popupMenu, 8);
                menuItem.setText(Messages.getString(ProgramPaginatedHandler.class, "viewSource.menuItem"));
                menuItem.setImage(GUIHelper.getImage((String)"hide_column"));
                menuItem.setEnabled(true);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        L.debug("event for viewsource: {}", (Object)event);
                        NatEventData eventData = MenuItemProviders.getNatEventData((SelectionEvent)event);
                        int row = eventData.getRowPosition();
                        L.debug("go to source for program type: {}!", (Object)(this).ProgramPaginatedHandler.this.programTypes);
                        L.debug("{}", Arrays.asList(ProgramPaginatedHandler.this.getRowObject(row)));
                    }
                });
            }
        };
        return menuItemProvider;
    }

    @Override
    public void handleDoubleClick(NatTable natTable, NatEventData eventData, int row, String[] rowObject) {
        String path = null;
        String programType = null;
        if (rowObject.length >= 6) {
            path = rowObject[4];
            programType = rowObject[5];
        }
        if (path != null) {
            this.openEditor(programType, path, null, this.pi.getName());
        } else {
            this.reportNoSource(Messages.getString(ProgramPaginatedHandler.class, "noSource.type"), rowObject[1]);
        }
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        String programId = null;
        String programName = null;
        String programTypeID = null;
        String ancestor = null;
        String prgPath = null;
        for (String[] row : selection) {
            if (row == null) continue;
            programId = row[2];
            programName = row[3];
            prgPath = row[4];
            programTypeID = row[5];
            ancestor = row[6];
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(Integer.parseInt(programTypeID)));
            inputs.add(inputType);
            Boolean occur = prgPath != null && !prgPath.isEmpty();
            EZSourceProgramIDSg prgSg = new EZSourceProgramIDSg(programName, Integer.valueOf(Integer.parseInt(programId)), Integer.valueOf(Integer.parseInt(programTypeID)), ancestor, null, occur);
            prgSg.setPath(prgPath);
            inputType.addProperty("program occur", (Object)occur);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)prgSg);
            inputType.setEntID(entityId);
            inputType.setName(programName);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String prgPath = null;
        String programName = null;
        String programTypeID = null;
        for (String[] row : selection) {
            if (row == null) continue;
            programName = row[3];
            prgPath = row[4];
            programTypeID = row[5];
            break;
        }
        MainframeGenericNode node = new MainframeGenericNode();
        node.addRow(new String[]{Messages.getString(ProgramPaginatedHandler.class, "properties.name.text"), programName});
        node.addRow(new String[]{Messages.getString(ProgramPaginatedHandler.class, "properties.path.text"), prgPath != null ? prgPath : ""});
        node.addRow(new String[]{Messages.getString(ProgramPaginatedHandler.class, "properties.type.text"), Utils.getPrgType((String)programTypeID)});
        EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
        EZEntityID entID = new EZEntityID();
        entID.addSegment((EZSegment)sg);
        return new StructuredSelection((Object)entID);
    }

    @Override
    public boolean acceptDeadCode() {
        return true;
    }
}

