/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.AnnPagedRunnable;
import com.ez.analysis.mainframe.explore.data.impl.AnnotatedCounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.handlers.AnnotatedPaginatedHandler;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceAAUTOJobIDSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCLPaginatedHandler
extends AnnotatedPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(JCLPaginatedHandler.class);
    private String fromPart = "FROM JCLJob INNER JOIN\n      JCLPosition ON JCLJob.PositionID = JCLPosition.PositionID ";
    private String whereCondition = " @1@ ";
    private static final String JCL_JOB_JOB_NAME_RESTRICT = " where UPPER(JCLJob.JobName) ";

    public JCLPaginatedHandler(ProjectInfo pi) {
        super(pi);
        this.resIdColumn = 2;
        this.annotationcolum = 6;
        this.resType = 22;
        this.pathColumn = 4;
        this.init();
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        boolean onlyAnn;
        boolean annDBAvailable = this.isAnnDbAvailable();
        String query = String.valueOf(this.getBaseQuery()) + this.whereCondition;
        query = this.paginate(query, "JCLJob.JobName", start, end, filter);
        L.trace("q={}", (Object)query);
        String qAnn = null;
        if (annDBAvailable) {
            qAnn = String.valueOf(this.prepareAnnBaseQuery(annDBAvailable, "distinct res.dbid")) + this.whereCondition;
            qAnn = this.prepare(qAnn, this.getParamObjects(filter, " and UPPER(det.resName) "));
        }
        Object[][] paramObject = this.getParamObjects(filter, JCL_JOB_JOB_NAME_RESTRICT);
        boolean bl = onlyAnn = annDBAvailable && filter != null && filter.considerAnnotations();
        if (onlyAnn) {
            Integer dbEngineInt = (Integer)this.pi.getInfo().get("dbEngine");
            ServerType dbEngine = ServerType.findByValue((int)dbEngineInt);
            paramObject = new Object[][]{{0, " where JCLJob.JobID in (select * from " + Utils.getTempTableName((ServerType)dbEngine, (String)"numeric_param_temp") + ")"}};
        }
        query = this.prepare(query, paramObject);
        return new AnnPagedRunnable(query, qAnn, onlyAnn, 6);
    }

    private String getBaseQuery() {
        String ret = "SELECT JCLJob.JobID, JCLJob.JobName, JCLPosition.ResourceFilePath, JCLJob.MemberName,  '' as hasAnn, JCLJob.BuildStatus \n" + this.fromPart;
        return ret;
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        boolean annDBAvailable = this.isAnnDbAvailable();
        boolean countInPrjRepo = this.countInPrjRepo(filter, annDBAvailable);
        String query = this.getCountQuery(countInPrjRepo, annDBAvailable);
        String prefix = countInPrjRepo ? JCL_JOB_JOB_NAME_RESTRICT : " and UPPER(det.resName) ";
        query = this.prepare(query, this.getParamObjects(filter, prefix));
        L.trace("countQ={}", (Object)query);
        String[] noDataRow = new String[]{"1", Messages.getString(JCLPaginatedHandler.class, "noData.message")};
        CounterRunnable cr = null;
        if (countInPrjRepo) {
            cr = new CounterRunnable(query, noDataRow);
        } else {
            cr = new AnnotatedCounterRunnable(query, noDataRow);
            cr.setQueryParams(new Object[]{this.pi.getName()});
        }
        return cr;
    }

    private String getCountQuery(boolean countInPrjRepo, boolean annDBAvailable) {
        String q = "";
        q = countInPrjRepo ? "SELECT count(JCLJob.JobID) " + this.fromPart : this.prepareAnnBaseQuery(annDBAvailable, "count (distinct res.dbid)");
        q = String.valueOf(q) + this.whereCondition;
        return q;
    }

    @Override
    public void handleDoubleClick(NatTable natTable, NatEventData eventData, int row, String[] rowObject) {
        String path = null;
        if (rowObject.length >= 5) {
            path = rowObject[4];
        }
        if (path != null) {
            this.openEditor(22, path, null, this.pi.getName());
        } else {
            this.reportNoSource(Messages.getString(JCLPaginatedHandler.class, "noSource.typeName"), rowObject[1]);
        }
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        String jobId = null;
        String jobName = null;
        String memberName = null;
        boolean deleted = false;
        for (String[] row : selection) {
            if (row == null) continue;
            jobId = row[2];
            jobName = row[3];
            memberName = row[5];
            deleted = !"1".equals(row[row.length - 1]);
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(22));
            inputs.add(inputType);
            EZSourceJobIDSg jobSg = new EZSourceJobIDSg(jobName, jobId, 22, memberName, deleted);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)jobSg);
            entityId.addSegment((EZSegment)new EZSourceAAUTOJobIDSg(jobName, null));
            inputType.setEntID(entityId);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String path = null;
        String jobName = null;
        String memberName = null;
        String buildStatus = null;
        for (String[] row : selection) {
            if (row == null) continue;
            jobName = row[3];
            path = row[4];
            memberName = row[5];
            buildStatus = row[row.length - 1];
            break;
        }
        if (Integer.valueOf(buildStatus) == 0) {
            path = null;
        }
        if (jobName != null) {
            MainframeGenericNode node = new MainframeGenericNode();
            node.addRow(new String[]{Messages.getString(JCLPaginatedHandler.class, "properties.name.label"), jobName});
            node.addRow(new String[]{Messages.getString(JCLPaginatedHandler.class, "properties.path.label"), path != null ? path : ""});
            node.addRow(new String[]{Messages.getString(JCLPaginatedHandler.class, "properties.member.label"), memberName != null ? memberName : ""});
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            return new StructuredSelection((Object)entID);
        }
        return super.prepareSelection4Properties(selection);
    }
}

