/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.config.inputs.EZSourceInclude;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceIncludeIDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProgramTypeIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;

public abstract class IncludePaginatedHandler
extends MFPaginatedHandler {
    public IncludePaginatedHandler(ProjectInfo pi) {
        super(pi);
        this.info.put("dcColumn", 6);
    }

    public int getColumnCount() {
        return 1;
    }

    protected abstract String getIncludeTypes();

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.getBaseQuery(filter != null && filter.onlyDC()), this.getParamObjects(filter, " where x.Name"));
        query = this.paginate(query, "x.Name", start, end, filter);
        PagedRunnable pr = new PagedRunnable(query);
        pr.setQueryParams(new Object[]{this.getIncludeTypes()});
        return pr;
    }

    private String getBaseQuery(boolean isDC) {
        String baseQuery = "select x.name, x.Resourcetype, x.Path, x.PathID \n" + (this.prefDC ? ", p.UnreachablePara as relDeadCode" : "") + "\n" + "FROM (select distinct Resources.Name, Resources.ResourceID, StatementReference.ResourceType,\n" + "\tcase when Paths_Incl.Pathstr = Resources.Name then null\n" + "\telse Paths_Incl.PathStr end as Path, Paths_Incl.PathID\n" + "FROM StatementReference\n" + "    INNER JOIN Resources ON StatementReference.ResourceID = Resources.ResourceID\n" + "    INNER JOIN Occurrences AS Occurrences_Incl ON Resources.OccurID = Occurrences_Incl.OccurID\n" + "    INNER JOIN Paths AS Paths_Incl ON Occurrences_Incl.PathID = Paths_Incl.PathID\n" + "    WHERE StatementReference.ResourceType in (?) \n" + "    ) as x" + this.getDCQueryPart(isDC) + "    @1@";
        return baseQuery;
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        String cQuery = this.getCountQuery(filter != null && filter.onlyDC());
        CounterRunnable cr = new CounterRunnable(this.prepare(cQuery, this.getParamObjects(filter, " and x.Name")), new String[]{"1", Messages.getString(this.getClass(), "noData.message")});
        cr.setQueryParams(new Object[]{this.getIncludeTypes()});
        return cr;
    }

    private String getCountQuery(boolean isDC) {
        String countQuery = "select count(distinct x.Name)\nFROM StatementReference\n    INNER JOIN Resources as x ON StatementReference.ResourceID = x.ResourceID\n    INNER JOIN Occurrences AS Occurrences_Incl ON x.OccurID = Occurrences_Incl.OccurID\n" + this.getDCQueryPart(isDC) + "    WHERE StatementReference.ResourceType in (?) " + " @1@";
        return countQuery;
    }

    private String getDCQueryPart(boolean isDC) {
        String s1 = " join (Select DISTINCT ResourceID, UnreachablePara from StatementReference \r\n\tinner join  OccurrencesStmt oc_stmt on oc_stmt.OccurID = StatementReference.OccurID\r\n\tinner join Paragraphs on UnreachablePara = -1 and Paragraphs.ParaID = oc_stmt.ParaID \r\n\twhere StatementReference.ResourceType = MARKER_1 ) as p on p.ResourceID = MARKER_2\n".replace(MARKER_1, this.getIncludeTypes());
        String s2 = s1.replace(MARKER_2, "x.ResourceID");
        return this.prefDC ? String.valueOf(isDC ? " inner" : " left") + s2 : "";
    }

    @Override
    public void handleDoubleClick(NatTable natTable, NatEventData eventData, int row, String[] rowObject) {
        String path = null;
        String inclType = null;
        if (rowObject.length >= 5) {
            inclType = rowObject[3];
            path = rowObject[4];
        }
        if (path != null) {
            String programType = this.getProgramType(inclType);
            this.openEditor(programType, path, null, this.pi.getName());
        } else {
            this.reportNoSource(Messages.getString(this.getClass(), "noSource.typeName"), rowObject[1]);
        }
    }

    protected abstract String getProgramType(String var1);

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZSourceInclude> inputs = new ArrayList<EZSourceInclude>();
        String inclType = null;
        String includeName = null;
        String path = null;
        String pathID = null;
        for (String[] row : selection) {
            if (row == null) continue;
            includeName = row[2];
            inclType = row[3];
            path = row[4];
            pathID = row[5];
            EZSourceInclude inputType = new EZSourceInclude();
            inputs.add(inputType);
            EZSourceIncludeIDSg includeSg = new EZSourceIncludeIDSg(includeName, Integer.valueOf(pathID));
            inputType.addProperty("mainframe resource id sg", (Object)includeSg);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)includeSg);
            inputType.addProperty("include is not on disk", (Object)(path == null ? Boolean.TRUE : Boolean.FALSE));
            String programType = this.getProgramType(inclType);
            Integer programTypeId = Integer.valueOf(programType);
            EZSourceProgramTypeIDSg prgSg = new EZSourceProgramTypeIDSg(programTypeId);
            entityId.addSegment((EZSegment)prgSg);
            inputType.setEntID(entityId);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String includeName = null;
        String prgType = null;
        String path = null;
        for (String[] row : selection) {
            if (row == null) continue;
            includeName = row[2];
            String inclType = row[3];
            prgType = this.getProgramType(inclType);
            path = row[4];
            break;
        }
        MainframeGenericNode node = new MainframeGenericNode();
        node.addRow(new String[]{Messages.getString(IncludePaginatedHandler.class, "properties.name.label"), includeName});
        node.addRow(new String[]{Messages.getString(IncludePaginatedHandler.class, "properties.path.label"), path != null ? path : ""});
        node.addRow(new String[]{Messages.getString(IncludePaginatedHandler.class, "properties.language.label"), Utils.getExternalizedType((Integer)Integer.valueOf(prgType))});
        EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
        EZEntityID entID = new EZEntityID();
        entID.addSegment((EZSegment)sg);
        return new StructuredSelection((Object)entID);
    }

    @Override
    public boolean acceptDeadCode() {
        return true;
    }
}

