/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;

public class IMSMapPaginatedHandler
extends MFPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String baseQuery = "SELECT IMSMaps.MapName AS screenName, IMSMaps.OccurID, Paths.PathStr, IMSMaps.MapID, s1.Name AS mid, s2.Name as modd, Occurrences.StartRow\n\tFROM IMSMaps\n         left join Occurrences on Occurrences.OccurID = IMSMaps.OccurID\n         LEFT JOIN Paths ON Occurrences.PathID = Paths.PathID     \n\t\t  LEFT JOIN IMSMapIOFormat s1 on s1.IMSMapId = IMSMaps.MapID and s1.TypeId = 0\n\t\t  LEFT JOIN IMSMapIOFormat s2 on s2.IMSMapId = IMSMaps.MapID and s2.TypeId = 1\n \t@1@";
    private String countQuery = "SELECT count(IMSMaps.MapName)\n\tFROM IMSMaps\n\t @1@";

    public IMSMapPaginatedHandler(ProjectInfo pi) {
        super(pi);
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, " IMSMaps.MapName", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), new String[]{"1", Messages.getString(IMSMapPaginatedHandler.class, "noData.message")});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " where IMSMaps.MapName");
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        String layoutName = null;
        String screenOccur = null;
        Integer screenID = null;
        String mod = null;
        for (String[] row : selection) {
            if (row == null) continue;
            layoutName = row[2];
            screenOccur = row[3];
            screenID = Integer.valueOf(row[5]);
            mod = row[7];
            EZEntityID entity = new EZEntityID();
            entity.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            String screenName = mod == null ? "" : mod;
            EZSourceScreenIDSg scrIdSg = new EZSourceScreenIDSg(screenID, screenName, 65, Integer.valueOf(screenOccur));
            scrIdSg.setMapSet(layoutName);
            entity.addSegment((EZSegment)scrIdSg);
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(65), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            inputType.setName(mod);
            inputType.setEntID(entity);
            inputs.add(inputType);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String screenName = null;
        String path = null;
        String mid = null;
        String mod = null;
        for (String[] row : selection) {
            if (row == null) continue;
            screenName = row[2];
            path = row[4];
            mid = row[6];
            mod = row[7];
            break;
        }
        if (screenName != null) {
            MainframeGenericNode node = new MainframeGenericNode();
            node.addRow(new String[]{Messages.getString(IMSMapPaginatedHandler.class, "properties.name.label"), screenName});
            node.addRow(new String[]{Messages.getString(IMSMapPaginatedHandler.class, "properties.path.label"), path != null ? path : ""});
            if (mid != null) {
                node.addRow(new String[]{Messages.getString(IMSMapPaginatedHandler.class, "properties.mid.label"), mid});
            }
            if (mod != null) {
                node.addRow(new String[]{Messages.getString(IMSMapPaginatedHandler.class, "properties.mod.label"), mod});
            }
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            return new StructuredSelection((Object)entID);
        }
        return super.prepareSelection4Properties(selection);
    }

    @Override
    public void handleDoubleClick(NatTable natTable, NatEventData eventData, int row, String[] rowObject) {
        String path = rowObject[4];
        int startRow = 0;
        if (path != null) {
            startRow = Integer.parseInt(rowObject[8]);
            this.openEditor(10006, path, new int[]{startRow}, this.pi.getName());
        } else {
            this.reportNoSource(Messages.getString(IMSMapPaginatedHandler.class, "noSource.type.name"), rowObject[2]);
        }
    }
}

