/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.config.inputs.EZSourceIMSDatabase;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceIMSDatabaseIDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMSDBPaginatedHandler
extends MFPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(IMSDBPaginatedHandler.class);
    private String baseQuery = "select IMSDBInfo.DBId, IMSDBInfo.DBName, IMSDBInfo.AccessTypeId, Paths.PathStr from IMSDBInfo  left join Occurrences  as oc on oc.OccurID = IMSDBInfo.OccurId left join Paths on oc.PathID = Paths.PathID  @1@";
    private String countQuery = "select count(IMSDBInfo.DBId) from IMSDBInfo   @1@";

    public IMSDBPaginatedHandler(ProjectInfo pi) {
        super(pi);
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "IMSDBInfo.DBName", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), new String[]{"1", Messages.getString(IMSDBPaginatedHandler.class, "noData.message")});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " where IMSDBInfo.DBName");
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZSourceIMSDatabase> inputs = new ArrayList<EZSourceIMSDatabase>();
        String id = null;
        String imsDBName = null;
        Integer type = null;
        for (String[] row : selection) {
            if (row == null) continue;
            id = row[2];
            imsDBName = row[3];
            type = row[4] != null ? Integer.parseInt(row[4]) : 0;
            EZEntityID entity = new EZEntityID();
            entity.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            EZSourceIMSDatabaseIDSg imsdbsg = new EZSourceIMSDatabaseIDSg(imsDBName);
            entity.addSegment((EZSegment)imsdbsg);
            EZSourceIMSDatabase inputType = new EZSourceIMSDatabase();
            inputType.addProperty("IMSDB_DATABASE_TYPE", (Object)type);
            inputType.addProperty("IMSDB_DATABASE_ID", (Object)Integer.parseInt(id));
            inputType.setName(imsDBName);
            inputType.setEntID(entity);
            inputs.add(inputType);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        Integer type = new Integer(0);
        String imsDBName = null;
        String path = null;
        for (String[] row : selection) {
            if (row == null) continue;
            imsDBName = row[3];
            path = row[5];
            try {
                type = Integer.valueOf(row[4]);
            }
            catch (NumberFormatException ex) {
                L.info("wrong IMS/DB type", (Throwable)ex);
            }
            break;
        }
        if (imsDBName != null) {
            int mappedType = Utils.getMappedType4IMSDatabase((Integer)type);
            String stringType = Utils.getExternalizedType4IMSDatabase((Integer)mappedType);
            MainframeGenericNode node = new MainframeGenericNode();
            node.addRow(new String[]{Messages.getString(IMSDBPaginatedHandler.class, "properties.name.label"), imsDBName});
            node.addRow(new String[]{Messages.getString(IMSDBPaginatedHandler.class, "properties.path.label"), path != null ? path : ""});
            node.addRow(new String[]{Messages.getString(IMSDBPaginatedHandler.class, "properties.type.label"), stringType});
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            return new StructuredSelection((Object)entID);
        }
        return super.prepareSelection4Properties(selection);
    }

    @Override
    public void handleDoubleClick(NatTable natTable, NatEventData eventData, int row, String[] rowObject) {
        String path = rowObject[5];
        if (path != null) {
            this.openEditor(10006, path, null, this.pi.getName());
        } else {
            this.reportNoSource(Messages.getString(IMSDBPaginatedHandler.class, "noSource.type.name"), rowObject[3]);
        }
    }
}

