/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandlerWithFilterInBrackets;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.StringUtils;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceDDCLElementIDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;

public class IDMSXSetPaginatedHandler
extends MFPaginatedHandlerWithFilterInBrackets {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String baseQuery = "select s.Id as SchemaId, s.Name as SchemaName, v.ReferenceName as ElementName, v.ReferenceDdsTypeId as ElementType, re.Id as ElementId, \n Paths.PathStr, DDCLSourceInfo.StartRow, DDCLSourceInfo.EndRow \n from DDCLElement s  \n  left join DDCLProperty sp on sp.ElementId = s.Id and sp.Name = 'SETS'  \n left join DDCLValue v on v.PropertyId = sp.Id and v.ValueTypeId = 2 and v.ReferenceDdsTypeId = 10 \n left join DDCLElement re on v.ReferenceName = re.Name and v.ReferenceDdsTypeId = re.DdsTypeId \n left join DDCLSourceInfo on DDCLSourceInfo.Id = re.SourceInfo\n left join Occurrences on Occurrences.ProgID = DDCLSourceInfo.ProgramId\n left join Paths on Occurrences.PathID = Paths.PathID\n where s.DdsTypeId = 6 and v.Id is not null @1@ @2@";
    private String countQuery = "SELECT  count(distinct cast(s.Id as varchar(250)) + v.ReferenceName) as c \n from DDCLElement s  \n  left join DDCLProperty sp on sp.ElementId = s.Id and sp.Name = 'SETS'  \n left join DDCLValue v on v.PropertyId = sp.Id and v.ValueTypeId = 2 and v.ReferenceDdsTypeId = 10 \n left join DDCLElement re on v.ReferenceName = re.Name and v.ReferenceDdsTypeId = re.DdsTypeId \n where s.DdsTypeId = 6 and v.Id is not null @1@ @2@";
    private String idmsName;

    public IDMSXSetPaginatedHandler(ProjectInfo pi, String idmsName) {
        super(pi);
        this.idmsName = idmsName;
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "v.ReferenceName, s.Name", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), new String[]{"1", Messages.getString(IDMSXSetPaginatedHandler.class, "noData.message", new String[]{this.idmsName})});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " and v.ReferenceName", " and s.Name");
    }

    @Override
    public void handleDoubleClick(NatTable natTable, NatEventData eventData, int row, String[] rowObject) {
        String path;
        String string = path = rowObject.length >= 9 ? rowObject[6] : null;
        if (path != null && !path.isEmpty()) {
            int startRow = rowObject.length >= 9 ? Integer.parseInt(rowObject[7]) : 0;
            int endRow = rowObject.length >= 9 ? Integer.parseInt(rowObject[8]) : 0;
            int[] nArray = new int[3];
            nArray[0] = startRow;
            nArray[2] = endRow;
            this.openEditor(14, path, nArray, this.pi.getName());
        } else {
            this.reportNoSource(Messages.getString(IDMSXSetPaginatedHandler.class, "noSource.typeName"), rowObject[3]);
        }
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        String setName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            setName = row[3];
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(76));
            Integer ddclElementId = null;
            if (Utils.filterNullValue((String)row[5]) != null) {
                ddclElementId = Integer.parseInt(row[5]);
            }
            EZSourceDDCLElementIDSg setSg = new EZSourceDDCLElementIDSg(setName, Integer.valueOf(10), ddclElementId);
            inputs.add(inputType);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)setSg);
            inputType.setName(setName);
            inputType.setEntID(entityId);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected Object prepareDataValue(int col, int line, String[] row) {
        String val = super.prepareDataValue(col, line, row).toString();
        if (row != null && row.length > 4) {
            val = row[3];
            String schema = StringUtils.empty2null((String)row[2]);
            schema = schema != null ? " (" + schema + ")" : "";
            val = String.valueOf(val) + schema;
        }
        return val;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String setName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            setName = row[3];
            break;
        }
        if (setName != null) {
            MainframeGenericNode node = new MainframeGenericNode();
            node.addRow(new String[]{Messages.getString(IDMSXSetPaginatedHandler.class, "properties.name.label"), setName});
            node.addRow(new String[]{Messages.getString(IDMSXSetPaginatedHandler.class, "properties.type.label"), Messages.getString(IDMSXSetPaginatedHandler.class, "properties.type.value", new String[]{this.idmsName})});
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            return new StructuredSelection((Object)entID);
        }
        return super.prepareSelection4Properties(selection);
    }

    @Override
    public String getFilterTooltipText() {
        String tooktipText = Messages.getString(IDMSXSetPaginatedHandler.class, "filter.textbox.tooltip");
        return tooktipText;
    }
}

