/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceIDMSRecordIDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class IDMSRecordPaginatedHandler
extends MFPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String MARKER = "@@EZ_MARKER@@";
    private String baseQuery = "select x.SchemaID, x.RecordName from (select distinct SchemaID, RecordName\n\t\t\tFROM         IdmsSubschemaRecords\n\t\t\tinner join IdmsSubschema on IdmsSubschema.ID = IdmsSubschemaRecords.SubschemaId) as x @1@";
    private String countQuery = "SELECT  count(distinct cast(SchemaID as varchar(250)) @@EZ_MARKER@@ RecordName)\n\t\t\tFROM         IdmsSubschemaRecords\n\t\t\tinner join IdmsSubschema on IdmsSubschema.ID = IdmsSubschemaRecords.SubschemaId @1@";
    private String idmsName;

    public IDMSRecordPaginatedHandler(ProjectInfo pi, String idmsName) {
        super(pi);
        this.idmsName = idmsName;
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObjects(filter, " where x.RecordName"));
        query = this.paginate(query, "x.RecordName", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        String concatStr = null;
        Integer dbEngine = (Integer)this.pi.getInfo().get("dbEngine");
        switch (dbEngine) {
            case 2: {
                concatStr = "+";
                break;
            }
            case 3: 
            case 4: {
                concatStr = "||";
                break;
            }
        }
        Assert.isNotNull((Object)concatStr);
        this.countQuery = this.countQuery.replaceAll(MARKER, concatStr);
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), new String[]{"1", Messages.getString(IDMSRecordPaginatedHandler.class, "noData.message", new String[]{this.idmsName})});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " where IdmsSubschemaRecords.RecordName");
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        String recordName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            recordName = row[3];
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(75));
            inputs.add(inputType);
            EZSourceIDMSRecordIDSg recordSg = new EZSourceIDMSRecordIDSg(recordName);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)recordSg);
            inputType.setName(recordName);
            inputType.setEntID(entityId);
            inputType.addProperty("mainframe resource id sg", (Object)recordSg);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String recordName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            recordName = row[3];
            break;
        }
        if (recordName != null) {
            MainframeGenericNode node = new MainframeGenericNode();
            node.addRow(new String[]{Messages.getString(IDMSRecordPaginatedHandler.class, "properties.name.label"), recordName});
            node.addRow(new String[]{Messages.getString(IDMSRecordPaginatedHandler.class, "properties.type.label"), Messages.getString(IDMSRecordPaginatedHandler.class, "properties.type.value", new String[]{this.idmsName})});
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            return new StructuredSelection((Object)entID);
        }
        return super.prepareSelection4Properties(selection);
    }
}

