/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandlerWithFilterInBrackets;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.config.inputs.EZSourceDataset;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.StringUtils;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DatasetPaginatedHandler
extends MFPaginatedHandlerWithFilterInBrackets {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DATASET_ID_COLUMN = 1;
    private static final int DATASET_NAME_COLUMN = 2;
    private static final int DATASET_GENERATION_NUMBER_COLUMN = 3;
    private static final int DATASET_MEMBER_NAME_COLUMN = 4;
    private static final int DATASET_ISLIB = 5;
    private static final int DATASET_ISCICS = 6;
    private String baseQuery = "SELECT datasetid, datasetname, generationnumber, membername, isLib, isCICS FROM (SELECT DISTINCT \n jpds.DataSetID, jpds.DataSetName, \nCASE WHEN jpds.IsGeneration = '1' THEN jpds.GenerationNumber \n ELSE CAST(NULL as INTEGER) \nEND AS GenerationNumber, NULLIF(src.MemberName, '') AS MemberName, CASE WHEN src.DDName IN ('STEPLIB', 'JOBLIB', 'PROCLIB') THEN 1 \n ELSE 0 END AS isLib, \n 0 AS isCICS \n FROM JCLPhysicalDataSet jpds\n     INNER JOIN (SELECT jref.DataSetID, jref.MemberName, jd.DDName \n \t\t\t\tFROM JCLDDRef jref INNER JOIN JCLDD jd ON jref.DDID = jd.DDID \n \t\t\tUNION SELECT idu.DataSetID, idu.MemberName as MemberName, idu.DDName \n \t\t\t\tFROM JCLIDCAMSDatasetUsages idu \n)src ON src.DataSetID = jpds.DataSetID \n\t WHERE (jpds.IsInstream <> 1) \n\tUNION SELECT CAST(NULL as INTEGER) AS DataSetID, mf.DSName AS DataSetName, CAST(NULL as INTEGER) AS GenerationNumber, \n\t\tCAST(NULL as VARCHAR(50)) AS MemberName, 0 AS isLib, \n 1 AS isCICS \n\t\tFROM MFCICSFile mf \n\t\tINNER JOIN Files f on mf.DDName = f.LogicalName AND f.TypeCode IS NULL AND (mf.DSName IS NOT NULL AND mf.DSName <> '') \n) as distinctSelect WHERE @1@ @2@ ";
    private String baseQueryNoTemp = "SELECT datasetid, datasetname, generationnumber, membername, isLib, isCICS FROM (SELECT DISTINCT \n jpds.DataSetID, jpds.DataSetName, \nCASE WHEN jpds.IsGeneration = '1' THEN jpds.GenerationNumber \n ELSE CAST(NULL as INTEGER) \nEND AS GenerationNumber, NULLIF(src.MemberName, '') AS MemberName, CASE WHEN src.DDName IN ('STEPLIB', 'JOBLIB', 'PROCLIB') THEN 1 \n ELSE 0 END AS isLib, \n 0 AS isCICS \n FROM JCLPhysicalDataSet jpds\n     INNER JOIN (SELECT jref.DataSetID, jref.MemberName, jd.DDName \n \t\t\t\tFROM JCLDDRef jref INNER JOIN JCLDD jd ON jref.DDID = jd.DDID \n \t\t\tUNION SELECT idu.DataSetID, idu.MemberName as MemberName, idu.DDName \n \t\t\t\tFROM JCLIDCAMSDatasetUsages idu )src ON src.DataSetID = jpds.DataSetID \n\t WHERE (jpds.IsInstream <> 1) AND (jpds.IsTemp <> 1) \n\tUNION SELECT CAST(NULL as INTEGER) AS DataSetID, mf.DSName AS DataSetName, CAST(NULL as INTEGER) AS GenerationNumber, \n\t\tCAST(NULL as VARCHAR(50)) AS MemberName, 0 AS isLib,\n 1 AS isCICS \n\t\tFROM MFCICSFile mf \n\t\tINNER JOIN Files f on mf.DDName = f.LogicalName and f.TypeCode IS NULL AND (mf.DSName IS NOT NULL AND mf.DSName <> '') \n) as distinctSelect WHERE @1@ @2@";
    private String countQuery = "SELECT count(*)\nFROM (" + this.baseQuery + ") as countRows";
    private String countQueryNoTemp = "SELECT count(*)\nFROM (" + this.baseQueryNoTemp + ") as countRows";
    private IPropertyChangeListener tempDatasetsListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("displayTemporaryDatasets".equals(property)) {
                DatasetPaginatedHandler.this.setFilter(DatasetPaginatedHandler.this.getFilter(), true);
            }
        }
    };

    public DatasetPaginatedHandler(ProjectInfo pi) {
        super(pi);
        PreferenceUtils.getPreferenceStore().addPropertyChangeListener(this.tempDatasetsListener);
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        boolean showTemporaryDatasets = PreferenceUtils.getPreferenceStore().getBoolean("displayTemporaryDatasets");
        String query = this.prepare(showTemporaryDatasets ? this.baseQuery : this.baseQueryNoTemp, this.getParamObjects(filter));
        query = this.paginate(query, "DataSetName,MemberName,GenerationNumber", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        boolean showTemporaryDatasets = PreferenceUtils.getPreferenceStore().getBoolean("displayTemporaryDatasets");
        return new CounterRunnable(this.prepare(showTemporaryDatasets ? this.countQuery : this.countQueryNoTemp, this.getParamObjects(filter)), new String[]{"1", Messages.getString(DatasetPaginatedHandler.class, "noData.message")});
    }

    private Object[][] getParamObjects(ISQLFilter filter) {
        return this.getParamObjects(filter, " DataSetName", " and MemberName");
    }

    @Override
    protected Object prepareDataValue(int col, int line, String[] row) {
        String val;
        Object obj = super.prepareDataValue(col, line, row);
        String string = val = obj != null ? obj.toString() : null;
        if (row != null && row.length > 2) {
            val = row[2];
            String generationNumber = row[3];
            generationNumber = generationNumber != null && !generationNumber.isEmpty() ? "(" + generationNumber + ")" : "";
            String datasetMemberName = StringUtils.empty2null((String)row[4]);
            datasetMemberName = datasetMemberName != null ? " (" + datasetMemberName + ")" : "";
            val = String.valueOf(val) + generationNumber + datasetMemberName;
        }
        return val;
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZSourceDataset> inputs = new ArrayList<EZSourceDataset>();
        String datasetId = null;
        String datasetName = null;
        String generationNumber = null;
        String datasetMemberName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            datasetId = row[1];
            Integer dsID = datasetId != null ? Integer.valueOf(datasetId) : null;
            datasetName = row[2];
            generationNumber = row[3];
            datasetMemberName = StringUtils.null2empty((String)row[4]);
            EZSourceDataset inputType = new EZSourceDataset();
            String isLib = row[5];
            String isCICS = row[6];
            inputType.addProperty("holds the load modules of the program to be executed in the JCL", (Object)("1".equals(isLib) ? Boolean.TRUE : Boolean.FALSE));
            inputType.addProperty("dataset from File Control Table, FCT", (Object)("1".equals(isCICS) ? Boolean.TRUE : Boolean.FALSE));
            inputs.add(inputType);
            EZSourceDatasetIDSg datasetSg = new EZSourceDatasetIDSg(datasetName, dsID, datasetMemberName, StringUtils.parseInt((String)generationNumber));
            datasetSg.setIncompleteSegment(true);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)datasetSg);
            inputType.setName(datasetName);
            inputType.setEntID(entityId);
            inputType.addProperty("mainframe resource id sg", (Object)datasetSg);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String datasetName = null;
        String generationNumber = null;
        String datasetMemberName = null;
        String isCICS = null;
        for (String[] row : selection) {
            if (row == null) continue;
            datasetName = row[2];
            generationNumber = row[3];
            datasetMemberName = StringUtils.empty2null((String)row[4]);
            isCICS = row[6];
            break;
        }
        if (datasetName != null) {
            MainframeGenericNode node = new MainframeGenericNode();
            node.addRow(new String[]{Messages.getString(DatasetPaginatedHandler.class, "properties.name.label"), datasetName});
            node.addRow(new String[]{Messages.getString(DatasetPaginatedHandler.class, "properties.generationNumber.label"), generationNumber});
            node.addRow(new String[]{Messages.getString(DatasetPaginatedHandler.class, "properties.datasetMemberName.label"), datasetMemberName});
            if (("1".equals(isCICS) ? Boolean.TRUE : Boolean.FALSE).booleanValue()) {
                node.addRow(new String[]{Messages.getString(DatasetPaginatedHandler.class, "properties.datasettype.label"), "CICS"});
            }
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            return new StructuredSelection((Object)entID);
        }
        return super.prepareSelection4Properties(selection);
    }

    @Override
    protected void onClose() {
        PreferenceUtils.getPreferenceStore().removePropertyChangeListener(this.tempDatasetsListener);
    }

    @Override
    public String getFilterTooltipText() {
        String tooktipText = Messages.getString(DatasetPaginatedHandler.class, "filter.textbox.tooltip");
        return tooktipText;
    }
}

