/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.config.inputs.EZSourceDatacom;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceDatacomTableIDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DatacomPaginatedHandler
extends MFPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String baseQuery = "select DatacomTables.ID, DatacomTables.TableName FROM DatacomTables  @1@";
    private String countQuery = "SELECT count(DatacomTables.ID) FROM DatacomTables\n @1@";

    public DatacomPaginatedHandler(ProjectInfo pi) {
        super(pi);
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "DatacomTables.TableName", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), new String[]{"1", Messages.getString(DatacomPaginatedHandler.class, "noData.message")});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " where DatacomTables.TableName");
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZSourceDatacom> inputs = new ArrayList<EZSourceDatacom>();
        String datacomName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            datacomName = row[3];
            EZSourceDatacom inputType = new EZSourceDatacom();
            inputs.add(inputType);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            EZSourceDatacomTableIDSg datacomSg = new EZSourceDatacomTableIDSg(datacomName);
            entityId.addSegment((EZSegment)datacomSg);
            inputType.setName(datacomName);
            inputType.setEntID(entityId);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String datacomName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            datacomName = row[3];
            break;
        }
        if (datacomName != null) {
            MainframeGenericNode node = new MainframeGenericNode();
            node.addRow(new String[]{Messages.getString(DatacomPaginatedHandler.class, "properties.name.label"), datacomName});
            node.addRow(new String[]{Messages.getString(DatacomPaginatedHandler.class, "properties.type.label"), Messages.getString(DatacomPaginatedHandler.class, "properties.type.value")});
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            return new StructuredSelection((Object)entID);
        }
        return super.prepareSelection4Properties(selection);
    }
}

