/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandlerWithFilterInBrackets;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.data.impl.SQLFilter;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.model.segments.EZSourceDDCLElementIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSRecordIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSSetIDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDCLElementsPaginatedHandler
extends MFPaginatedHandlerWithFilterInBrackets {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DDCLElementsPaginatedHandler.class);
    private static final String idmsxViewName = "EZViewer_IDMSX_View";
    private static final String idmsxCacheTableName = "cacheEZViewer_IDMSX_View";
    private String baseQuery = "select DDCLElement.id, DDCLElement.Name, DDCLElement.DdsTypeId, DDCLDDsType.Name as TypeName,  Paths.PathStr, DDCLSourceInfo.StartRow, DDCLSourceInfo.EndRow, cacheEZViewer_IDMSX_View.SchemaName \n   from DDCLElement \n\t      inner join DDCLDdsType on DDCLDdsType.Id = DDCLElement.DdsTypeId\n\t\tinner join DDCLSourceInfo on DDCLSourceInfo.Id = DDCLElement.SourceInfo\n\t\tinner join Occurrences on Occurrences.ProgID = DDCLSourceInfo.ProgramId\n\t\tinner join Paths on Occurrences.PathID = Paths.PathID\n\t\tleft join cacheEZViewer_IDMSX_View on (DDCLElement.Name = cacheEZViewer_IDMSX_View.ElementName and (DDCLElement.DdsTypeId=3 OR DDCLElement.DdsTypeId=10))\n   where IsLocal = 0 @1@ @2@ @3@";
    private String countQuery = "select count(DDCLElement.id)\n   from DDCLElement @4@\n\t\tleft join cacheEZViewer_IDMSX_View on (DDCLElement.Name = cacheEZViewer_IDMSX_View.ElementName and (DDCLElement.DdsTypeId=3 OR DDCLElement.DdsTypeId=10))\n   where IsLocal = 0 @1@ @2@ @3@";
    private String[][] types;
    private Combo elementTypeCombo;
    int selected = -1;
    String[] selectedData = null;

    public DDCLElementsPaginatedHandler(ProjectInfo pi) {
        super(pi);
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    public void createCustomArea(Composite customArea) {
        customArea.setLayout((Layout)new RowLayout());
        Label l = new Label(customArea, 0);
        l.setText(Messages.getString(DDCLElementsPaginatedHandler.class, "elementType.label"));
        this.elementTypeCombo = new Combo(customArea, 4);
        RowData gridData = new RowData();
        gridData.width = 200;
        this.elementTypeCombo.setLayoutData((Object)gridData);
        this.elementTypeCombo.add(Messages.getString(DDCLElementsPaginatedHandler.class, "elementType.noFilter"));
        this.addTypesToGui();
        this.elementTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDCLElementsPaginatedHandler.this.updateFilter();
            }
        });
        this.updateFilter();
    }

    @Override
    protected IMFProjectHandler getProjectHandler() {
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(this.project, null);
        return ph;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "DDCLElement.Name, cacheEZViewer_IDMSX_View.SchemaName", start, end, filter);
        return new PagedRunnable(query, idmsxViewName);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        String noData = Messages.getString(DDCLElementsPaginatedHandler.class, "noData.message");
        if (this.selected > 0 && this.selectedData != null) {
            noData = Messages.getString(DDCLElementsPaginatedHandler.class, "noData.elementType.message", new String[]{this.selectedData[1]});
        }
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), idmsxViewName, new String[]{"1", noData});
    }

    @Override
    public ISQLFilter newFilter(boolean ascending) {
        DDCLFilter newFilter = new DDCLFilter(ascending);
        if (this.elementTypeCombo != null && this.elementTypeCombo.isDisposed()) {
            this.elementTypeCombo = null;
        }
        if (this.elementTypeCombo != null) {
            this.selected = this.elementTypeCombo.getSelectionIndex();
            newFilter.elementType = (String[])this.elementTypeCombo.getData("" + this.selected);
            this.selectedData = newFilter.elementType;
        }
        return newFilter;
    }

    @Override
    protected IMFRunnable newInitializerRunnable() {
        return new IMFRunnable(){

            public void run(EZSourceConnection conn, IProgressMonitor monitor) {
                try {
                    DDCLElementsPaginatedHandler.this.types = conn.executeSQL("select id, Name from dDCLDDsType where id > 0 order by Name");
                    if (DDCLElementsPaginatedHandler.this.types != null) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DDCLElementsPaginatedHandler.this.addTypesToGui();
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    L.error("could not get element types", t);
                }
            }
        };
    }

    private void updateFilter() {
        HashMap<String, Object> emptyData = new HashMap<String, Object>(){
            {
                this.put("selection", new StructuredSelection());
            }
        };
        this.setContextData((Map<String, Object>)emptyData);
        ISQLFilter filter = this.getFilter();
        if (filter != null) {
            DDCLFilter newFilter = new DDCLFilter(filter);
            this.selected = this.elementTypeCombo.getSelectionIndex();
            newFilter.elementType = (String[])this.elementTypeCombo.getData("" + this.selected);
            this.selectedData = newFilter.elementType;
            this.setFilter(newFilter);
        }
    }

    private void addTypesToGui() {
        if (this.types != null) {
            int i = 0;
            while (i < this.types.length) {
                this.elementTypeCombo.add(this.types[i][1]);
                this.elementTypeCombo.setData("" + (i + 1), (Object)this.types[i]);
                ++i;
            }
        }
        this.elementTypeCombo.select(this.selected < 0 ? 0 : this.selected);
        this.selectedData = (String[])this.elementTypeCombo.getData("" + this.selected);
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        String typeClause = "";
        if (filter instanceof DDCLFilter) {
            DDCLFilter f = (DDCLFilter)filter;
            if (f.elementType != null) {
                typeClause = " and DDCLDDsType.Name = '" + f.elementType[1] + "'";
            }
        }
        Object[][] par1 = this.getParamObjects(filter, " and DDCLElement.Name ", " and cacheEZViewer_IDMSX_View.SchemaName");
        Object[][] ret = (Object[][])Arrays.copyOf(par1, 4);
        ret[2] = new Object[]{new Integer(2), typeClause};
        ret[3] = new Object[]{new Integer(2), typeClause.isEmpty() ? "" : " inner join DDCLDdsType on DDCLDdsType.Id = DDCLElement.DdsTypeId\n"};
        return ret;
    }

    @Override
    public void handleDoubleClick(NatTable natTable, NatEventData eventData, int row, String[] rowObject) {
        String path = null;
        int startRow = 0;
        int endRow = 0;
        if (rowObject.length >= 9) {
            path = rowObject[5];
            startRow = Integer.parseInt(rowObject[6]);
            endRow = Integer.parseInt(rowObject[7]);
        }
        if (path != null) {
            int[] nArray = new int[3];
            nArray[0] = startRow;
            nArray[2] = endRow;
            this.openEditor(14, path, nArray, this.pi.getName());
        } else {
            this.reportNoSource(Messages.getString(DDCLElementsPaginatedHandler.class, "noSource.typeName"), rowObject[1]);
        }
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        String ddclElementName = null;
        String ddclTypeId = null;
        String ddclElementId = null;
        for (String[] row : selection) {
            if (row == null) continue;
            ddclElementId = row[1];
            ddclElementName = row[2];
            ddclTypeId = row[3];
            Integer elemId = Integer.parseInt(ddclElementId);
            Integer typeId = Integer.parseInt(ddclTypeId);
            EZEntityID entity = new EZEntityID();
            entity.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            EZObjectType inputType = null;
            if (Utils.filterNullValue((String)row[8]) != null) {
                EZSourceIDMSRecordIDSg idmsxSg;
                if (3 == typeId) {
                    inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(75));
                    idmsxSg = new EZSourceIDMSRecordIDSg(ddclElementName);
                    entity.addSegment((EZSegment)idmsxSg);
                } else if (10 == typeId) {
                    inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(76));
                    idmsxSg = new EZSourceIDMSSetIDSg(ddclElementName);
                    entity.addSegment((EZSegment)idmsxSg);
                }
            } else {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(typeId, "EZ_OBJECT_TYPE_FOR_DDCL_ELEMENT");
            }
            inputType.setName(ddclElementName);
            EZSourceDDCLElementIDSg elemSg = new EZSourceDDCLElementIDSg(ddclElementName, typeId, elemId);
            entity.addSegment((EZSegment)elemSg);
            inputType.setEntID(entity);
            inputs.add(inputType);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected Object prepareDataValue(int col, int line, String[] row) {
        String val = "";
        if (row == null) {
            val = Messages.getString(DDCLElementsPaginatedHandler.class, "loadingData.message", new String[]{String.valueOf(line)});
        } else if (row.length > 2) {
            String schema;
            val = row[2];
            if (row.length > 8 && Utils.filterNullValue((String)(schema = row[8])) != null) {
                val = Messages.getString(DDCLElementsPaginatedHandler.class, "idmsx.label", new String[]{val, schema});
            }
        } else {
            val = row[1];
        }
        return val;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String ddclElementName = null;
        Integer typeId = null;
        String typeName = null;
        String path = null;
        for (String[] row : selection) {
            if (row == null) continue;
            ddclElementName = row[2];
            String ddclTypeId = row[3];
            typeId = Integer.parseInt(ddclTypeId);
            if (Utils.filterNullValue((String)row[8]) != null) {
                if (3 == typeId) {
                    typeName = Messages.getString(DDCLElementsPaginatedHandler.class, "idmsxRecord.typeName");
                } else if (10 == typeId) {
                    typeName = Messages.getString(DDCLElementsPaginatedHandler.class, "idmsxSet.typeName");
                }
            } else {
                typeName = row[4];
            }
            path = row[5];
            break;
        }
        if (ddclElementName != null) {
            MainframeGenericNode node = new MainframeGenericNode();
            node.addRow(new String[]{Messages.getString(DDCLElementsPaginatedHandler.class, "properties.name.label"), ddclElementName});
            node.addRow(new String[]{Messages.getString(DDCLElementsPaginatedHandler.class, "properties.type.label"), typeName});
            node.addRow(new String[]{Messages.getString(DDCLElementsPaginatedHandler.class, "properties.path.label"), path != null ? path : ""});
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            return new StructuredSelection((Object)entID);
        }
        return super.prepareSelection4Properties(selection);
    }

    @Override
    public String getFilterTooltipText() {
        return null;
    }

    class DDCLFilter
    extends SQLFilter {
        String[] elementType;

        public DDCLFilter(ISQLFilter filter) {
            super(filter.isAscending());
            this.setUIText(filter.getUIText());
        }

        public DDCLFilter(boolean ascending) {
            super(ascending);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + Arrays.hashCode(this.elementType);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DDCLFilter other = (DDCLFilter)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return Arrays.equals(this.elementType, other.elementType);
        }

        private DDCLElementsPaginatedHandler getOuterType() {
            return DDCLElementsPaginatedHandler.this;
        }
    }
}

