/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceDALIDSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DALPaginatedHandler
extends MFPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String baseQuery = "SELECT Resources.ResourceID, Resources.Name, Resources.OccurID\nFROM         Resources left JOIN Occurrences \n                             ON Resources.OccurID = Occurrences.OccurID  \n\t\t\t  WHERE Resources.ResourceType = 189 and (Resources.OccurID <> -1) @1@";
    private String countQuery = "SELECT count(Resources.ResourceID) \nFROM         Resources left JOIN Occurrences \n                             ON Resources.OccurID = Occurrences.OccurID  \n\t\t\t  WHERE Resources.ResourceType = 189 and (Resources.OccurID <> -1)  @1@";

    public DALPaginatedHandler(ProjectInfo pi) {
        super(pi);
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    public AnalysisType getOperationType() {
        return AnalysisType.DAL_USAGE_ACTION;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "Resources.Name", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), new String[]{"1", Messages.getString(DALPaginatedHandler.class, "noData.message")});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " and Resources.Name");
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        String dalName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            dalName = row[3];
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(189), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            inputs.add(inputType);
            EZSourceDALIDSg tableSg = new EZSourceDALIDSg(dalName);
            tableSg.setVirtual(row[4]);
            inputType.setName(dalName);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)tableSg);
            inputType.setEntID(entityId);
            inputType.addProperty("mainframe resource id sg", (Object)tableSg);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String dalName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            dalName = row[3];
            break;
        }
        MainframeGenericNode node = new MainframeGenericNode();
        node.addRow(new String[]{Messages.getString(DALPaginatedHandler.class, "properties.name.label"), dalName});
        node.addRow(new String[]{Messages.getString(DALPaginatedHandler.class, "properties.type.label"), Messages.getString(DALPaginatedHandler.class, "properties.type.value")});
        EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
        EZEntityID entID = new EZEntityID();
        entID.addSegment((EZSegment)sg);
        return new StructuredSelection((Object)entID);
    }
}

