/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandlerWithFilterInBrackets;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.StringUtils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.ControlmJobSg;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class CtrlMJobPaginatedHandler
extends MFPaginatedHandlerWithFilterInBrackets {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int JOB_GENERAL_ID = 1;
    private static final int JOB_NAME_COLUMN = 2;
    private static final int JOB_APPLICATION = 3;
    private static final int JOB_FOLDER_NAME = 4;
    private String baseQuery = "SELECT CTM_JobDetails.JobGeneralID, CTM_JobDetails.JobName, CTM_JobDetails.JobApplication, CTM_JobDetails.JobFolderName \nFROM CTM_JobDetails WHERE @1@ @2@ ";
    private String countQuery = "SELECT count(JobGeneralID) \nFROM CTM_JobDetails WHERE @1@ @2@ ";

    public CtrlMJobPaginatedHandler(ProjectInfo pi) {
        super(pi);
    }

    @Override
    public AnalysisType getOperationType() {
        return AnalysisType.EZSOURCE_CTRLM_EXPLORE_ANALYSIS;
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "CTM_JobDetails.JobName, CTM_JobDetails.JobApplication, CTM_JobDetails.JobFolderName ", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), new String[]{"1", Messages.getString(CtrlMJobPaginatedHandler.class, "noData.message")});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, " JobName", " and JobApplication + '-'+ JobFolderName ");
    }

    @Override
    protected Object prepareDataValue(int col, int line, String[] row) {
        String val;
        Object obj = super.prepareDataValue(col, line, row);
        String string = val = obj != null ? obj.toString() : null;
        if (row != null && row.length > 2) {
            val = row[2];
            String application = row[3];
            application = application != null && !application.isEmpty() && application != "" ? " (" + application : " (N/A";
            String database = StringUtils.empty2null((String)row[4]);
            database = database != null ? "-" + database + ")" : "";
            val = String.valueOf(val) + application + database;
        }
        return val;
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        Integer jobGeneralId = null;
        String jobName = null;
        String jobApplication = null;
        String jobFolderName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            jobGeneralId = Integer.valueOf(row[1]);
            jobName = row[2];
            jobApplication = row[3];
            jobFolderName = row[4];
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(224), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            inputs.add(inputType);
            ControlmJobSg jobSg = new ControlmJobSg(jobGeneralId, jobName, jobApplication, jobFolderName, null, null, null);
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            entityId.addSegment((EZSegment)jobSg);
            inputType.setName(jobName);
            inputType.setEntID(entityId);
            inputType.addProperty("mainframe resource id sg", (Object)jobSg);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String jobName = null;
        String jobApplication = null;
        String jobFolderName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            jobName = row[2];
            jobApplication = row[3];
            jobFolderName = row[4];
            break;
        }
        MainframeGenericNode node = new MainframeGenericNode();
        node.addRow(new String[]{Messages.getString(CtrlMJobPaginatedHandler.class, "properties.name.label"), jobName});
        node.addRow(new String[]{Messages.getString(CtrlMJobPaginatedHandler.class, "properties.application.label"), jobApplication});
        node.addRow(new String[]{Messages.getString(CtrlMJobPaginatedHandler.class, "properties.database.label"), jobFolderName});
        node.addRow(new String[]{Messages.getString(CtrlMJobPaginatedHandler.class, "properties.type.label"), Messages.getString(CtrlMJobPaginatedHandler.class, "properties.type.value")});
        EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
        EZEntityID entID = new EZEntityID();
        entID.addSegment((EZSegment)sg);
        return new StructuredSelection((Object)entID);
    }

    @Override
    public String getFilterTooltipText() {
        String tooktipText = Messages.getString(CtrlMJobPaginatedHandler.class, "filter.textbox.tooltip");
        return tooktipText;
    }
}

