/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.explore.data.impl.handlers;

import com.ez.analysis.mainframe.explore.data.ICounterRunnable;
import com.ez.analysis.mainframe.explore.data.IPagedRunnable;
import com.ez.analysis.mainframe.explore.data.ISQLFilter;
import com.ez.analysis.mainframe.explore.data.impl.CounterRunnable;
import com.ez.analysis.mainframe.explore.data.impl.MFPaginatedHandler;
import com.ez.analysis.mainframe.explore.data.impl.PagedRunnable;
import com.ez.analysis.mainframe.explore.internal.Messages;
import com.ez.analysis.mainframe.explore.properties.MainframeGenericNode;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceTransactionIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class CICSTransactionPaginatedHandler
extends MFPaginatedHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String baseQuery = "SELECT tr.TransactionName \nFROM \n(SELECT   Resources.Name AS TransactionName \nFROM         Resources \nWHERE     (ResourceType = 14) \nUNION \nSELECT  DISTINCT MFCICSTransaction.TransCode AS TransactionName \nFROM MFCICSList INNER JOIN \nMFCICSListVsGroup ON MFCICSList.ListID = MFCICSListVsGroup.ListID INNER JOIN \nMFCICSGroup ON MFCICSListVsGroup.GroupID = MFCICSGroup.GroupID INNER JOIN \nMFCICSGroupVsEntity ON MFCICSGroup.GroupID = MFCICSGroupVsEntity.GroupID INNER JOIN \nMFCICSGroupVsEntityLinks ON MFCICSGroupVsEntity.EntityID = MFCICSGroupVsEntityLinks.EntityID INNER JOIN \nMFCICSTransaction ON MFCICSGroupVsEntityLinks.TransID = MFCICSTransaction.TransID \nINNER JOIN MFCICSProgram cp ON cp.ProgID = MFCICSTransaction.ProgID AND MFCICSTransaction.ProgID >= 0 \nINNER JOIN ProgramAliases pa ON UPPER(cp.ProgName) = UPPER(pa.AliasName) AND pa.AliasType = 0 \nWHERE (MFCICSGroupVsEntity.EntityTypeID = 2) \n)tr @1@";
    private String countQuery = "SELECT count(DISTINCT TransactionName) \nFROM \n(SELECT   Resources.Name AS TransactionName \nFROM         Resources \nWHERE     (ResourceType = 14) \nUNION \nSELECT   MFCICSTransaction.TransCode AS TransactionName \nFROM MFCICSList INNER JOIN \nMFCICSListVsGroup ON MFCICSList.ListID = MFCICSListVsGroup.ListID INNER JOIN \nMFCICSGroup ON MFCICSListVsGroup.GroupID = MFCICSGroup.GroupID INNER JOIN \nMFCICSGroupVsEntity ON MFCICSGroup.GroupID = MFCICSGroupVsEntity.GroupID INNER JOIN \nMFCICSGroupVsEntityLinks ON MFCICSGroupVsEntity.EntityID = MFCICSGroupVsEntityLinks.EntityID INNER JOIN \nMFCICSTransaction ON MFCICSGroupVsEntityLinks.TransID = MFCICSTransaction.TransID \nINNER JOIN MFCICSProgram cp ON cp.ProgID = MFCICSTransaction.ProgID AND MFCICSTransaction.ProgID >= 0 \nINNER JOIN ProgramAliases pa ON UPPER(cp.ProgName) = UPPER(pa.AliasName) AND pa.AliasType = 0 \nWHERE (MFCICSGroupVsEntity.EntityTypeID = 2) \n)tr @1@";

    public CICSTransactionPaginatedHandler(ProjectInfo pi) {
        super(pi);
    }

    public int getColumnCount() {
        return 1;
    }

    @Override
    protected IPagedRunnable newPagedRunnable(ISQLFilter filter, int start, int end) {
        String query = this.prepare(this.baseQuery, this.getParamObject(filter));
        query = this.paginate(query, "tr.TransactionName", start, end, filter);
        return new PagedRunnable(query);
    }

    @Override
    protected ICounterRunnable newCounterRunnable(ISQLFilter filter) {
        return new CounterRunnable(this.prepare(this.countQuery, this.getParamObject(filter)), new String[]{"1", Messages.getString(CICSTransactionPaginatedHandler.class, "noData.message")});
    }

    private Object[][] getParamObject(ISQLFilter filter) {
        return this.getParamObjects(filter, "where tr.TransactionName");
    }

    @Override
    protected Map<String, Object> prepareContextData(IStructuredSelection selection) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        String tranName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            tranName = row[2];
            EZEntityID entity = new EZEntityID();
            entity.addSegment((EZSegment)new EZSourceProjectIDSg(this.pi));
            EZSourceTransactionIDSg trIdSg = new EZSourceTransactionIDSg(tranName);
            entity.addSegment((EZSegment)trIdSg);
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(14), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            inputType.setName(tranName);
            inputType.setEntID(entity);
            inputs.add(inputType);
        }
        data.put("ANALYSIS_TYPE_INPUTS", inputs);
        return data;
    }

    @Override
    protected StructuredSelection prepareSelection4Properties(IStructuredSelection selection) {
        String tranName = null;
        for (String[] row : selection) {
            if (row == null) continue;
            tranName = row[2];
            break;
        }
        if (tranName != null) {
            MainframeGenericNode node = new MainframeGenericNode();
            node.addRow(new String[]{Messages.getString(CICSTransactionPaginatedHandler.class, "properties.name.label"), tranName});
            node.addRow(new String[]{Messages.getString(CICSTransactionPaginatedHandler.class, "properties.type.label"), Messages.getString(CICSTransactionPaginatedHandler.class, "properties.type.value")});
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            return new StructuredSelection((Object)entID);
        }
        return super.prepareSelection4Properties(selection);
    }
}

